/*+-----------------------------------------------------------------
Class = MCSControl

:Overview
Initialize and do message dispatching for user applications.

:Prototype In
| mds.h

:Description
An ^LMCSControl^N object furnishes initialization, message queuing, and message dispatching, for both repeater applications and user applications. The ^LMCSControl^N object creates a message queue for its applications and dispatches messages to the application callback function, if one is specified.

:See Also
^XMCSInitialize^N

-----------------------------------------------------------------+*/


/*+-----------------------------------------------------------------
Data Type  = MCSAddress

:Overview   
  A structure containing a transport protocol and an address.

:Syntax     
  |typedef struct
  |{
  |   unsigned short        transport_identifier;
  |	MCSTransportAddress   transport_address;
  |} MCSAddress;

:Defined In   
  |mds.h

:Description    
  The data type ^LMCSAddress^n is a structure that is used to specify a transport stack protocol and a network address for a network repeater.

:Fields    
  ^Ltransport_identifier^N identifies the transport stack protocol. The valid values are:
  @  ^LMCS_TRANSPORT_TCP^N -transport control protocol, for both user and repeater communications
  @  ^LMCS_TRANSPORT_RMTP^N - reliable multicast transport protocol, for user communication
  @  ^LMCS_TRANSPORT_RMP^N - reliable multicast protocol, for repeater communication
^Ltransport_address^N is a NULL terminated string specifying a network address in the form hostname:port.

:See Also   
MCSTransportAddress


-----------------------------------------------------------------+*/


/*+-----------------------------------------------------------------

C++ Method  = MCSInitialize

:Overview  
  This method is used to initialize a remote user application.

:Prototype 
  |MCSError MCSInitialize
  |(
  |	MCSVersion       mcs_version_requested,         // INPUT
  |	MCSVersion       *mcs_high_version,             // OUTPUT
  |	MCSVersion       *mcs_version,                  // OUTPUT
  |);

:Prototype In  
  |mds.h

:Description  
The C++ method ^LMCSInitialize()^N initializes the remote user's ^XMCSControl^N object and returns the negotiated version of MDS. 

:Parameters  
  ^Lmcs_version_requested^N - the version of the MDS API which the application requires
  ^Lmcs_high_version^N - a pointer to a structure containing the highest version of MDS which the repeater supports
  ^Lmcs_version^N - a pointer to a structure containing the version that will be used; the smaller of the mcs_version_requested and the mcs_high_version; 

:Return Value 
  @  If successful, this method returns the value ^LMCSERROR_NO_ERROR^N. A non-zero return indicates the specific failure condition.
  @  ^LMCSERROR_ADDRESS_IN_USE^N - Attempting to use an address that is already in use.
  @  ^LMCSERROR_ALLOCATION_FAILURE^N - The MDS system encountered a memory allocation failure while initializing the application.
  @  ^LMCSERROR_ALREADY_REGISTERED^N - The application has already been initialized by the MDS system.
  @  ^LMCSERROR_GLOBAL_MANAGER_NOT_RESPONDING^N - The global manager is not responding to requests.
  @  ^LMCSERROR_INVALID_PARAMETER^N - One of the parameters to the request is invalid.
  @  ^LMCSERROR_NO_ERROR^N - The function call was successful.
  @  ^LMCSERROR_NO_REPEATER_PROFILE^N - The repeater profile is not available.
  @  ^LMCSERROR_TRANSPORT_NOT_INITIALIZED^N - The transport process has not been initialized
  @  ^LMCSERROR_VERSION_NOT_SUPPORTED^N - The version of MDS requested is not supported.

:Example   
  - REQUIRED - 
  The following example shows the method code in use....

:See Also   
^XMCSControl^N

-----------------------------------------------------------------+*/


