// DialogDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Dialog.h"
#include "DialogDlg.h"
#include "Thread.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern BOOL __stdcall DllOnTimer(void);

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDialogDlg dialog

CDialogDlg::CDialogDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDialogDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDialogDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
  Thread = new TTestThread();
  AGENT(MT_WINDOW, "CDialogDlg::Constructor",0);
}

CDialogDlg::~CDialogDlg()
{
  delete Thread;
  AGENT(MT_WINDOW, "CDialogDlg::Destructor",0);
}

void CDialogDlg::DoDataExchange(CDataExchange* pDX)
{
  AGENT(MT_WINDOW, "DoDataExchange",0);
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDialogDlg)
	DDX_Control(pDX, IDC_THREADTMO, ThreadTmoEd);
	DDX_Control(pDX, IDC_THREAD, ThreadCb);
	DDX_Control(pDX, IDC_PROGRESS, Progress);
	DDX_Control(pDX, IDC_STARTSTOP, StartStopCb);
	DDX_Control(pDX, IDC_TIMEOUT, TimeoutEd);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDialogDlg, CDialog)
	//{{AFX_MSG_MAP(CDialogDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_STARTSTOP, OnStartStop)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_THREAD, OnThread)
	ON_BN_CLICKED(IDC_TRIGGER, OnTrigger)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDialogDlg message handlers

BOOL CDialogDlg::OnInitDialog()
{
  AGENT(MT_WINDOW, "Before CDialog::OnInitDialog()",0);
	CDialog::OnInitDialog();
  AGENT(MT_WINDOW, "After CDialog::OnInitDialog()",0);

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	CString strAboutMenu;
	strAboutMenu.LoadString(IDS_ABOUTBOX);
	if (!strAboutMenu.IsEmpty())
	{
		pSysMenu->AppendMenu(MF_SEPARATOR);
		pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
	}

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
  TimeoutEd.SetWindowText("0");
  ThreadTmoEd.SetWindowText("0");
  Progress.SetRange(0,100);
  Progress.SetStep(1);
  ThreadActive = FALSE;
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CDialogDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
  AGENT(MT_WINDOW, "OnSysCommand",0);
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDialogDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CDialogDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CDialogDlg::CalcWindowRect(LPRECT lpClientRect, UINT nAdjustType) 
{
	// TODO: Add your specialized code here and/or call the base class
  AGENT(MT_WINDOW, "Before CDialog::CalcWindowRect",0);
	CDialog::CalcWindowRect(lpClientRect, nAdjustType);
  AGENT(MT_WINDOW, "After CDialog::CalcWindowRect",0);
}

BOOL CDialogDlg::Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext) 
{
	// TODO: Add your specialized code here and/or call the base class
  AGENT(MT_WINDOW, "Before CDialog::Create",0);
	BOOL rc = CDialog::Create(IDD, pParentWnd);
  AGENT(MT_WINDOW, "After CDialog::Create",0);
  return rc;
}

BOOL CDialogDlg::DestroyWindow() 
{
	// TODO: Add your specialized code here and/or call the base class
  AGENT(MT_WINDOW, "Before CDialog::DestroyWindow",0);
	BOOL rc = CDialog::DestroyWindow();
  AGENT(MT_WINDOW, "After CDialog::DestroyWindow",0);
  return rc;
}

int CDialogDlg::DoModal() 
{
	// TODO: Add your specialized code here and/or call the base class
  AGENT(MT_WINDOW, "Before CDialog::DoModal",0);
	int rc = CDialog::DoModal();
  AGENT(MT_WINDOW, "After CDialog::DoModal",0);
  return rc;
}

BOOL CDialogDlg::OnChildNotify(UINT message, WPARAM wParam, LPARAM lParam, LRESULT* pLResult) 
{
	// TODO: Add your specialized code here and/or call the base class
  AGENT(MT_WINDOW, "Before CDialog::OnChildNotify",0);
	BOOL rc = CDialog::OnChildNotify(message, wParam, lParam, pLResult);
  AGENT(MT_WINDOW, "After CDialog::OnChildNotify",0);
  return rc;
}

void CDialogDlg::OnSetFont(CFont* pFont) 
{
	// TODO: Add your specialized code here and/or call the base class
  AGENT(MT_WINDOW, "Before CDialog::OnSetFont",0);
	CDialog::OnSetFont(pFont);
  AGENT(MT_WINDOW, "After CDialog::OnSetFont",0);
}

void CDialogDlg::PostNcDestroy() 
{
	// TODO: Add your specialized code here and/or call the base class
  AGENT(MT_WINDOW, "Before CDialog::PostNcDestroy",0);
	CDialog::PostNcDestroy();
  AGENT(MT_WINDOW, "After CDialog::PostNcDestroy",0);
}

BOOL CDialogDlg::PreCreateWindow(CREATESTRUCT& cs) 
{
	// TODO: Add your specialized code here and/or call the base class
  AGENT(MT_WINDOW, "Before CDialog::PreCreateWindow",0);
	BOOL rc = CDialog::PreCreateWindow(cs);
  AGENT(MT_WINDOW, "After CDialog::PreCreateWindow",0);
  return rc;
}

void CDialogDlg::PreSubclassWindow() 
{
	// TODO: Add your specialized code here and/or call the base class
  AGENT(MT_WINDOW, "Before CDialog::PreSubclassWindow",0);
	CDialog::PreSubclassWindow();
  AGENT(MT_WINDOW, "After CDialog::PreSubclassWindow",0);
}

BOOL CDialogDlg::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: Add your specialized code here and/or call the base class
	return CDialog::PreTranslateMessage(pMsg);
}

void CDialogDlg::Serialize(CArchive& ar) 
{
	if (ar.IsStoring())
	{	// storing code
	}
	else
	{	// loading code
	}
}

CScrollBar* CDialogDlg::GetScrollBarCtrl(int nBar) const
{
	// TODO: Add your specialized code here and/or call the base class
  AGENT(MT_WINDOW, "Before CDialog::GetScrollBarCtrl",0);
	CScrollBar *ptr = CDialog::GetScrollBarCtrl(nBar);
  AGENT(MT_WINDOW, "After CDialog::GetScrollBarCtrl",0);
  return ptr;
}

BOOL CDialogDlg::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo) 
{
	// TODO: Add your specialized code here and/or call the base class
  AGENT(MT_WINDOW, "Before CDialog::OnCmdMsg",0);
	BOOL rc = CDialog::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
  AGENT(MT_WINDOW, "After CDialog::OnCmdMsg",0);
  return rc;
}

BOOL CDialogDlg::OnCommand(WPARAM wParam, LPARAM lParam) 
{
	// TODO: Add your specialized code here and/or call the base class
  AGENT(MT_WINDOW, "Before CDialog::OnCommand",0);
	BOOL rc = CDialog::OnCommand(wParam, lParam);
  AGENT(MT_WINDOW, "After CDialog::OnCommand",0);
  return rc;
}

BOOL CDialogDlg::OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult) 
{
	// TODO: Add your specialized code here and/or call the base class
  AGENT(MT_WINDOW, "Before CDialog::OnNotify",0);
	BOOL rc = CDialog::OnNotify(wParam, lParam, pResult);
  AGENT(MT_WINDOW, "After CDialog::OnNotify",0);
  return rc;
}

void CDialogDlg::OnCancel() 
{
  AGENT(MT_WINDOW, "Before CDialog::OnCancel",0);
	CDialog::OnCancel();
  AGENT(MT_WINDOW, "After CDialog::OnCancel",0);
}

void CDialogDlg::OnOK() 
{
  AGENT(MT_WINDOW, "Before CDialog::OnOK",0);
	CDialog::OnOK();
  AGENT(MT_WINDOW, "After CDialog::OnOK",0);
}

void CDialogDlg::OnStartStop() 
{
  if (StartStopCb.GetCheck() == 0) {
    AGENT(MT_TIMER,"User stopped a timer", 0);
    KillTimer(10);
    Progress.ShowWindow(SW_HIDE);
    TimeoutEd.EnableWindow(TRUE);
    StartStopCb.SetWindowText("Start timer");
  } else {
    CString str;
    int timeout;
    TimeoutEd.GetWindowText(str);
    timeout = atoi(str);
    str.Format("%d", timeout);
    TimeoutEd.SetWindowText(str);
    if (timeout == 0) {
      AGENT(MT_TIMER,"Cannot activate a timer with timeout = 0 ms", 0);
      StartStopCb.SetCheck(0);
    } else {
      str.Format("User activated a timer (timeout = %d ms)", timeout);
      AGENT(MT_TIMER,str,0);
      SetTimer(10,timeout,NULL);
      StartStopCb.SetWindowText("Stop timer");
      TimeoutEd.EnableWindow(FALSE);
      Progress.SetPos(0);
      Progress.ShowWindow(SW_SHOW);
    }
  }
}

void CDialogDlg::OnTimer(UINT nIDEvent) 
{
  if (Progress.StepIt() >= 99)
    Progress.SetPos(0);
  AGENT(MT_TIMER,"Timer handler executed", 0);
  DllOnTimer();
	CDialog::OnTimer(nIDEvent);
}

void CDialogDlg::OnThread() 
{
  if (ThreadActive) {
    AGENT(MT_THREAD,"Stopping the thread", 0);
    Thread->Destroy();
    ThreadActive = FALSE;
    ThreadCb.SetWindowText("Start thread");
    ThreadTmoEd.EnableWindow(TRUE);
    AGENT(MT_THREAD,"Thread stopped", 0);
  } else {
    int timeout;
    CString str;
    ThreadTmoEd.GetWindowText(str);
    timeout = atoi(str);
    str.Format("%d", timeout);
    ThreadTmoEd.SetWindowText(str);
    if (timeout == 0) {
      AGENT(MT_THREAD,"No sense in starting a thread with 0 ms sleep time", 0);
      ThreadCb.SetCheck(0);
    } else {
      AGENT(MT_THREAD,"Starting the thread", 0);
      Thread->Create(timeout);
      ThreadActive = TRUE;
      ThreadCb.SetWindowText("Stop thread");
      ThreadTmoEd.EnableWindow(FALSE);
      str.Format("Thread with %d ms sleep time started", timeout);
      AGENT(MT_THREAD,str,0);
    }
  }
}

void CDialogDlg::OnTrigger() 
{
  AGENT(MT_TRIGGER,"Trigger button clicked",0);	
}
