/*#############################################################################
# AGENTLIB.H
#
# RUNTIME MONITORING AGENT
# Version 2.009
#
# SCA Software International S.A.
# Zoran M.Todorovic (codor@eunet.yu) & Miodrag Stojadinovic (micko@eunet.yu)
#
# Do not modify this file !!!
#
# This file contains function prototypes for AGENT LIB which is used for 
# Visual C++ projects.
#############################################################################*/

#ifndef __AGENT_LIB__
#define __AGENT_LIB__

// Automatic linking
#ifdef _DEBUG
# ifdef _DLL
#   pragma comment(lib,"AGDMTDLL.LIB")
# else
#   pragma comment(lib,"AGDMT.LIB")
# endif
#else
# ifdef _DLL
#   pragma comment(lib,"AGMTDLL.LIB")
# else
#   pragma comment(lib,"AGMT.LIB")
# endif
#endif

// Function prototypes
void _stdcall AgentDefineSystem(int systemId, const char *name);
void _stdcall AgentDefineProcess(int systemId, int processId, const char *name);
void _stdcall AgentDefineFiber(int processId, int fiberId, const char *name);
void _stdcall AgentSendText1A(int fiberId, int processId, int systemId, 
                           const char *text);
void _stdcall AgentSendText1B(int fiberId, const char *text);
void _stdcall AgentSendText2A(int fiberId, int processId, int systemId, 
                           const char *filename, int linenum, 
                           const char *text, long errcode);
void _stdcall AgentSendText2B(int fiberId, const char *filename, int linenum, 
                           const char *text, long errcode);
BOOL _stdcall AgentConvertToReadable(char *buffer, int buflen,
                                     int maxlen, int radix);

#endif

/*#############################################################################
# End of file AGENTLIB.H
#############################################################################*/
