/*#############################################################################
# AGENTDLL.H
#
# RUNTIME MONITORING AGENT
# Version 2.009
#
# SCA Software International S.A.
# Zoran M.Todorovic (codor@eunet.yu) & Miodrag Stojadinovic (micko@eunet.yu)
#
# Do not modify this file !!!
#
# This file contains declarations, defines and function prototypes for
# AGENT DLL, AGENT LIB and for using Agent via serial line.
#############################################################################*/

#ifndef __AGENTDLL_H__
#define __AGENTDLL_H__

// Messages

#define MT_TEXT         0x1000
#define MT_EXTTEXT      0x1001
#define MT_SYSTEM       0x2000
#define MT_PROCESS      0x2001
#define MT_FIBER        0x2002

// Limitations

#define MAX_NAME_LENGTH   255
#define MAX_TEXT_LENGTH   500

// Constants

#define AGENT_SIGNATURE       "AGENT"
#define AGENT_SIGNATURE_LEN   5

// Message contains a plain text. Associated with MT_TEXT message type.
typedef struct {
  char Text[MAX_TEXT_LENGTH];
} TMtText;

// Message contains a *text* which is send to the Agent from source code file
// name *Filename*, line number *Linenum*. It may optionally also contain a
// *ErrorCode* which is converted to text representation by the Agent.
// Associated with MT_EXTTEXT message type.
typedef struct {
  char Filename[MAX_NAME_LENGTH];
  long Linenum;
  long ErrorCode;
  char Text[MAX_TEXT_LENGTH];
} TMtExtText;

// Associated with MT_SYSTEM, MT_PROCESS and MT_FIBER message types. This
// structure associates a name with a numeric value of mentioned identifiers.
typedef struct {
  long Identifier;
  char Name[MAX_NAME_LENGTH];
} TMtSystem;
typedef struct {
  long System;
  long Identifier;
  char Name[MAX_NAME_LENGTH];
} TMtProcess;
typedef struct {
  long Process;
  long Identifier;
  char Name[MAX_NAME_LENGTH];
} TMtFiber;

//
// Structures for Serial communication
//

typedef struct {
  unsigned char Signature[5];     // Fixed to "AGENT"
  unsigned short Type;            // One of MT_XXX constants
  unsigned short Length;          // Length for data (and alias)
} TMtRsHeader;

typedef struct {
  long System;
  long Process;
  long Fiber;
} TMtRsAlias;

#define MT_TEXT_LEN(x)        \
            (sizeof(TMtRsAlias)+sizeof(TMtText)-MAX_TEXT_LENGTH+strlen(x)+1)
#define MT_TEXT_MAXLEN(x)     \
            (sizeof(TMtRsHeader)+MT_TEXT_LEN(x))
#define MT_EXTTEXT_LEN(x)     \
            (sizeof(TMtRsAlias)+sizeof(TMtExtText)-MAX_TEXT_LENGTH+strlen(x)+1)
#define MT_EXTTEXT_MAXLEN(x)  \
            (sizeof(TMtRsHeader)+MT_EXTTEXT_LEN(x))
#define MT_SYSTEM_LEN(x)      \
            (sizeof(TMtSystem)-MAX_NAME_LENGTH+strlen(x)+1)
#define MT_SYSTEM_MAXLEN(x)   \
            (sizeof(TMtRsHeader)+MT_SYSTEM_LEN(x))
#define MT_PROCESS_LEN(x)      \
            (sizeof(TMtProcess)-MAX_NAME_LENGTH+strlen(x)+1)
#define MT_PROCESS_MAXLEN(x)   \
            (sizeof(TMtRsHeader)+MT_PROCESS_LEN(x))
#define MT_FIBER_LEN(x)      \
            (sizeof(TMtFiber)-MAX_NAME_LENGTH+strlen(x)+1)
#define MT_FIBER_MAXLEN(x)   \
            (sizeof(TMtRsHeader)+MT_FIBER_LEN(x))

typedef struct {
  TMtRsHeader Header;
  TMtRsAlias Alias;
  TMtText Data;
} TMtRsText;

typedef struct {
  TMtRsHeader Header;
  TMtRsAlias Alias;
  TMtExtText Data;
} TMtRsExtText;

typedef struct {
  TMtRsHeader Header;
  TMtSystem Data;
} TMtRsSystem;
typedef struct {
  TMtRsHeader Header;
  TMtProcess Data;
} TMtRsProcess;
typedef struct {
  TMtRsHeader Header;
  TMtFiber Data;
} TMtRsFiber;

//
// Exported functions
//
#ifdef _WIN32

#define _EXPORT extern "C" __declspec(dllexport)

_EXPORT int _stdcall SendMsg(
            int fiber,
            int process,
            int system,
            int type,
            int len,
            void *data
            );
_EXPORT BOOL _stdcall ConvertToReadable(
            char *buffer,
            int buflen,
            int maxlen,
            int radix
            );

#endif // _WIN32

#endif

/*#############################################################################
# End of file AGENTDLL.H
#############################################################################*/
