#include "stdafx.h"
#include "thread.h"
#include "dialog.h"

extern BOOL __stdcall DllOnThread(void);

///////////////////////////////////////////////////////////////////////////////
// class TTestThread
//

TTestThread::TTestThread()
{
  Thread = NULL;
}

TTestThread::~TTestThread()
{
  DWORD exitCode;
  if (Thread != NULL && 
      ::GetExitCodeThread(Thread->m_hThread, &exitCode) &&
      exitCode == STILL_ACTIVE)
  {
    Destroy();
  }
}

// Thread handler
UINT TTestThread::ThreadFunc(LPVOID arg)
{
  TTestThread *thread = (TTestThread*)arg;
  thread->Execute();    // Virtual so derived function will be called
  return 0;
}

void TTestThread::Create(int timeout)
{
  if (!Thread) {
    Timeout = timeout;
    // Auto reset, initially reset
    EKillThread = ::CreateEvent(NULL,FALSE,FALSE,NULL);
    EThreadIsDead = ::CreateEvent(NULL,FALSE,FALSE,NULL);
    // Create the thread. Set the private flag to indicate success
    Thread = ::AfxBeginThread(ThreadFunc,this,THREAD_PRIORITY_NORMAL);
  }
}

void TTestThread::Destroy(void)
{
  if (Thread) {
    ::SetEvent(EKillThread);
    if (::WaitForSingleObject(EThreadIsDead,INFINITE) == WAIT_TIMEOUT)
      ::TerminateThread(Thread->m_hThread,1);
    ::Sleep(100);
    Thread = NULL;
  }
}

//
// Main Interface thread function.
//
void TTestThread::Execute(void)
{
  DWORD retcode;
  CString str;
  while (TRUE) {
    retcode = ::WaitForSingleObject(EKillThread,Timeout);
    str.Format("TTestThread::WaitForSingleObject(%d)",Timeout);
    AGENT(MT_THREAD,str,retcode);
    if (retcode == WAIT_OBJECT_0)
      break;
    // Do something
    AGENT(MT_THREAD,"TTestThread - Thread executive function",0);
    DllOnThread();
  }
  ::SetEvent(EThreadIsDead);
}

#ifdef _DEBUG
void TTestThread::AssertValid() const
{
	CObject::AssertValid();
}

void TTestThread::Dump(CDumpContext& dc) const
{
	CObject::Dump(dc);
  dc << "TTestThread\n";
}
#endif //_DEBUG

