/*
 * lmPrint.java
 *
 * Copyright (c) 1998, 1999 StarlaSoft. All rights reserved.
 *
 * StarlaSoft makes no representations or warranties about the suitability
 * of the software, either express or implied, including but not limited to
 * the implied warranties of merchantability, fitness for a particular purpose,
 * or non-infringement. StarlaSoft shall not be liable for any damages suffered
 * by licensee as a result of using, modifying or distributing this software or
 * its derivatives.
 */

import com.starla.smb.*;
import java.io.*;

/**
 * lmPrint
 *
 * Send a file to a remote print server.
 */

class lmPrint {

  /**
   * Starts the application.
   *
   * @param args an array of command-line arguments
   */

  public static void main ( String[] args) {

    //  Check if we have enough command line parameters

    if ( args.length < 2) {
      System.out.println ( "Usage: lmPrint \\\\<node>\\<print-share>[<%username>:<password>][\\  <file>");
      return;
    }

    //  Output the local file to the remote printer

    try {

      //  Parse the network path

      PCShare remPath = new PCShare ( args [ 0]);
      String localFile = args [ 1];
		  
      //  Open a session to the remote printer

      SMBPrintSession sess = SMBSessionFactory.OpenPrinter ( remPath);

      //  Open a stream to the remote printer

      SMBOutputStream splStr = sess.OpenSpoolStream( "lmPrint - " + localFile, 0, 0);
      PrintWriter prnStr = new PrintWriter ( splStr);

      //  Open the local file that is to be spooled

      FileReader fileRdr = new FileReader ( localFile);
      BufferedReader bufRdr = new BufferedReader ( fileRdr);

      //  Read records from the local file and output to the remote spool file
			
      String inRec = null;
      int recCnt = 0;
			
      while (( inRec = bufRdr.readLine()) != null) {

        //  Output the current record to the spool file

        prnStr.println ( inRec);

        //  Update the record count

        recCnt++;
      }

      //  Close the input file reader

      bufRdr.close();

      //  Close the spool file, will now be queued or start printing

      prnStr.close();
			
      //  Output the number of records spooled
			
      System.out.println ( "Total of " + recCnt + " records spooled."); 
    }
    catch ( com.starla.smb.InvalidUNCPathException ex) {
      System.out.println ( ex);
    }
    catch ( com.starla.smb.SMBException ex) {
      System.out.println ( ex);
    }
    catch ( java.io.IOException ex) {
      System.out.println ( ex);
    }
    catch ( Exception ex) {
      System.out.println ( ex);
    }
  }
}