/*
 * lmType.java
 *
 * Copyright (c) 1998, 1999 StarlaSoft. All rights reserved.
 *
 * StarlaSoft makes no representations or warranties about the suitability
 * of the software, either express or implied, including but not limited to
 * the implied warranties of merchantability, fitness for a particular purpose,
 * or non-infringement. StarlaSoft shall not be liable for any damages suffered
 * by licensee as a result of using, modifying or distributing this software or
 * its derivatives.
 */

//	Imports

import com.starla.lite.*;
import java.io.*;

/**
 * lmType
 *
 * Output the specified remote file to the console.
 */

class lmType {

 /**
  * Main
  *
  * @param args   Command line arguments array
  */

  public static void main ( String [] args) {

    //  Check if we have enough command line parameters

    if ( args.length == 0) {
      System.out.println ( "Usage: lmType \\\\<node>\\<share>[<%username>:<password>][\\<path>]\\<file>");
      return;
    }

    //  Output the remote file to the console

    try {

      //  Parse the network path

      PCShare remPath = new PCShare ( args [ 0]);

      //  Open a session to the remote disk share

      SMBDiskSession sess = SMBSessionFactory.OpenDisk ( remPath);

      //  Open the remote file as an input stream

      SMBInputStream inStr = sess.OpenInputStream ( remPath.getRelativePath (), SMBAccessMode.ReadOnly);

      //  Create a line number reader to read from the remote file

      InputStreamReader strReader = new InputStreamReader ( inStr);
      LineNumberReader lnReader = new LineNumberReader ( strReader);

      String inRec = null;

      while (( inRec = lnReader.readLine ()) != null) {

        //  Output the current record number and record

        System.out.println ( lnReader.getLineNumber () + ": " + inRec);
      }

      //  Close the input stream

      inStr.close ();
    }
    catch ( com.starla.lite.InvalidUNCPathException ex) {
      System.out.println ( ex);
    }
    catch ( com.starla.lite.SMBException ex) {
      System.out.println ( ex);
    }
    catch ( java.io.IOException ex) {
      System.out.println ( ex);
    }
  }    
}