/*
 * lmDir.java
 *
 * Copyright (c) 1998, 1999 StarlaSoft. All rights reserved.
 *
 * StarlaSoft makes no representations or warranties about the suitability
 * of the software, either express or implied, including but not limited to
 * the implied warranties of merchantability, fitness for a particular purpose,
 * or non-infringement. StarlaSoft shall not be liable for any damages suffered
 * by licensee as a result of using, modifying or distributing this software or
 * its derivatives.
 */

//	Imports

import com.starla.lite.*;
import java.io.*;

/**
 * lmDir
 *
 * Output a directory listing of the remote directory.
 */

class lmDir {

 /**
  * Main
  *
  * @param args   Command line arguments array
  */

  public static void main ( String [] args) {

    //  Check if we have enough command line parameters

    if ( args.length == 0) {
      System.out.println ( "Usage: lmDir \\\\<node>\\<share>[<%username>:<password>][\\<path>]\\<file>");
      return;
    }

    //  Output the remote file to the console

    try {

      //  Parse the network path

      PCShare remPath = new PCShare ( args [ 0]);

      //  Check if a file mask has been specified

      if ( remPath.getFileName () == null || remPath.getFileName ().length() == 0)
	remPath.setFileName ( "*.*");

      //  Open a session to the remote file server

      SMBDiskSession sess = SMBSessionFactory.OpenDisk ( remPath);

      //  Start a search of the remote directory

      SMBSearchContext srch = sess.StartSearch ( remPath.getRelativePath (), SMBFileAttribute.Directory);

      //  Get a file from the search

      SMBFileInfo finfo = srch.nextFileInfo ();

      while ( finfo != null) {

        //  Output the current file information

        System.out.println ( finfo);

        //  Get the next file from the list

        finfo = srch.nextFileInfo ();
      }

      //  Close the session to the server

      sess.CloseSession ();
    }
    catch ( com.starla.lite.InvalidUNCPathException ex) {
      System.out.println ( ex);
    }
    catch ( com.starla.lite.SMBException ex) {
      System.out.println ( ex);
    }
    catch ( java.io.IOException ex) {
      System.out.println ( ex);
    }
  }    
}