/*
 * Decompiled with CFR 0.152.
 */
package com.starla.smb;

import com.starla.smb.NetBIOSSession;
import com.starla.smb.SMBErrorText;
import com.starla.smb.SMBSession;
import com.starla.util.DataPacker;
import com.starla.util.HexDump;
import java.io.IOException;

class SMBPacket {
    public static final int SIGNATURE = 4;
    public static final int COMMAND = 8;
    public static final int ERRORCODE = 9;
    public static final int ERRORCLASS = 9;
    public static final int ERROR = 11;
    public static final int FLAGS = 13;
    public static final int FLAGS2 = 14;
    public static final int PIDHIGH = 16;
    public static final int SID = 22;
    public static final int SEQNO = 24;
    public static final int TID = 28;
    public static final int PID = 30;
    public static final int UID = 32;
    public static final int MID = 34;
    public static final int WORDCNT = 36;
    public static final int ANDXCOMMAND = 37;
    public static final int ANDXRESERVED = 38;
    public static final int PARAMWORDS = 37;
    public static final int TRANS_HEADERLEN = 70;
    public static final int MIN_RXLEN = 32;
    public static final int DEFAULT_BUFSIZE = 4096;
    public static final int FLG_SUBDIALECT = 1;
    public static final int FLG_CASELESS = 8;
    public static final int FLG_CANONICAL = 16;
    public static final int FLG_OPLOCK = 32;
    public static final int FLG_NOTIFY = 64;
    public static final int FLG_RESPONSE = 128;
    public static final int FLG2_LONGFILENAMES = 1;
    public static final int FLG2_EXTENDEDATTRIB = 2;
    public static final int FLG2_READIFEXE = 8192;
    public static final int FLG2_LONGERRORCODE = 16384;
    public static final int FLG2_UNICODE = 32768;
    public static final int SEC_USER = 1;
    public static final int SEC_ENCRYPT = 2;
    public static final int RAW_READ = 1;
    public static final int RAW_WRITE = 2;
    private byte[] _$19277;
    private int _$19283;

    public SMBPacket() {
        this._$19277 = new byte[4096];
        this._$19292();
    }

    public SMBPacket(byte[] byArray) {
        this._$19277 = byArray;
    }

    public SMBPacket(int n) {
        this._$19277 = new byte[n];
        this._$19292();
    }

    public final void clearBytes() {
        int n = this.getByteOffset() - 2;
        DataPacker.putIntelShort((short)0, this._$19277, n);
    }

    public final void DumpPacket() {
        SMBSession.print("** SMB Packet Type: ");
        switch (this.getCommand()) {
            case 114: {
                SMBSession.print("NEGOTIATE");
                break;
            }
            case 115: {
                SMBSession.print("SESSION_SETUP");
                break;
            }
            case 112: {
                SMBSession.print("TREE_CONNECT");
                break;
            }
            case 117: {
                SMBSession.print("TREE_CONNECT_ANDX");
                break;
            }
            case 113: {
                SMBSession.print("TREE_DISCONNECT");
                break;
            }
            case 129: {
                SMBSession.print("SEARCH");
                break;
            }
            case 2: {
                SMBSession.print("OPEN_FILE");
                break;
            }
            case 45: {
                SMBSession.print("OPEN_ANDX");
                break;
            }
            case 10: {
                SMBSession.print("READ_FILE");
                break;
            }
            case 11: {
                SMBSession.print("WRITE_FILE");
                break;
            }
            case 4: {
                SMBSession.print("CLOSE_FILE");
                break;
            }
            case 3: {
                SMBSession.print("CREATE_FILE");
                break;
            }
            case 8: {
                SMBSession.print("GET_FILE_INFO");
                break;
            }
            case 128: {
                SMBSession.print("GET_DISK_INFO");
                break;
            }
            case 16: {
                SMBSession.print("CHECK_DIRECTORY");
                break;
            }
            case 7: {
                SMBSession.print("RENAME_FILE");
                break;
            }
            case 1: {
                SMBSession.print("DELETE_DIRECTORY");
                break;
            }
            case 195: {
                SMBSession.print("GET_PRINT_QUEUE");
                break;
            }
            case 50: {
                SMBSession.print("TRANSACTION2");
                break;
            }
            case 37: {
                SMBSession.print("TRANSACTION");
                break;
            }
            case 51: {
                SMBSession.print("TRANSACTION2_SECONDARY");
                break;
            }
            case 38: {
                SMBSession.print("TRANSACTION_SECONDARY");
                break;
            }
            case 43: {
                SMBSession.print("ECHO");
                break;
            }
            default: {
                SMBSession.print(String.valueOf("0x").concat(String.valueOf(Integer.toHexString(this.getCommand()))));
            }
        }
        if (this.isResponse()) {
            SMBSession.println(" [Response]");
        } else {
            SMBSession.println();
        }
        if (SMBSession.hasDebugOption(2)) {
            SMBSession.println("** SMB Packet Dump");
            SMBSession.println(String.valueOf("Packet Length : ").concat(String.valueOf(this.getLength())));
            SMBSession.println(String.valueOf(String.valueOf(String.valueOf("Byte Offset: ").concat(String.valueOf(this.getByteOffset()))).concat(String.valueOf(", Byte Count: "))).concat(String.valueOf(this.getByteCount())));
            SMBSession.println(String.valueOf("Flags: ").concat(String.valueOf(Integer.toBinaryString(this.getFlags()))));
            SMBSession.println(String.valueOf("Flags2: ").concat(String.valueOf(Integer.toBinaryString(this.getFlags2()))));
            SMBSession.println(String.valueOf("TID: ").concat(String.valueOf(this.getTreeId())));
            SMBSession.println(String.valueOf("PID: ").concat(String.valueOf(this.getProcessId())));
            SMBSession.println(String.valueOf("UID: ").concat(String.valueOf(this.getUserId())));
            SMBSession.println(String.valueOf("MID: ").concat(String.valueOf(this.getMultiplexId())));
            int n = this.getParameterCount();
            SMBSession.println(String.valueOf("Parameter Words: ").concat(String.valueOf(n)));
            for (int i = 0; i < n; ++i) {
                SMBSession.println(String.valueOf(String.valueOf(String.valueOf(" P").concat(String.valueOf(i + 1))).concat(String.valueOf(" = "))).concat(String.valueOf(this.getParameter(i))));
            }
            if (this.isResponse()) {
                SMBSession.println(String.valueOf("Error: 0x").concat(String.valueOf(Integer.toHexString(this.getErrorCode()))));
                SMBSession.print("Error Class: ");
                switch (this.getErrorClass()) {
                    case 0: {
                        SMBSession.println("SUCCESS");
                        break;
                    }
                    case 1: {
                        SMBSession.println("ERRDOS");
                        break;
                    }
                    case 2: {
                        SMBSession.println("ERRSRV");
                        break;
                    }
                    case 3: {
                        SMBSession.println("ERRHRD");
                        break;
                    }
                    case 255: {
                        SMBSession.println("ERRCMD");
                        break;
                    }
                    default: {
                        SMBSession.println(String.valueOf("0x").concat(String.valueOf(Integer.toHexString(this.getErrorClass()))));
                    }
                }
                SMBSession.print("Error Text: ");
                SMBSession.println(SMBErrorText.ErrorString(this.getErrorClass(), this.getErrorCode()));
            }
        }
        if (SMBSession.hasDebugOption(4)) {
            System.out.println("********** Raw SMB Data Dump **********");
            HexDump.Dump(this._$19277, this.getLength(), 4);
        }
    }

    public final synchronized void ExchangeSMB(NetBIOSSession netBIOSSession, SMBPacket sMBPacket, boolean bl) throws IOException {
        if (SMBSession.isDebug()) {
            this.DumpPacket();
        }
        netBIOSSession.Send(this._$19277, this.getLength());
        if (netBIOSSession.Receive(sMBPacket.getBuffer()) >= 32) {
            if (SMBSession.isDebug()) {
                sMBPacket.DumpPacket();
            }
            if (bl && !sMBPacket.isValidResponse()) {
                throw new IOException(SMBErrorText.ErrorString(sMBPacket.getErrorClass(), sMBPacket.getErrorCode()));
            }
            return;
        }
        throw new IOException("Invalid SMB Receive Packet");
    }

    public final synchronized void ExchangeSMB(SMBSession sMBSession, SMBPacket sMBPacket) throws IOException {
        this.ExchangeSMB(sMBSession, sMBPacket, false);
    }

    public final synchronized void ExchangeSMB(SMBSession sMBSession, SMBPacket sMBPacket, boolean bl) throws IOException {
        if (!sMBSession.isActive()) {
            throw new IOException("Session is closed");
        }
        if (SMBSession.isDebug()) {
            this.DumpPacket();
        }
        sMBSession.getSession().Send(this._$19277, this.getLength());
        if (sMBSession.getSession().Receive(sMBPacket.getBuffer()) >= 32) {
            if (SMBSession.isDebug()) {
                sMBPacket.DumpPacket();
            }
            if (bl && !sMBPacket.isValidResponse()) {
                throw new IOException(SMBErrorText.ErrorString(sMBPacket.getErrorClass(), sMBPacket.getErrorCode()));
            }
            return;
        }
        throw new IOException("Invalid SMB Receive Packet");
    }

    public final int getAndXCommand() {
        return this._$19277[37] & 0xFF;
    }

    public final byte[] getBuffer() {
        return this._$19277;
    }

    public final int getBufferLength() {
        return this._$19277.length - 4;
    }

    public final int getByteCount() {
        int n = 37 + 2 * this.getParameterCount();
        return DataPacker.getIntelShort(this._$19277, n);
    }

    public final int getByteOffset() {
        int n = this.getParameterCount();
        int n2 = 36 + 2 * n + 3;
        return n2;
    }

    public final int getCommand() {
        return this._$19277[8] & 0xFF;
    }

    public final int getErrorClass() {
        return this._$19277[9] & 0xFF;
    }

    public final int getErrorCode() {
        return this._$19277[11] & 0xFF;
    }

    public final int getFlags() {
        return this._$19277[13] & 0xFF;
    }

    public final int getFlags2() {
        return DataPacker.getIntelShort(this._$19277, 14);
    }

    public final int getLength() {
        return this.getByteOffset() + this.getByteCount() - 4;
    }

    public final int getLongErrorCode() {
        return DataPacker.getIntelInt(this._$19277, 9);
    }

    public final short getMultiplexId() {
        return DataPacker.getIntelShort(this._$19277, 34);
    }

    public final int getParameter(int n) throws IndexOutOfBoundsException {
        if (n > this.getParameterCount()) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = 36 + 2 * n + 1;
        return DataPacker.getIntelShort(this._$19277, n2) & 0xFFFF;
    }

    public final int getParameterCount() {
        return this._$19277[36];
    }

    public final short getProcessId() {
        return DataPacker.getIntelShort(this._$19277, 30);
    }

    public final short getTreeId() {
        return DataPacker.getIntelShort(this._$19277, 28);
    }

    public final short getUserId() {
        return DataPacker.getIntelShort(this._$19277, 32);
    }

    private final void _$19292() {
        this._$19277[4] = -1;
        this._$19277[5] = 83;
        this._$19277[6] = 77;
        this._$19277[7] = 66;
    }

    public final boolean isResponse() {
        int n = this.getFlags();
        return (n & 0x80) != 0;
    }

    public final boolean isValidResponse() {
        return this.isResponse() && this.getCommand() == this._$19283 && this.getErrorClass() == 0;
    }

    private final void _$7826(NetBIOSSession netBIOSSession) throws IOException {
        if (netBIOSSession.Receive(this._$19277) >= 32) {
            return;
        }
        throw new IOException("Short NetBIOS receive");
    }

    protected final void ReceiveSMB(SMBSession sMBSession) throws IOException {
        if (sMBSession.getSession().Receive(this._$19277) >= 32) {
            if (SMBSession.isDebug()) {
                this.DumpPacket();
            }
            return;
        }
        throw new IOException("Short NetBIOS receive");
    }

    private final void _$7836(NetBIOSSession netBIOSSession) throws IOException {
        netBIOSSession.Send(this._$19277, this.getLength());
    }

    protected final void SendSMB(SMBSession sMBSession) throws IOException {
        if (SMBSession.isDebug()) {
            this.DumpPacket();
        }
        sMBSession.getSession().Send(this._$19277, this.getLength());
    }

    public final void setAndXCommand(int n) {
        this._$19277[37] = (byte)n;
        this._$19277[38] = 0;
    }

    public final void setByteCount(int n) {
        int n2 = this.getByteOffset() - 2;
        DataPacker.putIntelShort((short)n, this._$19277, n2);
    }

    public final void setBytes(byte[] byArray) {
        int n = this.getByteOffset() - 2;
        DataPacker.putIntelShort((short)byArray.length, this._$19277, n);
        n += 2;
        int n2 = 0;
        while (n2 < byArray.length) {
            this._$19277[n + n2] = byArray[n2++];
        }
    }

    public final void setCommand(int n) {
        this._$19283 = n;
        this._$19277[8] = (byte)n;
    }

    public final void setErrorClass(int n) {
        this._$19277[9] = (byte)(n & 0xFF);
    }

    public final void setErrorCode(int n) {
        this._$19277[11] = (byte)(n & 0xFF);
    }

    public final void setFlags(int n) {
        this._$19277[13] = (byte)n;
    }

    public final void setFlags2(int n) {
        DataPacker.putIntelShort((short)n, this._$19277, 14);
    }

    public final void setMultiplexId(int n) {
        DataPacker.putIntelShort((short)n, this._$19277, 34);
    }

    public final void setParameter(int n, int n2) {
        int n3 = 36 + 2 * n + 1;
        DataPacker.putIntelShort((short)n2, this._$19277, n3);
    }

    public final void setParameterCount(int n) {
        this._$19277[36] = (byte)n;
    }

    public final void setProcessId(int n) {
        DataPacker.putIntelShort((short)n, this._$19277, 30);
    }

    public final void setSeqNo(int n) {
        DataPacker.putIntelShort((short)n, this._$19277, 24);
    }

    public final void setSID(int n) {
        DataPacker.putIntelShort((short)n, this._$19277, 22);
    }

    public final void setTreeId(int n) {
        DataPacker.putIntelShort((short)n, this._$19277, 28);
    }

    public final void setUserId(int n) {
        DataPacker.putIntelShort((short)n, this._$19277, 32);
    }
}

