/*
 * Decompiled with CFR 0.152.
 */
package com.starla.smb;

import com.starla.smb.SMBFile;
import com.starla.smb.SMBFileInfo;
import com.starla.smb.SMBPacket;
import com.starla.smb.SMBSession;
import com.starla.util.DataPacker;
import java.io.IOException;

public class SMBCoreFile
extends SMBFile {
    private static final int _$15229 = 4000;
    private static final int _$15237 = 4064;

    protected SMBCoreFile(SMBSession sMBSession, SMBFileInfo sMBFileInfo, int n) {
        super(sMBSession, sMBFileInfo, n);
    }

    public void Close() throws IOException {
        if (this.m_txlen > 0) {
            this.Flush();
        }
        SMBPacket sMBPacket = new SMBPacket();
        sMBPacket.setUserId(this.m_sess.getUserId());
        sMBPacket.setTreeId(this.m_sess.getTreeId());
        sMBPacket.setCommand(4);
        sMBPacket.setParameterCount(3);
        sMBPacket.setParameter(0, this.m_FID);
        sMBPacket.setParameter(1, 0);
        sMBPacket.setParameter(2, 0);
        this.setStateFlag(2, true);
        try {
            sMBPacket.ExchangeSMB(this.m_sess, sMBPacket);
        }
        catch (IOException iOException) {
            return;
        }
        this.m_rxpkt = null;
        this.m_txpkt = null;
    }

    public void Flush() throws IOException {
        if (this.m_txlen > 0) {
            this._$15284();
        }
    }

    public int Read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        if (this.isClosed()) {
            return 0;
        }
        int n5 = n2;
        for (n3 = 0; n3 < n && !this.atEndOfFile(); n3 += n4) {
            if (this.m_rxlen == 0 && !this._$15305()) {
                return -1;
            }
            n4 = n;
            if (n4 > this.m_rxlen) {
                n4 = this.m_rxlen;
            }
            byte[] byArray2 = this.m_rxpkt.getBuffer();
            for (int i = 0; i < n4; ++i) {
                byArray[n5 + i] = byArray2[this.m_rxoffset + i];
            }
            this.m_rxlen -= n4;
            this.m_rxoffset += n4;
            n5 += n4;
        }
        return n3;
    }

    private final boolean _$15305() {
        if (this.m_rxpkt == null) {
            this.m_rxpkt = new SMBPacket();
            this.m_rxpkt.setUserId(this.m_sess.getUserId());
            this.m_rxpkt.setTreeId(this.m_sess.getTreeId());
        }
        this.m_rxpkt.setCommand(10);
        this.m_rxpkt.setParameterCount(5);
        this.m_rxpkt.setParameter(0, this.m_FID);
        if (this.m_rxpos + 4000 > this.getFileSize()) {
            this.m_rxpkt.setParameter(1, this.getFileSize() - this.m_rxpos);
        } else {
            this.m_rxpkt.setParameter(1, 4000);
        }
        this.m_rxpkt.setParameter(2, this.m_rxpos & 0xFFFF);
        this.m_rxpkt.setParameter(3, (this.m_rxpos & 0xFFFF0000) >> 16);
        this.m_rxpkt.setParameter(4, 4000);
        try {
            this.m_rxpkt.ExchangeSMB(this.m_sess, this.m_rxpkt);
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        if (this.m_rxpkt.isValidResponse()) {
            int n = this.m_rxpkt.getParameter(0);
            this.m_rxoffset = this.m_rxpkt.getByteOffset();
            byte[] byArray = this.m_rxpkt.getBuffer();
            if (byArray[this.m_rxoffset++] != 1) {
                return false;
            }
            this.m_rxlen = DataPacker.getIntelShort(byArray, this.m_rxoffset);
            this.m_rxoffset += 2;
            this.m_rxpos += this.m_rxlen;
            if (this.m_rxlen == 0) {
                this.setStateFlag(1, true);
            }
            return true;
        }
        return false;
    }

    public int Write(byte[] byArray, int n, int n2) throws IOException {
        if (this.isClosed()) {
            return 0;
        }
        if (this.m_txpkt == null) {
            this.m_txpkt = new SMBPacket();
            this.m_txpkt.setUserId(this.m_sess.getUserId());
            this.m_txpkt.setTreeId(this.m_sess.getTreeId());
            this.m_txpkt.setParameterCount(5);
            this.m_txlen = 0;
            this.m_txoffset = this.m_txpkt.getByteOffset() + 3;
        }
        int n3 = 0;
        while (n3 < n) {
            byte[] byArray2 = this.m_txpkt.getBuffer();
            int n4 = byArray2.length - this.m_txoffset;
            if (n4 > n) {
                n4 = n;
            }
            for (int i = 0; i < n4; ++i) {
                byArray2[this.m_txoffset++] = byArray[n2++];
            }
            n3 += n4;
            this.m_txlen += n4;
            if (this.m_txoffset < byArray2.length) continue;
            this._$15284();
        }
        return n3;
    }

    private final boolean _$15284() {
        this.m_txpkt.setCommand(11);
        this.m_txpkt.setParameterCount(5);
        this.m_txpkt.setParameter(0, this.m_FID);
        this.m_txpkt.setParameter(1, this.m_txlen);
        this.m_txpkt.setParameter(2, this.m_txpos & 0xFFFF);
        this.m_txpkt.setParameter(3, (this.m_txpos & 0xFFFF0000) >> 16);
        this.m_txpkt.setParameter(4, this.m_txlen);
        this.m_txpkt.setByteCount(this.m_txlen + 3);
        byte[] byArray = this.m_txpkt.getBuffer();
        int n = this.m_txpkt.getByteOffset();
        byArray[n++] = 1;
        DataPacker.putIntelShort((short)this.m_txlen, byArray, n);
        try {
            this.m_txpkt.ExchangeSMB(this.m_sess, this.m_txpkt);
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        if (this.m_txpkt.isValidResponse()) {
            int n2 = this.m_txpkt.getParameter(0);
            this.m_txpos += n2;
            this.m_txlen = 0;
            this.m_txoffset = this.m_txpkt.getByteOffset() + 3;
            return true;
        }
        return false;
    }
}

