/*
 * Decompiled with CFR 0.152.
 */
package com.starla.smb;

import com.starla.smb.PCShare;
import com.starla.smb.SMBAccessMode;
import com.starla.smb.SMBCoreFile;
import com.starla.smb.SMBCoreSearchContext;
import com.starla.smb.SMBDiskInfo;
import com.starla.smb.SMBDiskSession;
import com.starla.smb.SMBFile;
import com.starla.smb.SMBFileInfo;
import com.starla.smb.SMBPacket;
import com.starla.smb.SMBSearchContext;
import java.io.IOException;

public class SMBCoreDiskSession
extends SMBDiskSession {
    private static final int _$16187 = 256;

    protected SMBCoreDiskSession(PCShare pCShare, int n) {
        super(pCShare, n);
    }

    public void CloseSession() throws IOException {
        SMBPacket sMBPacket = new SMBPacket();
        sMBPacket.setCommand(113);
        sMBPacket.setUserId(this.getUserId());
        sMBPacket.setTreeId(this.m_treeid);
        sMBPacket.ExchangeSMB(this, sMBPacket);
        this.m_treeid = -1;
    }

    public final boolean CreateDirectory(String string) throws IOException {
        this.m_pkt.setCommand(0);
        this.m_pkt.setUserId(this.getUserId());
        this.m_pkt.setTreeId(this.getTreeId());
        this.m_pkt.setParameterCount(0);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\u0004');
        if (string.startsWith("\\")) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append(PCShare.makePath(this.getWorkingDirectory(), string));
        }
        stringBuffer.append('\u0000');
        this.m_pkt.setBytes(stringBuffer.toString().getBytes());
        this.m_pkt.ExchangeSMB(this, this.m_pkt, true);
        return this.m_pkt.isValidResponse();
    }

    public final boolean DeleteDirectory(String string) throws IOException {
        this.m_pkt.setCommand(1);
        this.m_pkt.setUserId(this.getUserId());
        this.m_pkt.setTreeId(this.getTreeId());
        this.m_pkt.setParameterCount(0);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\u0004');
        if (string.startsWith("\\")) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append(PCShare.makePath(this.getWorkingDirectory(), string));
        }
        stringBuffer.append('\u0000');
        this.m_pkt.setBytes(stringBuffer.toString().getBytes());
        this.m_pkt.ExchangeSMB(this, this.m_pkt, true);
        return this.m_pkt.isValidResponse();
    }

    public final void DeleteFile(String string, int n) throws IOException {
    }

    public final SMBDiskInfo getDiskInformation() throws IOException {
        this.m_pkt.setCommand(128);
        this.m_pkt.setUserId(this.getUserId());
        this.m_pkt.setTreeId(this.getTreeId());
        this.m_pkt.setParameterCount(0);
        this.m_pkt.setByteCount(0);
        this.m_pkt.ExchangeSMB(this, this.m_pkt);
        if (this.m_pkt.isValidResponse()) {
            int n = this.m_pkt.getParameter(0);
            int n2 = this.m_pkt.getParameter(1);
            int n3 = this.m_pkt.getParameter(2);
            int n4 = this.m_pkt.getParameter(3);
            return new SMBDiskInfo(this.getPCShare(), n, n2, n3, n4);
        }
        return null;
    }

    public final SMBFileInfo getFileInformation(String string) throws IOException {
        this.m_pkt.setCommand(8);
        this.m_pkt.setUserId(this.getUserId());
        this.m_pkt.setTreeId(this.getTreeId());
        this.m_pkt.setParameterCount(0);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\u0004');
        if (string.startsWith("\\")) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append(PCShare.makePath(this.getWorkingDirectory(), string));
        }
        stringBuffer.append('\u0000');
        this.m_pkt.setBytes(stringBuffer.toString().getBytes());
        this.m_pkt.ExchangeSMB(this, this.m_pkt);
        if (this.m_pkt.isValidResponse()) {
            int n = this.m_pkt.getParameter(0);
            int n2 = (this.m_pkt.getParameter(2) << 16) + this.m_pkt.getParameter(1);
            int n3 = (this.m_pkt.getParameter(4) << 16) + this.m_pkt.getParameter(3);
            return new SMBFileInfo(string, n3, n, n2);
        }
        return null;
    }

    public final boolean isDirectory(String string) throws IOException {
        SMBPacket sMBPacket = new SMBPacket();
        sMBPacket.setCommand(16);
        sMBPacket.setUserId(this.getUserId());
        sMBPacket.setTreeId(this.getTreeId());
        sMBPacket.setParameterCount(0);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\u0004');
        if (string.startsWith("\\")) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append(PCShare.makePath(this.getWorkingDirectory(), string));
        }
        if (stringBuffer.charAt(stringBuffer.length() - 1) != '\\') {
            stringBuffer.append("\\");
        }
        stringBuffer.append('\u0000');
        sMBPacket.setBytes(stringBuffer.toString().getBytes());
        sMBPacket.ExchangeSMB(this, sMBPacket);
        return sMBPacket.isValidResponse();
    }

    public final SMBFile OpenFile(String string, int n) throws IOException {
        this.m_pkt.setCommand(2);
        this.m_pkt.setFlags(0);
        this.m_pkt.setParameterCount(2);
        this.m_pkt.setParameter(0, n);
        this.m_pkt.setParameter(1, 0);
        this.m_pkt.setUserId(this.getUserId());
        this.m_pkt.setTreeId(this.getTreeId());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\u0004');
        if (string.startsWith("\\")) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append(PCShare.makePath(this.getWorkingDirectory(), string));
        }
        stringBuffer.append('\u0000');
        this.m_pkt.setBytes(stringBuffer.toString().getBytes());
        this.m_pkt.ExchangeSMB(this, this.m_pkt);
        if (this.m_pkt.isValidResponse()) {
            int n2 = this.m_pkt.getParameter(0);
            int n3 = this.m_pkt.getParameter(1);
            int n4 = (this.m_pkt.getParameter(5) << 16) + this.m_pkt.getParameter(4);
            SMBFileInfo sMBFileInfo = new SMBFileInfo(string, n4, n3);
            return new SMBCoreFile(this, sMBFileInfo, n2);
        }
        if (SMBAccessMode.AccessMode(n) == 1) {
            this.m_pkt.setCommand(15);
            this.m_pkt.setFlags(0);
            this.m_pkt.setParameterCount(3);
            this.m_pkt.setParameter(0, n);
            this.m_pkt.setParameter(1, 0);
            this.m_pkt.setParameter(2, 0);
            this.m_pkt.setUserId(this.getUserId());
            this.m_pkt.setTreeId(this.getTreeId());
            this.m_pkt.setErrorClass(0);
            this.m_pkt.setErrorCode(0);
            this.m_pkt.setBytes(stringBuffer.toString().getBytes());
            this.m_pkt.ExchangeSMB(this, this.m_pkt);
            if (this.m_pkt.isValidResponse()) {
                int n5 = this.m_pkt.getParameter(0);
                SMBFileInfo sMBFileInfo = new SMBFileInfo(string, 0, 0);
                return new SMBCoreFile(this, sMBFileInfo, n5);
            }
        }
        return null;
    }

    public final boolean RenameFile(String string, String string2, int n) throws IOException {
        this.m_pkt.setCommand(7);
        this.m_pkt.setUserId(this.getUserId());
        this.m_pkt.setTreeId(this.getTreeId());
        this.m_pkt.setParameterCount(1);
        this.m_pkt.setParameter(0, n);
        StringBuffer stringBuffer = new StringBuffer();
        if (string.startsWith("\\")) {
            stringBuffer.append('\u0004');
            stringBuffer.append(string);
            stringBuffer.append('\u0000');
            stringBuffer.append('\u0004');
            stringBuffer.append(string2);
            stringBuffer.append('\u0000');
        } else {
            stringBuffer.append(PCShare.makePath(this.getWorkingDirectory(), string));
            stringBuffer.append('\u0000');
            stringBuffer.append('\u0004');
            if (string2.startsWith("\\")) {
                stringBuffer.append(string2);
            } else {
                stringBuffer.append(PCShare.makePath(this.getWorkingDirectory(), string2));
            }
            stringBuffer.append('\u0000');
        }
        this.m_pkt.setBytes(stringBuffer.toString().getBytes());
        this.m_pkt.ExchangeSMB(this, this.m_pkt, true);
        return this.m_pkt.isValidResponse();
    }

    public final void setFileInformation(String string, SMBFileInfo sMBFileInfo, int n) throws IOException {
    }

    public final SMBSearchContext StartSearch(String string, int n) throws IOException {
        SMBCoreSearchContext sMBCoreSearchContext = new SMBCoreSearchContext(this, string, n);
        if (sMBCoreSearchContext == null) {
            return null;
        }
        sMBCoreSearchContext.StartSearch();
        return sMBCoreSearchContext;
    }
}

