/*
 * Decompiled with CFR 0.152.
 */
package com.starla.smb;

import com.starla.smb.PCShare;
import com.starla.smb.SMBAccessMode;
import com.starla.smb.SMBCIFSFile;
import com.starla.smb.SMBDiskInfo;
import com.starla.smb.SMBDiskSession;
import com.starla.smb.SMBFile;
import com.starla.smb.SMBFileInfo;
import com.starla.smb.SMBPacket;
import com.starla.smb.SMBSearchContext;
import com.starla.smb.SMBTransSearchContext;
import java.io.FileNotFoundException;
import java.io.IOException;

public final class SMBCIFSDiskSession
extends SMBDiskSession {
    private static final int _$14917 = 256;

    protected SMBCIFSDiskSession(PCShare pCShare, int n) {
        super(pCShare, n);
    }

    public void CloseSession() throws IOException {
        SMBPacket sMBPacket = new SMBPacket();
        sMBPacket.setCommand(113);
        sMBPacket.setUserId(this.getUserId());
        sMBPacket.setTreeId(this.m_treeid);
        sMBPacket.ExchangeSMB(this, sMBPacket);
        this.m_treeid = -1;
    }

    public final boolean CreateDirectory(String string) throws IOException {
        this.m_pkt.setCommand(0);
        this.m_pkt.setUserId(this.getUserId());
        this.m_pkt.setTreeId(this.getTreeId());
        this.m_pkt.setFlags(0);
        this.m_pkt.setFlags2(0);
        this.m_pkt.setParameterCount(0);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\u0004');
        if (string.startsWith("\\")) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append(PCShare.makePath(this.getWorkingDirectory(), string));
        }
        stringBuffer.append('\u0000');
        this.m_pkt.setBytes(stringBuffer.toString().getBytes());
        this.m_pkt.ExchangeSMB(this, this.m_pkt, true);
        return this.m_pkt.isValidResponse();
    }

    public final boolean DeleteDirectory(String string) throws IOException {
        this.m_pkt.setCommand(1);
        this.m_pkt.setUserId(this.getUserId());
        this.m_pkt.setTreeId(this.getTreeId());
        this.m_pkt.setFlags(0);
        this.m_pkt.setFlags2(0);
        this.m_pkt.setParameterCount(0);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\u0004');
        if (string.startsWith("\\")) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append(PCShare.makePath(this.getWorkingDirectory(), string));
        }
        stringBuffer.append('\u0000');
        this.m_pkt.setBytes(stringBuffer.toString().getBytes());
        this.m_pkt.ExchangeSMB(this, this.m_pkt, true);
        return this.m_pkt.isValidResponse();
    }

    public final void DeleteFile(String string, int n) throws IOException {
        this.m_pkt.setCommand(6);
        this.m_pkt.setUserId(this.getUserId());
        this.m_pkt.setTreeId(this.getTreeId());
        this.m_pkt.setParameterCount(1);
        this.m_pkt.setParameter(0, n);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\u0004');
        if (string.startsWith("\\")) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append(PCShare.makePath(this.getWorkingDirectory(), string));
        }
        stringBuffer.append('\u0000');
        this.m_pkt.setBytes(stringBuffer.toString().getBytes());
        this.m_pkt.ExchangeSMB(this, this.m_pkt, true);
    }

    public final SMBDiskInfo getDiskInformation() throws IOException {
        this.m_pkt.setCommand(128);
        this.m_pkt.setUserId(this.getUserId());
        this.m_pkt.setTreeId(this.getTreeId());
        this.m_pkt.setParameterCount(0);
        this.m_pkt.setByteCount(0);
        this.m_pkt.ExchangeSMB(this, this.m_pkt);
        if (this.m_pkt.isValidResponse()) {
            int n = this.m_pkt.getParameter(0);
            int n2 = this.m_pkt.getParameter(1);
            int n3 = this.m_pkt.getParameter(2);
            int n4 = this.m_pkt.getParameter(3);
            return new SMBDiskInfo(this.getPCShare(), n, n2, n3, n4);
        }
        return null;
    }

    public final SMBFileInfo getFileInformation(String string) throws IOException {
        this.m_pkt.setCommand(8);
        this.m_pkt.setUserId(this.getUserId());
        this.m_pkt.setTreeId(this.getTreeId());
        this.m_pkt.setParameterCount(0);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\u0004');
        if (string.startsWith("\\")) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append(PCShare.makePath(this.getWorkingDirectory(), string));
        }
        stringBuffer.append('\u0000');
        this.m_pkt.setBytes(stringBuffer.toString().getBytes());
        this.m_pkt.ExchangeSMB(this, this.m_pkt);
        if (this.m_pkt.isValidResponse()) {
            int n = this.m_pkt.getParameter(0);
            int n2 = (this.m_pkt.getParameter(2) << 16) + this.m_pkt.getParameter(1);
            int n3 = (this.m_pkt.getParameter(4) << 16) + this.m_pkt.getParameter(3);
            return new SMBFileInfo(string, n3, n, n2);
        }
        if (this.m_pkt.getErrorClass() == 1 && this.m_pkt.getErrorCode() == 2) {
            throw new FileNotFoundException(string);
        }
        return null;
    }

    public final boolean isDirectory(String string) throws IOException {
        SMBPacket sMBPacket = new SMBPacket();
        sMBPacket.setCommand(16);
        sMBPacket.setUserId(this.getUserId());
        sMBPacket.setTreeId(this.getTreeId());
        sMBPacket.setParameterCount(0);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\u0004');
        if (string.startsWith("\\")) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append(PCShare.makePath(this.getWorkingDirectory(), string));
        }
        if (stringBuffer.charAt(stringBuffer.length() - 1) != '\\') {
            stringBuffer.append("\\");
        }
        stringBuffer.append('\u0000');
        sMBPacket.setBytes(stringBuffer.toString().getBytes());
        sMBPacket.ExchangeSMB(this, sMBPacket);
        return sMBPacket.isValidResponse();
    }

    public final SMBFile OpenFile(String string, int n) throws IOException {
        this.m_pkt.setCommand(45);
        this.m_pkt.setFlags(0);
        this.m_pkt.setParameterCount(15);
        this.m_pkt.setAndXCommand(255);
        this.m_pkt.setParameter(1, 0);
        this.m_pkt.setParameter(2, 1);
        this.m_pkt.setParameter(3, n);
        this.m_pkt.setParameter(4, 0);
        this.m_pkt.setParameter(5, 0);
        this.m_pkt.setParameter(6, 0);
        this.m_pkt.setParameter(7, 0);
        int n2 = 1;
        if (SMBAccessMode.AccessMode(n) == 1) {
            n2 = 18;
        } else if (SMBAccessMode.AccessMode(n) == 2) {
            n2 = 17;
        }
        this.m_pkt.setParameter(8, n2);
        this.m_pkt.setParameter(9, 0);
        this.m_pkt.setParameter(10, 0);
        this.m_pkt.setParameter(11, 0);
        this.m_pkt.setParameter(12, 0);
        this.m_pkt.setParameter(13, 0);
        this.m_pkt.setParameter(14, 0);
        this.m_pkt.setUserId(this.getUserId());
        this.m_pkt.setTreeId(this.getTreeId());
        StringBuffer stringBuffer = new StringBuffer();
        if (string.startsWith("\\")) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append(PCShare.makePath(this.getWorkingDirectory(), string));
        }
        stringBuffer.append('\u0000');
        this.m_pkt.setBytes(stringBuffer.toString().getBytes());
        this.m_pkt.ExchangeSMB(this, this.m_pkt);
        if (this.m_pkt.isValidResponse()) {
            int n3 = this.m_pkt.getParameter(2);
            int n4 = this.m_pkt.getParameter(3);
            int n5 = (this.m_pkt.getParameter(7) << 16) + this.m_pkt.getParameter(6);
            SMBFileInfo sMBFileInfo = new SMBFileInfo(string, n5, n4);
            return new SMBCIFSFile(this, sMBFileInfo, n3);
        }
        return null;
    }

    public final boolean RenameFile(String string, String string2, int n) throws IOException {
        this.m_pkt.setCommand(7);
        this.m_pkt.setUserId(this.getUserId());
        this.m_pkt.setTreeId(this.getTreeId());
        this.m_pkt.setParameterCount(1);
        this.m_pkt.setParameter(0, n);
        StringBuffer stringBuffer = new StringBuffer();
        if (string.startsWith("\\")) {
            stringBuffer.append('\u0004');
            stringBuffer.append(string);
            stringBuffer.append('\u0000');
            stringBuffer.append('\u0004');
            stringBuffer.append(string2);
            stringBuffer.append('\u0000');
        } else {
            stringBuffer.append(PCShare.makePath(this.getWorkingDirectory(), string));
            stringBuffer.append('\u0000');
            stringBuffer.append('\u0004');
            if (string2.startsWith("\\")) {
                stringBuffer.append(string2);
            } else {
                stringBuffer.append(PCShare.makePath(this.getWorkingDirectory(), string2));
            }
            stringBuffer.append('\u0000');
        }
        this.m_pkt.setBytes(stringBuffer.toString().getBytes());
        this.m_pkt.ExchangeSMB(this, this.m_pkt, true);
        return this.m_pkt.isValidResponse();
    }

    public final void setFileInformation(String string, SMBFileInfo sMBFileInfo, int n) throws IOException {
        this.m_pkt.setCommand(34);
        this.m_pkt.setUserId(this.getUserId());
        this.m_pkt.setTreeId(this.getTreeId());
        this.m_pkt.setFlags(0);
        this.m_pkt.setFlags2(0);
        this.m_pkt.setParameterCount(8);
        this.m_pkt.setParameter(0, sMBFileInfo.getFileAttributes());
        this.m_pkt.setParameter(1, sMBFileInfo.getDateTime().asSMBTime());
        this.m_pkt.setParameter(2, sMBFileInfo.getDateTime().asSMBDate());
        for (int i = 3; i < 8; ++i) {
            this.m_pkt.setParameter(i, 0);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\u0004');
        if (string.startsWith("\\")) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append(PCShare.makePath(this.getWorkingDirectory(), string));
        }
        stringBuffer.append('\u0000');
        this.m_pkt.setBytes(stringBuffer.toString().getBytes());
        this.m_pkt.ExchangeSMB(this, this.m_pkt, true);
    }

    public final SMBSearchContext StartSearch(String string, int n) throws IOException {
        SMBTransSearchContext sMBTransSearchContext = new SMBTransSearchContext(this, string, n);
        if (sMBTransSearchContext == null) {
            return null;
        }
        sMBTransSearchContext.StartSearch();
        return sMBTransSearchContext;
    }
}

