/*
 * Decompiled with CFR 0.152.
 */
package com.starla.smb;

import com.starla.smb.NetBIOSSession;
import com.starla.smb.PCShare;
import com.starla.smb.SMBDialect;
import com.starla.smb.SMBException;
import com.starla.smb.SMBPacket;
import java.io.IOException;
import java.io.PrintStream;
import java.util.BitSet;

public class SMBSession {
    protected static final int Closed = -1;
    public static final int DBGPacketType = 1;
    public static final int DBGDumpPacket = 2;
    public static final int DBGHexDump = 4;
    public static final int DEFAULT_BUFSIZE = 4096;
    private static final int _$22707 = 80;
    public static final int RawRead = 0;
    public static final int RawWrite = 1;
    public static final int UserMode = 2;
    public static final int EncryptPass = 3;
    private static final int _$22742 = 4;
    private int _$22753;
    private NetBIOSSession _$22762;
    protected SMBPacket m_pkt;
    private PCShare _$22773;
    private String _$22369;
    private String _$22784;
    private String _$22791;
    private byte[] _$22798;
    private int _$12385;
    private int _$22810;
    protected int m_treeid;
    private int _$22818;
    private int _$22827;
    private BitSet _$22839;
    private static int _$22850 = 1;
    private static int _$12428 = 0;
    private static PrintStream _$12446 = System.out;

    public SMBSession(PCShare pCShare, int n) {
        this._$22753 = n;
        this._$22773 = pCShare;
        this._$12385 = _$22850++;
        this.m_pkt = new SMBPacket(4096);
        this._$22839 = new BitSet(4);
    }

    protected final SMBPacket allocatePacket(int n) {
        if (n > this._$22827) {
            return new SMBPacket(this._$22827 + 4);
        }
        return new SMBPacket(n + 4);
    }

    protected final boolean allowsRawRead() {
        return this._$22839.get(0);
    }

    protected final boolean allowsRawWrite() {
        return this._$22839.get(1);
    }

    public void CloseSession() throws IOException {
        if (this.isActive()) {
            this._$22762.Hangup();
            this._$22762 = null;
        }
    }

    public final int getDeviceType() {
        return this._$22818;
    }

    public final int getDialect() {
        return this._$22753;
    }

    public final String getDomain() {
        return this._$22369;
    }

    public final byte[] getEncryptionKey() {
        return this._$22798;
    }

    public final String getLANManagerType() {
        return this._$22791;
    }

    public final int getMaximumPacketSize() {
        return this._$22827;
    }

    public final String getOperatingSystem() {
        return this._$22784;
    }

    public final String getPassword() {
        return this._$22773.getPassword();
    }

    protected final PCShare getPCShare() {
        return this._$22773;
    }

    public final String getServer() {
        return this._$22773.getNodeName();
    }

    protected final NetBIOSSession getSession() {
        return this._$22762;
    }

    public final boolean getSessionFlag(int n) {
        if (n > this._$22839.size()) {
            return false;
        }
        return this._$22839.get(n);
    }

    public final int getSessionId() {
        return this._$12385;
    }

    public final String getShareName() {
        return this._$22773.getShareName();
    }

    protected final int getTreeId() {
        return this.m_treeid;
    }

    public final int getUserId() {
        return this._$22810;
    }

    public final String getUserName() {
        return this._$22773.getUserName();
    }

    public static boolean hasDebugOption(int n) {
        if (_$12428 == 0) {
            return false;
        }
        return (_$12428 & n) != 0;
    }

    public final boolean isActive() {
        return this._$22762 != null;
    }

    public static boolean isDebug() {
        return _$12428 != 0;
    }

    protected final void pingServer(int n) throws SMBException, IOException {
        SMBPacket sMBPacket = new SMBPacket(80);
        sMBPacket.setCommand(43);
        sMBPacket.setFlags(0);
        sMBPacket.setTreeId(this.getTreeId());
        sMBPacket.setUserId(this.getUserId());
        sMBPacket.setParameterCount(1);
        sMBPacket.setParameter(0, n);
        String string = "ECHO";
        sMBPacket.setBytes(string.getBytes());
        sMBPacket.SendSMB(this);
        while (n > 0) {
            sMBPacket.ReceiveSMB(this);
            --n;
        }
    }

    public static void print(String string) {
        _$12446.print(string);
    }

    public static void println() {
        _$12446.println();
    }

    public static void println(String string) {
        _$12446.println(string);
    }

    public static void setDebug(int n) {
        _$12428 = n;
    }

    protected final void setDeviceType(int n) {
        this._$22818 = n;
    }

    protected final void setDialect(int n) {
        this._$22753 = n;
    }

    protected final void setDomain(String string) {
        this._$22369 = string;
    }

    public final void setEncryptionKey(byte[] byArray) {
        this._$22798 = byArray;
    }

    protected final void setLANManagerType(String string) {
        this._$22791 = string;
    }

    protected final void setMaximumPacketSize(int n) {
        this._$22827 = n;
    }

    protected final void setOperatingSystem(String string) {
        this._$22784 = string;
    }

    protected final void setPassword(String string) {
        this._$22773.setPassword(string);
    }

    public final void setRawMode(int n) {
        if ((n & 1) != 0) {
            this.setSessionFlag(0, true);
        }
        if ((n & 2) != 0) {
            this.setSessionFlag(1, true);
        }
    }

    public final void setSecurityMode(int n) {
        if ((n & 1) != 0) {
            this.setSessionFlag(2, true);
        }
        if ((n & 2) != 0) {
            this.setSessionFlag(3, true);
        }
    }

    protected final void setServer(String string) {
        this._$22773.setNodeName(string);
    }

    protected final void setSession(NetBIOSSession netBIOSSession) {
        this._$22762 = netBIOSSession;
    }

    protected final void setSessionFlag(int n, boolean bl) {
        if (bl) {
            this._$22839.set(n);
        } else {
            this._$22839.clear(n);
        }
    }

    protected final void setShareName(String string) {
        this._$22773.setShareName(string);
    }

    protected final void setTreeId(int n) {
        this.m_treeid = n;
    }

    protected final void setUserId(int n) {
        this._$22810 = n;
    }

    protected final void setUserName(String string) {
        this._$22773.setUserName(string);
    }

    public String toString() {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("[\\\\").concat(String.valueOf(this.getServer()))).concat(String.valueOf("\\"))).concat(String.valueOf(this.getShareName()))).concat(String.valueOf(":"))).concat(String.valueOf(SMBDialect.DialectTypeString(this._$22753)))).concat(String.valueOf(",UserId="))).concat(String.valueOf(this.getUserId()))).concat(String.valueOf("]"));
    }
}

