/*
 * Decompiled with CFR 0.152.
 */
package com.starla.smb;

import com.starla.smb.NetBIOSPacket;
import com.starla.util.DataPacker;
import com.starla.util.HexDump;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Vector;

final class NetBIOSSession {
    private int _$12286;
    private Socket _$12302;
    private DataInputStream _$12325;
    private DataOutputStream _$12345;
    private int _$12350 = 30000;
    public static final char Normal = ' ';
    public static final char WorkStation = '\u0000';
    public static final char MasterBrowser = '\u001d';
    public static final char DomainMasterBrowser = '\u001b';
    public static final char BrowseMasterGroup = '\u0001';
    private static int _$12385 = 0;
    private static short _$12394 = 1;
    private static DatagramSocket _$12417 = null;
    private static boolean _$12428 = false;
    private static PrintStream _$12446 = System.out;
    private static String _$12451 = null;

    public NetBIOSSession() {
        this._$12286 = 139;
        this._$12302 = null;
    }

    public NetBIOSSession(int n) {
        this._$12350 = n;
        this._$12286 = 139;
        this._$12302 = null;
    }

    public void Call(String string, String string2) throws IOException {
        if (_$12428) {
            _$12446.println(String.valueOf("NetBIOS: Call ").concat(String.valueOf(string)));
        }
        this._$12302 = new Socket(string, this._$12286);
        this._$12302.setSoTimeout(this._$12350);
        this._$12325 = new DataInputStream(this._$12302.getInputStream());
        this._$12345 = new DataOutputStream(this._$12302.getOutputStream());
        byte[] byArray = new byte[72];
        byArray[0] = -127;
        byArray[1] = 0;
        DataPacker.putShort((short)68, byArray, 2);
        byArray[38] = 32;
        String string3 = NetBIOSSession.ConvertName(String.valueOf(String.valueOf(InetAddress.getLocalHost().getHostName()).concat(String.valueOf("_"))).concat(String.valueOf(_$12385++)));
        int n = 0;
        while (n < 32) {
            byArray[39 + n] = (byte)string3.charAt(n++);
        }
        byArray[4] = 32;
        String string4 = NetBIOSSession.ConvertName(string);
        int n2 = 0;
        while (n2 < 32) {
            byArray[5 + n2] = (byte)string4.charAt(n2++);
        }
        this._$12345.write(byArray, 0, 72);
        byte[] byArray2 = new byte[9];
        if (this._$12325.read(byArray2, 0, 9) >= 4) {
            int n3 = byArray2[0] & 0xFF;
            if (_$12428) {
                _$12446.print("NetBIOS: Rx ");
                switch (n3) {
                    case 130: {
                        _$12446.println("Session_Ack");
                        break;
                    }
                    case 131: {
                        _$12446.println("Session_Reject");
                        break;
                    }
                    case 132: {
                        _$12446.println("Session_Retarget");
                        break;
                    }
                    default: {
                        _$12446.println(String.valueOf("Unknown - ").concat(String.valueOf(Integer.toHexString(n3))));
                    }
                }
            }
            if (n3 == 130) {
                return;
            }
            if (n3 == 131) {
                throw new IOException("NetBIOS session reject");
            }
            if (n3 == 132) {
                throw new IOException("NetBIOS ReTarget");
            }
        }
        this.Hangup();
        throw new IOException("Invalid NetBIOS response");
    }

    public static String ConvertName(String string) {
        return NetBIOSSession.ConvertName(string, ' ');
    }

    public static String ConvertName(String string, char c) {
        StringBuffer stringBuffer = new StringBuffer(string.toUpperCase());
        if (stringBuffer.length() > 15) {
            stringBuffer.setLength(15);
        }
        while (stringBuffer.length() < 15) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(c);
        String string2 = new String("ABCDEFGHIJKLMNOP");
        StringBuffer stringBuffer2 = new StringBuffer(32);
        int n = 0;
        while (n < stringBuffer.length()) {
            char c2;
            if ((c2 = stringBuffer.charAt(n++)) == ' ') {
                stringBuffer2.append("CA");
                continue;
            }
            stringBuffer2.append(string2.charAt(c2 / 16));
            stringBuffer2.append(string2.charAt(c2 % 16));
        }
        return stringBuffer2.toString();
    }

    public static String DecodeName(String string) {
        if (string == null || string.length() != 32) {
            return "";
        }
        String string2 = new String("ABCDEFGHIJKLMNOP");
        StringBuffer stringBuffer = new StringBuffer(16);
        for (int i = 0; i < 32; i += 2) {
            char c = string.charAt(i);
            char c2 = string.charAt(i + 1);
            if (c == 'C' && c2 == 'A') {
                stringBuffer.append(' ');
                continue;
            }
            int n = string2.indexOf(c) << 4;
            stringBuffer.append((char)((n += string2.indexOf(c2)) & 0xFF));
        }
        return stringBuffer.toString();
    }

    protected void finalize() {
        try {
            this._$12302.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String FindName(String string, char c, int n) throws IOException {
        InetAddress inetAddress = InetAddress.getLocalHost();
        if (_$12417 == null) {
            _$12417 = new DatagramSocket();
        }
        _$12417.setSoTimeout(n);
        NetBIOSPacket netBIOSPacket = new NetBIOSPacket();
        short s = _$12394;
        _$12394 = (short)(s + 1);
        netBIOSPacket.setTransactionId(s);
        netBIOSPacket.setOpcode(0);
        netBIOSPacket.setFlags(1);
        netBIOSPacket.setQuestionCount(1);
        netBIOSPacket.setQuestionName(string, c, 32, 1);
        String string2 = inetAddress.getHostAddress();
        int n2 = string2.indexOf(46);
        if (n2 == -1) {
            return null;
        }
        if (NetBIOSSession.getSubnetMask() == null) {
            NetBIOSSession.GenerateSubnetMask(null);
        }
        InetAddress inetAddress2 = InetAddress.getByName(NetBIOSSession.getSubnetMask());
        DatagramPacket datagramPacket = new DatagramPacket(netBIOSPacket.getBuffer(), netBIOSPacket.getLength(), inetAddress2, 137);
        byte[] byArray = new byte[256];
        DatagramPacket datagramPacket2 = new DatagramPacket(byArray, byArray.length);
        NetBIOSPacket netBIOSPacket2 = new NetBIOSPacket(byArray);
        if (_$12428) {
            netBIOSPacket.DumpPacket();
        }
        _$12417.send(datagramPacket);
        boolean bl = false;
        do {
            _$12417.receive(datagramPacket2);
            if (_$12428) {
                System.out.println("NetBIOS: Rx Datagram");
                netBIOSPacket2.DumpPacket();
            }
            if (!netBIOSPacket2.isResponse() || netBIOSPacket2.getOpcode() != 16) continue;
            bl = true;
        } while (!bl);
        return NetBIOSSession.NetBIOSName(datagramPacket2.getAddress().getHostName());
    }

    public static Vector FindNameList(String string, char c, int n) throws IOException {
        InetAddress inetAddress = InetAddress.getLocalHost();
        if (_$12417 == null) {
            _$12417 = new DatagramSocket();
        }
        _$12417.setSoTimeout(n);
        NetBIOSPacket netBIOSPacket = new NetBIOSPacket();
        short s = _$12394;
        _$12394 = (short)(s + 1);
        netBIOSPacket.setTransactionId(s);
        netBIOSPacket.setOpcode(0);
        netBIOSPacket.setFlags(1);
        netBIOSPacket.setQuestionCount(1);
        netBIOSPacket.setQuestionName(string, c, 32, 1);
        String string2 = inetAddress.getHostAddress();
        int n2 = string2.indexOf(46);
        if (n2 == -1) {
            return null;
        }
        if (NetBIOSSession.getSubnetMask() == null) {
            NetBIOSSession.GenerateSubnetMask(null);
        }
        InetAddress inetAddress2 = InetAddress.getByName(NetBIOSSession.getSubnetMask());
        DatagramPacket datagramPacket = new DatagramPacket(netBIOSPacket.getBuffer(), netBIOSPacket.getLength(), inetAddress2, 137);
        byte[] byArray = new byte[256];
        DatagramPacket datagramPacket2 = new DatagramPacket(byArray, byArray.length);
        NetBIOSPacket netBIOSPacket2 = new NetBIOSPacket(byArray);
        if (_$12428) {
            netBIOSPacket.DumpPacket();
        }
        Vector<InetAddress> vector = new Vector<InetAddress>();
        long l = System.currentTimeMillis() + (long)n;
        _$12417.send(datagramPacket);
        do {
            try {
                _$12417.receive(datagramPacket2);
                if (_$12428) {
                    System.out.println("NetBIOS: Rx Datagram");
                    netBIOSPacket2.DumpPacket();
                }
                if (!netBIOSPacket2.isResponse() || netBIOSPacket2.getOpcode() != 16) continue;
                vector.addElement(datagramPacket2.getAddress());
            }
            catch (IOException iOException) {
                if (!_$12428) continue;
                System.out.println(iOException.toString());
            }
        } while (System.currentTimeMillis() < l);
        if (vector.size() == 0) {
            return null;
        }
        Vector<String> vector2 = new Vector<String>();
        for (int i = 0; i < vector.size(); ++i) {
            InetAddress inetAddress3 = (InetAddress)vector.elementAt(i);
            String string3 = NetBIOSSession.NetBIOSName(inetAddress3.getHostName());
            if (vector2.contains(string3)) continue;
            vector2.addElement(string3);
        }
        return vector2;
    }

    public static String GenerateSubnetMask(String string) throws UnknownHostException {
        int n;
        String string2 = string;
        if (string2 == null) {
            string2 = InetAddress.getLocalHost().getHostAddress();
        }
        if ((n = string2.indexOf(46)) != -1) {
            String string3 = string2.substring(0, n);
            int n2 = Integer.valueOf(string3);
            if (n2 <= 127) {
                _$12451 = String.valueOf(String.valueOf("").concat(String.valueOf(n2))).concat(String.valueOf(".255.255.255"));
            } else if (n2 <= 191) {
                ++n;
                while (string2.charAt(n) != '.' && n < string2.length()) {
                    ++n;
                }
                if (n < string2.length()) {
                    _$12451 = String.valueOf(string2.substring(0, n)).concat(String.valueOf(".255.255"));
                }
            } else if (n2 <= 223) {
                ++n;
                int n3 = 1;
                while (n3 < 3 && n < string2.length()) {
                    if (string2.charAt(n++) != '.') continue;
                    ++n3;
                }
                if (n < string2.length()) {
                    _$12451 = String.valueOf(string2.substring(0, n - 1)).concat(String.valueOf(".255"));
                }
            }
        }
        if (_$12451 == null) {
            _$12451 = "255.255.255.255";
        }
        if (_$12428) {
            System.out.println(String.valueOf("NetBIOS: Set subnet mask to ").concat(String.valueOf(_$12451)));
        }
        return _$12451;
    }

    public static String getSubnetMask() {
        return _$12451;
    }

    public int getTimeout() {
        return this._$12350;
    }

    public void Hangup() {
        if (_$12428) {
            _$12446.println("NetBIOS: HangUp");
        }
        if (this._$12302 != null) {
            try {
                this._$12302.close();
                this._$12302 = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static boolean isDebug() {
        return _$12428;
    }

    public static String NetBIOSName(String string) {
        String string2 = new String(string.toUpperCase());
        int n = string2.indexOf(".");
        if (n != -1) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    public int Receive(byte[] byArray) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        do {
            n3 = this._$12325.read(byArray, 0, 4);
            if (_$12428) {
                _$12446.println(String.valueOf(String.valueOf("NetBIOS: Read ").concat(String.valueOf(n3))).concat(String.valueOf(" bytes")));
            }
            if (n3 >= 4) continue;
            throw new IOException("NetBIOS Short Read");
        } while ((n4 = byArray[0] & 0xFF) == 133);
        if (_$12428) {
            _$12446.print("NetBIOS: Rx pkt ");
            switch (n4) {
                case 0: {
                    _$12446.println("Session_Message");
                    break;
                }
                case 132: {
                    _$12446.print("Session_Retarget - ");
                    n2 = DataPacker.getShort(byArray, 2);
                    n2 = this._$12325.read(byArray, 4, n2);
                    n = DataPacker.getInt(byArray, 4);
                    _$12446.println(Integer.toHexString(n));
                    break;
                }
                default: {
                    _$12446.println(String.valueOf(String.valueOf(String.valueOf("NetBIOS: Rx Pkt Type = ").concat(String.valueOf(n4))).concat(String.valueOf(", "))).concat(String.valueOf(Integer.toHexString(n4))));
                }
            }
        }
        if (n4 != 0) {
            throw new IOException(String.valueOf("NetBIOS Unknown Packet Type, ").concat(String.valueOf(n4)));
        }
        n2 = DataPacker.getShort(byArray, 2);
        if (_$12428) {
            _$12446.println(String.valueOf("NetBIOS: Rx Data Len = ").concat(String.valueOf(n2)));
        }
        if (byArray.length < n2 + 4) {
            _$12446.println(String.valueOf(String.valueOf(String.valueOf("NetBIOS: Rx Pkt Type = ").concat(String.valueOf(n4))).concat(String.valueOf(", "))).concat(String.valueOf(Integer.toHexString(n4))));
            _$12446.println(String.valueOf(String.valueOf(String.valueOf("NetBIOS: Rx Buf Too Small pkt=").concat(String.valueOf(n2))).concat(String.valueOf(" buflen="))).concat(String.valueOf(byArray.length)));
            HexDump.Dump(byArray, 16, 0);
            throw new IOException(String.valueOf(String.valueOf(String.valueOf(String.valueOf("NetBIOS Recv Buffer Too Small (pkt=").concat(String.valueOf(n2))).concat(String.valueOf("/buf="))).concat(String.valueOf(byArray.length))).concat(String.valueOf(")")));
        }
        n = 0;
        int n5 = 4;
        while (n2 > 0) {
            n3 = this._$12325.read(byArray, n5, n2);
            n += n3;
            n2 -= n3;
            n5 += n3;
        }
        return n;
    }

    public boolean Send(byte[] byArray, int n) throws IOException {
        if (this._$12302 == null) {
            return false;
        }
        if (_$12428) {
            _$12446.println(String.valueOf(String.valueOf("NetBIOS: Tx ").concat(String.valueOf(n))).concat(String.valueOf(" bytes")));
        }
        byArray[0] = 0;
        byArray[1] = 0;
        DataPacker.putShort((short)n, byArray, 2);
        int n2 = n + 4;
        this._$12345.write(byArray, 0, n2);
        return true;
    }

    public static void setDebug(boolean bl) {
        _$12428 = bl;
    }

    public static void setSubnetMask(String string) {
        _$12451 = string;
    }

    public void setTimeout(int n) {
        this._$12350 = n;
    }
}

