/*
 * Decompiled with CFR 0.152.
 */
package com.starla.smb;

import com.starla.smb.DialectSelector;
import com.starla.smb.NetBIOSSession;
import com.starla.smb.PCShare;
import com.starla.smb.SMBAdminSession;
import com.starla.smb.SMBCIFSDiskSession;
import com.starla.smb.SMBCIFSPipeSession;
import com.starla.smb.SMBCIFSPrintSession;
import com.starla.smb.SMBCoreDiskSession;
import com.starla.smb.SMBCorePrintSession;
import com.starla.smb.SMBDES;
import com.starla.smb.SMBDialect;
import com.starla.smb.SMBDiskSession;
import com.starla.smb.SMBException;
import com.starla.smb.SMBIPCSession;
import com.starla.smb.SMBPacket;
import com.starla.smb.SMBPrintSession;
import com.starla.smb.SMBServerInfo;
import com.starla.smb.SMBServerList;
import com.starla.smb.SMBSession;
import com.starla.smb.UnsupportedDeviceTypeException;
import com.starla.util.DataPacker;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Vector;

public final class SMBSessionFactory {
    private static DialectSelector _$23277;
    private static Vector _$23290;
    private static int _$12385;
    private static String _$23302;
    private static String _$23315;
    private static int _$23334;
    private static SMBDES _$23346;

    private static final void _$23447(SMBPacket sMBPacket) {
        sMBPacket.setCommand(114);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < _$23290.size(); ++i) {
            stringBuffer.append('\u0002');
            stringBuffer.append((String)_$23290.elementAt(i));
            stringBuffer.append('\u0000');
        }
        sMBPacket.setBytes(stringBuffer.toString().getBytes());
    }

    private static final void _$23467() throws SMBException {
        if (System.currentTimeMillis() > 921456036070L) {
            throw new SMBException(4, 9999);
        }
    }

    private static final int _$23479(PCShare pCShare, SMBSession sMBSession, int n) throws SMBException, UnsupportedDeviceTypeException, IOException {
        if (SMBSessionFactory.hasSessionDebug()) {
            SMBSession.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("** Connecting to ").concat(String.valueOf(pCShare.getNodeName()))).concat(String.valueOf(" "))).concat(String.valueOf(pCShare.getShareName()))).concat(String.valueOf(" ("))).concat(String.valueOf(pCShare.getUserName()))).concat(String.valueOf("/"))).concat(String.valueOf(pCShare.getPassword()))).concat(String.valueOf(")")));
        }
        SMBPacket sMBPacket = new SMBPacket();
        sMBPacket.setCommand(112);
        sMBPacket.setFlags(0);
        sMBPacket.setUserId(sMBSession.getUserId());
        sMBPacket.setParameterCount(0);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\u0004');
        stringBuffer.append("\\\\");
        stringBuffer.append(pCShare.getNodeName().toUpperCase());
        stringBuffer.append("\\");
        stringBuffer.append(pCShare.getShareName().toUpperCase());
        stringBuffer.append('\u0000');
        stringBuffer.append('\u0004');
        stringBuffer.append(pCShare.getPassword());
        stringBuffer.append('\u0000');
        SMBSessionFactory._$23467();
        stringBuffer.append('\u0004');
        switch (n) {
            case 0: {
                stringBuffer.append("A:");
                break;
            }
            case 1: {
                stringBuffer.append("LPT1:");
                break;
            }
            case 3: {
                stringBuffer.append("IPC");
            }
        }
        stringBuffer.append('\u0000');
        sMBPacket.setBytes(stringBuffer.toString().getBytes());
        sMBPacket.ExchangeSMB(sMBSession, sMBPacket);
        if (sMBPacket.isValidResponse() && sMBPacket.getParameterCount() == 2) {
            return sMBPacket.getParameter(1);
        }
        throw new SMBException(sMBPacket);
    }

    private static final void _$23524(PCShare pCShare, SMBSession sMBSession, SMBPacket sMBPacket) throws SMBException, IOException {
        int n;
        Object object;
        int n2;
        int n3 = 0;
        boolean bl = false;
        if (sMBSession.getDialect() == 7) {
            sMBSession.setSecurityMode(sMBPacket.getParameter(1) & 0xFF);
            if (sMBPacket.getParameterCount() >= 17) {
                n3 = 8;
            }
            bl = true;
        } else if (sMBSession.getDialect() > 1) {
            sMBSession.setSecurityMode(sMBPacket.getParameter(1));
            if (sMBPacket.getParameterCount() >= 11) {
                n3 = sMBPacket.getParameter(11) & 0xFF;
            }
        }
        if (sMBPacket.getByteCount() > 0) {
            Object object2;
            int n4 = sMBPacket.getByteCount();
            n2 = sMBPacket.getByteOffset();
            object = sMBPacket.getBuffer();
            if (n3 > 0) {
                object2 = new byte[n3];
                for (n = 0; n < n3; ++n) {
                    object2[n] = object[n2++];
                }
                sMBSession.setEncryptionKey((byte[])object2);
                if (SMBSession.hasDebugOption(2)) {
                    SMBSession.print("** Encryption Key: ");
                    for (int i = 0; i < 8; ++i) {
                        int n5 = object2[i] & 0xFF;
                        if (n5 < 16) {
                            SMBSession.print("0");
                        }
                        SMBSession.print(String.valueOf(Integer.toHexString(n5).toUpperCase()).concat(String.valueOf(" ")));
                    }
                    SMBSession.println(String.valueOf(", length = ").concat(String.valueOf(n3)));
                }
            }
            object2 = !bl ? (Object)DataPacker.getString((byte[])object, n2, n4) : (Object)DataPacker.getUnicodeString((byte[])object, n2, n4);
            sMBSession.setDomain((String)object2);
            if (SMBSession.hasDebugOption(2)) {
                SMBSession.println(String.valueOf("** Server domain : ").concat(String.valueOf(sMBSession.getDomain())));
            }
        }
        SMBSessionFactory._$23467();
        byte[] byArray = null;
        if (sMBSession.getSessionFlag(3) && sMBSession.getEncryptionKey() != null) {
            if (_$23346 == null) {
                _$23346 = new SMBDES();
            }
            byArray = SMBDES.P24(sMBSession.getPassword(), sMBSession.getEncryptionKey());
            if (SMBSession.hasDebugOption(2)) {
                SMBSession.print("** Encrypted Password: ");
                for (n2 = 0; n2 < 24; ++n2) {
                    int n6 = byArray[n2] & 0xFF;
                    if (n6 < 16) {
                        SMBSession.print("0");
                    }
                    SMBSession.print(String.valueOf(Integer.toHexString(n6).toUpperCase()).concat(String.valueOf(" ")));
                }
                SMBSession.println();
            }
        } else {
            byArray = sMBSession.getPassword().getBytes();
        }
        SMBPacket sMBPacket2 = new SMBPacket();
        sMBPacket2.setCommand(115);
        if (sMBSession.getDialect() == 7) {
            sMBPacket2.setParameterCount(13);
            sMBPacket2.setAndXCommand(255);
            sMBPacket2.setParameter(1, 0);
            sMBPacket2.setParameter(2, SMBSessionFactory._$23596());
            sMBPacket2.setParameter(3, 5);
            sMBPacket2.setParameter(4, 0);
            sMBPacket2.setParameter(5, 0);
            sMBPacket2.setParameter(6, 0);
            sMBPacket2.setParameter(7, byArray.length);
            sMBPacket2.setParameter(8, 0);
            sMBPacket2.setParameter(9, 0);
            sMBPacket2.setParameter(10, 0);
            sMBPacket2.setParameter(11, 0);
            sMBPacket2.setParameter(12, 0);
            object = new StringBuffer();
            for (int i = 0; i < byArray.length; ++i) {
                ((StringBuffer)object).append((char)byArray[i] & 0xFF);
            }
            ((StringBuffer)object).append(sMBSession.getUserName());
            ((StringBuffer)object).append('\u0000');
            ((StringBuffer)object).append("?");
            ((StringBuffer)object).append('\u0000');
            ((StringBuffer)object).append("Java VM");
            ((StringBuffer)object).append('\u0000');
            ((StringBuffer)object).append("JLAN");
            ((StringBuffer)object).append('\u0000');
            sMBPacket2.setBytes(((StringBuffer)object).toString().getBytes());
        } else {
            sMBPacket2.setUserId(1);
            sMBPacket2.setParameterCount(10);
            sMBPacket2.setAndXCommand(255);
            sMBPacket2.setParameter(1, 0);
            sMBPacket2.setParameter(2, SMBSessionFactory._$23596());
            sMBPacket2.setParameter(3, 2);
            sMBPacket2.setParameter(4, 0);
            sMBPacket2.setParameter(5, 0);
            sMBPacket2.setParameter(6, 0);
            sMBPacket2.setParameter(7, byArray.length);
            sMBPacket2.setParameter(8, 0);
            sMBPacket2.setParameter(9, 0);
            object = sMBPacket2.getBuffer();
            int n7 = sMBPacket2.getByteOffset();
            for (n = 0; n < byArray.length; ++n) {
                object[n7++] = byArray[n];
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(pCShare.getUserName());
            stringBuffer.append('\u0000');
            stringBuffer.append("?");
            stringBuffer.append('\u0000');
            stringBuffer.append("Java VM");
            stringBuffer.append('\u0000');
            stringBuffer.append("JLAN");
            stringBuffer.append('\u0000');
            byte[] byArray2 = stringBuffer.toString().getBytes();
            for (int i = 0; i < byArray2.length; ++i) {
                object[n7++] = byArray2[i];
            }
            sMBPacket2.setByteCount(byArray.length + byArray2.length);
        }
        sMBPacket2.ExchangeSMB(sMBSession, sMBPacket2);
        if (!sMBPacket2.isValidResponse()) {
            throw new SMBException(sMBPacket2);
        }
        sMBSession.setUserId(sMBPacket2.getUserId());
        if (sMBSession.getDialect() == 0 || sMBSession.getDialect() == 1) {
            sMBSession.setMaximumPacketSize(sMBPacket2.getParameter(2));
        }
    }

    private static final SMBDiskSession _$23618(PCShare pCShare, SMBPacket sMBPacket, NetBIOSSession netBIOSSession, int n) throws SMBException, IOException {
        SMBDiskSession sMBDiskSession;
        if (n == 0 || n == 1) {
            sMBDiskSession = new SMBCoreDiskSession(pCShare, n);
        } else {
            sMBDiskSession = new SMBCIFSDiskSession(pCShare, n);
            sMBDiskSession.setMaximumPacketSize(sMBPacket.getParameter(2));
            sMBDiskSession.setRawMode(sMBPacket.getParameter(5));
        }
        sMBDiskSession.setSession(netBIOSSession);
        SMBSessionFactory._$23524(pCShare, sMBDiskSession, sMBPacket);
        try {
            int n2 = SMBSessionFactory._$23479(pCShare, sMBDiskSession, 0);
            if (n2 != -1) {
                sMBDiskSession.setTreeId(n2);
                SMBDiskSession sMBDiskSession2 = sMBDiskSession;
                return sMBDiskSession2;
            }
        }
        catch (UnsupportedDeviceTypeException unsupportedDeviceTypeException) {
            // empty catch block
        }
        return null;
    }

    private static final SMBIPCSession _$23641(PCShare pCShare, SMBPacket sMBPacket, NetBIOSSession netBIOSSession, int n) throws SMBException, IOException {
        if (n == 0 || n == 1) {
            throw new SMBException(5, 1);
        }
        SMBCIFSPipeSession sMBCIFSPipeSession = new SMBCIFSPipeSession(pCShare, n);
        sMBCIFSPipeSession.setSession(netBIOSSession);
        sMBCIFSPipeSession.setMaximumPacketSize(sMBPacket.getParameter(2));
        sMBCIFSPipeSession.setRawMode(sMBPacket.getParameter(5));
        SMBSessionFactory._$23524(pCShare, sMBCIFSPipeSession, sMBPacket);
        try {
            int n2 = SMBSessionFactory._$23479(pCShare, sMBCIFSPipeSession, 3);
            if (n2 != -1) {
                sMBCIFSPipeSession.setTreeId(n2);
                SMBCIFSPipeSession sMBCIFSPipeSession2 = sMBCIFSPipeSession;
                return sMBCIFSPipeSession2;
            }
        }
        catch (UnsupportedDeviceTypeException unsupportedDeviceTypeException) {
            // empty catch block
        }
        return null;
    }

    private static final SMBPrintSession _$23664(PCShare pCShare, SMBPacket sMBPacket, NetBIOSSession netBIOSSession, int n) throws SMBException, IOException {
        SMBPrintSession sMBPrintSession;
        if (n == 0 || n == 1) {
            sMBPrintSession = new SMBCorePrintSession(pCShare, n);
        } else {
            sMBPrintSession = new SMBCIFSPrintSession(pCShare, n);
            sMBPrintSession.setMaximumPacketSize(sMBPacket.getParameter(2));
            sMBPrintSession.setRawMode(sMBPacket.getParameter(5));
        }
        sMBPrintSession.setSession(netBIOSSession);
        SMBSessionFactory._$23524(pCShare, sMBPrintSession, sMBPacket);
        try {
            int n2 = SMBSessionFactory._$23479(pCShare, sMBPrintSession, 1);
            if (n2 != -1) {
                sMBPrintSession.setTreeId(n2);
                SMBPrintSession sMBPrintSession2 = sMBPrintSession;
                return sMBPrintSession2;
            }
        }
        catch (UnsupportedDeviceTypeException unsupportedDeviceTypeException) {
            // empty catch block
        }
        return null;
    }

    private static final SMBSession _$23684(PCShare pCShare, SMBPacket sMBPacket, NetBIOSSession netBIOSSession, int n) throws SMBException, IOException {
        SMBSession sMBSession = new SMBSession(pCShare, n);
        sMBSession.setSession(netBIOSSession);
        SMBSessionFactory._$23524(pCShare, sMBSession, sMBPacket);
        return sMBSession;
    }

    private static final int _$23596() {
        return _$23334;
    }

    public static final SMBServerList getDomainList() throws IOException, SMBException {
        PCShare pCShare = null;
        SMBAdminSession sMBAdminSession = null;
        try {
            String string = InetAddress.getLocalHost().getHostName().toUpperCase();
            pCShare = new PCShare(string, "", "", "");
            sMBAdminSession = SMBSessionFactory.OpenAdminSession(pCShare);
            SMBServerList sMBServerList = sMBAdminSession.getServerList(Integer.MIN_VALUE);
            sMBAdminSession.CloseSession();
            SMBServerList sMBServerList2 = sMBServerList;
            return sMBServerList2;
        }
        catch (SMBException sMBException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\u0001');
        stringBuffer.append('\u0002');
        stringBuffer.append("__MSBROWSE__");
        stringBuffer.append('\u0002');
        String string = stringBuffer.toString();
        String string2 = NetBIOSSession.FindName(string, '\u0001', 2000);
        if (string2 == null) {
            return null;
        }
        pCShare = new PCShare(string2, "", "", "");
        sMBAdminSession = SMBSessionFactory.OpenAdminSession(pCShare);
        SMBServerList sMBServerList = sMBAdminSession.getServerList(Integer.MIN_VALUE);
        sMBAdminSession.CloseSession();
        return sMBServerList;
    }

    private String _$23797() {
        return _$23315;
    }

    public String getLocalDomain() {
        return _$23302;
    }

    public static final SMBServerList getServerList(String string) throws SMBException, IOException {
        return SMBSessionFactory.getServerList(string, 0xFFFFFFF);
    }

    public static final SMBServerList getServerList(String string, int n) throws IOException, SMBException {
        Object object;
        PCShare pCShare = null;
        SMBAdminSession sMBAdminSession = null;
        String string2 = null;
        try {
            object = InetAddress.getLocalHost().getHostName().toUpperCase();
            pCShare = new PCShare((String)object, "", "", "");
            sMBAdminSession = SMBSessionFactory.OpenAdminSession(pCShare);
            SMBServerList sMBServerList = sMBAdminSession.getServerList(Integer.MIN_VALUE);
            if (sMBServerList != null) {
                int n2 = 0;
                while (n2 < sMBServerList.NumberOfServers() && string2 == null) {
                    SMBServerInfo sMBServerInfo = sMBServerList.getServerInfo(n2);
                    if (sMBServerInfo.getServerName().compareTo(string) == 0) {
                        string2 = sMBServerInfo.getComment();
                        continue;
                    }
                    ++n2;
                }
                if (string2 != null && string2.compareTo((String)object) != 0) {
                    sMBAdminSession.CloseSession();
                    sMBAdminSession = null;
                }
            }
        }
        catch (SMBException sMBException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (string2 == null) {
            string2 = NetBIOSSession.FindName(string.toUpperCase(), '\u001d', 2000);
        }
        if (sMBAdminSession == null) {
            pCShare = new PCShare(string2, "", "", "");
            sMBAdminSession = SMBSessionFactory.OpenAdminSession(pCShare);
        }
        object = sMBAdminSession.getServerList(n & 0xFFFFFFF);
        sMBAdminSession.CloseSession();
        return object;
    }

    public static final boolean hasSessionDebug() {
        return SMBSession.isDebug();
    }

    public static final String isVersion() {
        return "1.2 Pro";
    }

    public static final SMBAdminSession OpenAdminSession(PCShare pCShare) throws SMBException, IOException {
        pCShare.setShareName("IPC$");
        SMBIPCSession sMBIPCSession = (SMBIPCSession)SMBSessionFactory._$23889(pCShare, 3, 30000);
        return new SMBAdminSession(sMBIPCSession);
    }

    public static final SMBDiskSession OpenDisk(PCShare pCShare) throws SMBException, IOException {
        return (SMBDiskSession)SMBSessionFactory._$23889(pCShare, 0, 30000);
    }

    public static final SMBIPCSession OpenPipe(PCShare pCShare) throws SMBException, IOException {
        return (SMBIPCSession)SMBSessionFactory._$23889(pCShare, 3, 30000);
    }

    public static final SMBPrintSession OpenPrinter(PCShare pCShare) throws SMBException, IOException {
        return (SMBPrintSession)SMBSessionFactory._$23889(pCShare, 1, 30000);
    }

    private static SMBSession _$23889(PCShare pCShare, int n, int n2) throws SMBException, IOException {
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(String.valueOf(InetAddress.getLocalHost().getHostName()).concat(String.valueOf("_"))).concat(String.valueOf(_$12385++)));
        if (SMBSession.isDebug()) {
            SMBSession.println(String.valueOf(String.valueOf(String.valueOf("** New session from ").concat(String.valueOf(stringBuffer))).concat(String.valueOf(" to "))).concat(String.valueOf(pCShare.toString())));
            SMBSession.println(String.valueOf(String.valueOf(String.valueOf("** os.arch = ").concat(String.valueOf(System.getProperty("os.arch")))).concat(String.valueOf(", java.version: "))).concat(String.valueOf(System.getProperty("java.version"))));
        }
        NetBIOSSession netBIOSSession = new NetBIOSSession(n2);
        netBIOSSession.Call(pCShare.getNodeName(), stringBuffer.toString());
        SMBPacket sMBPacket = new SMBPacket();
        SMBSessionFactory._$23447(sMBPacket);
        sMBPacket.ExchangeSMB(netBIOSSession, sMBPacket, true);
        String string = (String)_$23290.elementAt(sMBPacket.getParameter(0));
        int n3 = 0;
        if (SMBSession.isDebug()) {
            SMBSession.println(String.valueOf("** SessionFactory: Negotiated SMB dialect ").concat(String.valueOf(string)));
        }
        while (n3 < SMBDialect.NumberOfDialects() && string.compareTo(SMBDialect.DialectString(n3)) != 0) {
            ++n3;
        }
        if ((n3 = SMBDialect.DialectType(n3)) == -1) {
            throw new IOException("Unknown SMB dialect");
        }
        SMBSession sMBSession = null;
        switch (n) {
            case 0: {
                sMBSession = SMBSessionFactory._$23618(pCShare, sMBPacket, netBIOSSession, n3);
                break;
            }
            case 1: {
                sMBSession = SMBSessionFactory._$23664(pCShare, sMBPacket, netBIOSSession, n3);
                break;
            }
            case 3: {
                sMBSession = SMBSessionFactory._$23641(pCShare, sMBPacket, netBIOSSession, n3);
            }
        }
        return sMBSession;
    }

    private static final void _$8108(String string, String string2) throws IOException, SMBException {
        SMBSession.setDebug(65535);
        StringBuffer stringBuffer = new StringBuffer(InetAddress.getLocalHost().getHostName().toUpperCase());
        if (SMBSession.isDebug()) {
            SMBSession.println(String.valueOf(String.valueOf(String.valueOf("** New session from ").concat(String.valueOf(stringBuffer))).concat(String.valueOf(" to "))).concat(String.valueOf(string)));
            SMBSession.println(String.valueOf(String.valueOf(String.valueOf("** os.arch = ").concat(String.valueOf(System.getProperty("os.arch")))).concat(String.valueOf(", java.version: "))).concat(String.valueOf(System.getProperty("java.version"))));
        }
        NetBIOSSession netBIOSSession = new NetBIOSSession(30000);
        netBIOSSession.Call(string, stringBuffer.toString());
        SMBPacket sMBPacket = new SMBPacket();
        sMBPacket.setCommand(208);
        sMBPacket.setFlags(0);
        sMBPacket.setParameterCount(0);
        sMBPacket.setSID(1);
        sMBPacket.setSeqNo(1);
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append('\u0004');
        stringBuffer2.append((Object)stringBuffer);
        stringBuffer2.append('\u0000');
        stringBuffer2.append('\u0004');
        stringBuffer2.append(string.toUpperCase());
        stringBuffer2.append('\u0000');
        stringBuffer2.append('\u0001');
        stringBuffer2.append((char)(string2.length() & 0xFF));
        stringBuffer2.append('\u0000');
        stringBuffer2.append(string2);
        sMBPacket.setBytes(stringBuffer2.toString().getBytes());
        sMBPacket.ExchangeSMB(netBIOSSession, sMBPacket, true);
        netBIOSSession.Hangup();
    }

    private static final void _$23418(DialectSelector dialectSelector) {
        _$23290.removeAllElements();
        for (int i = 0; i < 8; ++i) {
            if (!dialectSelector.hasDialect(i)) continue;
            for (int j = 0; j < SMBDialect.NumberOfDialects(); ++j) {
                if (SMBDialect.DialectType(j) == i) {
                    _$23290.addElement(SMBDialect.DialectString(j));
                }
                if (!SMBSession.isDebug()) continue;
                SMBSession.println(String.valueOf("** Negotiate SMB dialect: ").concat(String.valueOf(SMBDialect.DialectString(j))));
            }
        }
    }

    public static final void setSessionDebug(boolean bl) {
        if (bl) {
            SMBSession.setDebug(1);
        } else {
            SMBSession.setDebug(0);
        }
    }

    public static final void setSubnetMask(String string) {
        NetBIOSSession.setSubnetMask(string);
    }

    static {
        _$12385 = 0;
        _$23302 = null;
        _$23315 = null;
        _$23334 = 4100;
        _$23346 = null;
        _$23277 = new DialectSelector();
        _$23290 = new Vector();
        _$23277.AddDialect(0);
        _$23277.AddDialect(1);
        try {
            Class.forName("com.starla.smb.SMBCIFSDiskSession");
            Class.forName("com.starla.smb.SMBCIFSPrintSession");
            _$23277.AddDialect(2);
            _$23277.AddDialect(4);
            _$23277.AddDialect(3);
            _$23277.AddDialect(5);
            _$23277.AddDialect(6);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        SMBSessionFactory._$23418(_$23277);
    }
}

