/*
 * Decompiled with CFR 0.152.
 */
package com.starla.smb;

import com.starla.smb.NetBIOSSession;
import com.starla.util.DataPacker;

class NetBIOSPacket {
    public static final int NAME_QUERY = 0;
    public static final int NAME_REGISTER = 5;
    public static final int NAME_RELEASE = 6;
    public static final int WACK = 7;
    public static final int REFRESH = 8;
    public static final int RESP_QUERY = 16;
    public static final int RESP_REGISTER = 21;
    public static final int RESP_RELEASE = 22;
    public static final int MASK_OPCODE = 63488;
    public static final int MASK_NMFLAGS = 2032;
    public static final int MASK_RCODE = 15;
    public static final int MASK_NOOPCODE = 2047;
    public static final int MASK_NOFLAGS = 63503;
    public static final int MASK_NORCODE = 65520;
    public static final int MASK_RESPONSE = 16;
    public static final int FLG_BROADCAST = 1;
    public static final int FLG_RECURSION = 8;
    public static final int FLG_RECURSDES = 16;
    public static final int FLG_TRUNCATION = 32;
    public static final int FLG_AUTHANSWER = 64;
    public static final int NAME_TYPE_NB = 32;
    public static final int NAME_TYPE_NBSTAT = 33;
    public static final int NAME_LEN = 32;
    public static final int NAME_CLASS_IN = 1;
    private static final int _$11725 = 4;
    private static final int _$11736 = 11;
    public static final int DEFAULT_BUFSIZE = 1024;
    private static final int _$11763 = 0;
    private static final int _$11773 = 2;
    private static final int _$11782 = 4;
    private static final int _$11792 = 6;
    private static final int _$11802 = 8;
    private static final int _$11812 = 10;
    private static final int _$11822 = 12;
    private byte[] _$11829;
    private int _$11836;

    public NetBIOSPacket() {
        this._$11829 = new byte[1024];
        this._$11836 = 12;
    }

    public NetBIOSPacket(byte[] byArray) {
        this._$11829 = byArray;
        this._$11836 = 12;
    }

    public NetBIOSPacket(int n) {
        this._$11829 = new byte[n];
        this._$11836 = 12;
    }

    public void DumpPacket() {
        System.out.println("NetBIOS Packet Dump :-");
        System.out.println(String.valueOf(" Transaction Id : ").concat(String.valueOf(this.getTransactionId())));
        System.out.print(" Opcode : ");
        switch (this.getOpcode()) {
            case 0: {
                System.out.println("QUERY");
                break;
            }
            case 16: {
                System.out.println("QUERY (Response)");
                break;
            }
            default: {
                System.out.println(Integer.toHexString(this.getOpcode()));
            }
        }
        System.out.println(String.valueOf(" Flags  : ").concat(String.valueOf(Integer.toHexString(this.getFlags()))));
        System.out.println(String.valueOf(" QDCount : ").concat(String.valueOf(this.getQuestionCount())));
        System.out.println(String.valueOf(" ANCount : ").concat(String.valueOf(this.getAnswerCount())));
        System.out.println(String.valueOf(" NSCount : ").concat(String.valueOf(this.getNameServiceCount())));
        System.out.println(String.valueOf(" ARCount : ").concat(String.valueOf(this.getAdditionalCount())));
        if (this.getQuestionCount() > 0) {
            System.out.print(" QName  : ");
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 1; i <= 32; ++i) {
                stringBuffer.append((char)this._$11829[12 + i]);
            }
            System.out.println(NetBIOSSession.DecodeName(stringBuffer.toString()));
        }
    }

    public int getAdditionalCount() {
        return DataPacker.getShort(this._$11829, 10);
    }

    public int getAnswerCount() {
        return DataPacker.getShort(this._$11829, 6);
    }

    public byte[] getBuffer() {
        return this._$11829;
    }

    public int getFlags() {
        int n = DataPacker.getShort(this._$11829, 4) & 0x7F0;
        return n >>= 4;
    }

    public int getLength() {
        return this._$11836;
    }

    public int getNameServiceCount() {
        return DataPacker.getShort(this._$11829, 8);
    }

    public int getOpcode() {
        int n = DataPacker.getShort(this._$11829, 2) & 0xF800;
        return n >>= 11;
    }

    public int getQuestionCount() {
        return DataPacker.getShort(this._$11829, 4);
    }

    public int getResultCode() {
        int n = DataPacker.getShort(this._$11829, 2) & 0xF;
        return n;
    }

    public int getTransactionId() {
        return DataPacker.getShort(this._$11829, 0);
    }

    public boolean isResponse() {
        return (this.getOpcode() & 0x10) != 0;
    }

    public void setAdditionalCount(int n) {
        DataPacker.putShort((short)n, this._$11829, 10);
    }

    public void setAnswerCount(int n) {
        DataPacker.putShort((short)n, this._$11829, 6);
    }

    public void setFlags(int n) {
        int n2 = DataPacker.getShort(this._$11829, 2) & 0xF80F;
        DataPacker.putShort((short)(n2 += n << 4), this._$11829, 2);
    }

    public void setLength(int n) {
        this._$11836 = n;
    }

    public void setNameServiceCount(int n) {
        DataPacker.putShort((short)n, this._$11829, 8);
    }

    public void setOpcode(int n) {
        int n2 = DataPacker.getShort(this._$11829, 2) & 0x7FF;
        DataPacker.putShort((short)(n2 += n << 11), this._$11829, 2);
    }

    public void setQuestionCount(int n) {
        DataPacker.putShort((short)n, this._$11829, 4);
    }

    public void setQuestionName(String string, char c, int n, int n2) {
        String string2 = NetBIOSSession.ConvertName(string, c);
        byte[] byArray = string2.getBytes();
        int n3 = 12;
        this._$11829[n3++] = 32;
        for (int i = 0; i < 32; ++i) {
            this._$11829[n3++] = byArray[i];
        }
        this._$11829[n3++] = 0;
        DataPacker.putShort((short)n, this._$11829, n3);
        DataPacker.putShort((short)n2, this._$11829, n3 += 2);
        if ((n3 += 2) > this._$11836) {
            this.setLength(n3);
        }
    }

    public void setTransactionId(int n) {
        DataPacker.putShort((short)n, this._$11829, 0);
    }

    public String toString() {
        return super.toString();
    }
}

