/*
 * Decompiled with CFR 0.152.
 */
package com.starla.lite;

import com.starla.lite.PCShare;
import com.starla.lite.SMBDiskInfo;
import com.starla.lite.SMBFile;
import com.starla.lite.SMBFileInfo;
import com.starla.lite.SMBInputStream;
import com.starla.lite.SMBOutputStream;
import com.starla.lite.SMBSearchContext;
import com.starla.lite.SMBSession;
import java.io.FileNotFoundException;
import java.io.IOException;

public abstract class SMBDiskSession
extends SMBSession {
    public static final int Attributes = 1;
    public static final int WriteTime = 2;
    public static final int WriteDate = 4;

    protected SMBDiskSession(PCShare pCShare, int n) {
        super(pCShare, n);
        this.setDeviceType(0);
    }

    public abstract void CloseSession() throws IOException;

    public abstract boolean CreateDirectory(String var1) throws IOException;

    public abstract boolean DeleteDirectory(String var1) throws IOException;

    public void DeleteFile(String string) throws IOException {
        this.DeleteFile(string, 0);
    }

    public abstract void DeleteFile(String var1, int var2) throws IOException;

    public boolean FileExists(String string) {
        boolean bl = false;
        try {
            if (string.startsWith("\\")) {
                if (this.getFileInformation(string) != null) {
                    bl = true;
                }
            } else if (this.getFileInformation(PCShare.makePath(this.getWorkingDirectory(), string)) != null) {
                bl = true;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    protected void finalize() {
        if (!this.isClosed()) {
            try {
                this.CloseSession();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public abstract SMBDiskInfo getDiskInformation() throws IOException;

    public abstract SMBFileInfo getFileInformation(String var1) throws IOException;

    public final String getWorkingDirectory() {
        return this.getPCShare().getPath();
    }

    public final boolean isClosed() {
        return this.m_treeid == -1;
    }

    public abstract boolean isDirectory(String var1) throws IOException;

    public abstract SMBFile OpenFile(String var1, int var2) throws IOException;

    public SMBInputStream OpenInputStream(String string, int n) throws IOException {
        SMBFile sMBFile = this.OpenFile(string, n);
        if (sMBFile == null) {
            return null;
        }
        return new SMBInputStream(sMBFile);
    }

    public SMBOutputStream OpenOutputStream(String string, int n) throws IOException {
        SMBFile sMBFile = this.OpenFile(string, n);
        if (sMBFile == null) {
            return null;
        }
        return new SMBOutputStream(sMBFile);
    }

    public boolean RenameFile(String string, String string2) throws IOException {
        return this.RenameFile(string, string2, 0);
    }

    public abstract boolean RenameFile(String var1, String var2, int var3) throws IOException;

    public abstract void setFileInformation(String var1, SMBFileInfo var2, int var3) throws IOException;

    public final void setWorkingDirectory(String string) {
        this.getPCShare().setPath(string);
    }

    public abstract SMBSearchContext StartSearch(String var1, int var2) throws IOException;
}

