/*
 * Decompiled with CFR 0.152.
 */
package com.starla.lite;

import com.starla.lite.DialectSelector;
import com.starla.lite.NetBIOSSession;
import com.starla.lite.PCShare;
import com.starla.lite.SMBCoreDiskSession;
import com.starla.lite.SMBCorePrintSession;
import com.starla.lite.SMBDialect;
import com.starla.lite.SMBDiskSession;
import com.starla.lite.SMBException;
import com.starla.lite.SMBPacket;
import com.starla.lite.SMBPrintSession;
import com.starla.lite.SMBSession;
import com.starla.lite.UnsupportedDeviceTypeException;
import com.starla.util.DataPacker;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Vector;

public final class SMBSessionFactory {
    private static DialectSelector _$13961;
    private static Vector _$13974;
    private static int _$8256;
    private static int _$13986;

    private static final void _$14027(SMBPacket sMBPacket) {
        sMBPacket.setCommand(114);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < _$13974.size(); ++i) {
            stringBuffer.append('\u0002');
            stringBuffer.append((String)_$13974.elementAt(i));
            stringBuffer.append('\u0000');
        }
        sMBPacket.setBytes(stringBuffer.toString().getBytes());
    }

    private static final int _$14047(PCShare pCShare, SMBSession sMBSession, int n) throws SMBException, UnsupportedDeviceTypeException, IOException {
        if (SMBSessionFactory.hasSessionDebug()) {
            SMBSession.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("** Connecting to ").concat(String.valueOf(pCShare.getNodeName()))).concat(String.valueOf(" "))).concat(String.valueOf(pCShare.getShareName()))).concat(String.valueOf(" ("))).concat(String.valueOf(pCShare.getUserName()))).concat(String.valueOf("/"))).concat(String.valueOf(pCShare.getPassword()))).concat(String.valueOf(")")));
        }
        SMBPacket sMBPacket = new SMBPacket();
        sMBPacket.setCommand(112);
        sMBPacket.setFlags(0);
        sMBPacket.setUserId(sMBSession.getUserId());
        sMBPacket.setParameterCount(0);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\u0004');
        stringBuffer.append("\\\\");
        stringBuffer.append(pCShare.getNodeName().toUpperCase());
        stringBuffer.append("\\");
        stringBuffer.append(pCShare.getShareName().toUpperCase());
        stringBuffer.append('\u0000');
        stringBuffer.append('\u0004');
        stringBuffer.append(pCShare.getPassword());
        stringBuffer.append('\u0000');
        stringBuffer.append('\u0004');
        switch (n) {
            case 0: {
                stringBuffer.append("A:");
                break;
            }
            case 1: {
                stringBuffer.append("LPT1:");
            }
        }
        stringBuffer.append('\u0000');
        sMBPacket.setBytes(stringBuffer.toString().getBytes());
        sMBPacket.ExchangeSMB(sMBSession, sMBPacket);
        if (sMBPacket.isValidResponse() && sMBPacket.getParameterCount() == 2) {
            return sMBPacket.getParameter(1);
        }
        throw new SMBException(sMBPacket);
    }

    private static final void _$14081(PCShare pCShare, SMBSession sMBSession) throws SMBException, IOException {
        SMBPacket sMBPacket = new SMBPacket();
        sMBPacket.setCommand(115);
        sMBPacket.setParameterCount(10);
        sMBPacket.setAndXCommand(255);
        sMBPacket.setParameter(1, 0);
        sMBPacket.setParameter(2, SMBSessionFactory._$14095());
        sMBPacket.setParameter(3, 2);
        sMBPacket.setParameter(4, 0);
        sMBPacket.setParameter(5, 0);
        sMBPacket.setParameter(6, 0);
        sMBPacket.setParameter(7, pCShare.getPassword().length());
        sMBPacket.setParameter(8, 0);
        sMBPacket.setParameter(9, 0);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(pCShare.getPassword());
        stringBuffer.append(pCShare.getUserName());
        stringBuffer.append('\u0000');
        stringBuffer.append("?");
        stringBuffer.append('\u0000');
        stringBuffer.append("Java VM");
        stringBuffer.append('\u0000');
        stringBuffer.append("JLANLite");
        stringBuffer.append('\u0000');
        sMBPacket.setBytes(stringBuffer.toString().getBytes());
        sMBPacket.ExchangeSMB(sMBSession, sMBPacket);
        if (!sMBPacket.isValidResponse()) {
            throw new SMBException(sMBPacket);
        }
        sMBSession.setUserId(sMBPacket.getUserId());
        if (sMBPacket.getByteCount() > 0) {
            String string;
            int n = sMBPacket.getByteCount();
            int n2 = sMBPacket.getByteOffset();
            byte[] byArray = sMBPacket.getBuffer();
            String string2 = DataPacker.getString(byArray, n2, n);
            if (string2 != null) {
                n2 += string2.length() + 1;
                n -= string2.length() + 1;
            }
            if ((string = DataPacker.getString(byArray, n2, n)) != null) {
                n2 += string.length() + 1;
                n -= string.length() + 1;
            }
            String string3 = DataPacker.getString(byArray, n2, n);
            sMBSession.setOperatingSystem(string2);
            sMBSession.setLANManagerType(string);
            sMBSession.setDomain(string3);
        }
        sMBSession.setMaximumPacketSize(sMBPacket.getParameter(2));
    }

    private static final SMBDiskSession _$14129(PCShare pCShare, SMBPacket sMBPacket, NetBIOSSession netBIOSSession, int n) throws SMBException, IOException {
        SMBCoreDiskSession sMBCoreDiskSession = new SMBCoreDiskSession(pCShare, n);
        sMBCoreDiskSession.setSession(netBIOSSession);
        SMBSessionFactory._$14081(pCShare, sMBCoreDiskSession);
        try {
            int n2 = SMBSessionFactory._$14047(pCShare, sMBCoreDiskSession, 0);
            if (n2 != -1) {
                sMBCoreDiskSession.setTreeId(n2);
                SMBCoreDiskSession sMBCoreDiskSession2 = sMBCoreDiskSession;
                return sMBCoreDiskSession2;
            }
        }
        catch (UnsupportedDeviceTypeException unsupportedDeviceTypeException) {
            // empty catch block
        }
        return null;
    }

    private static final SMBPrintSession _$14152(PCShare pCShare, SMBPacket sMBPacket, NetBIOSSession netBIOSSession, int n) throws SMBException, IOException {
        SMBCorePrintSession sMBCorePrintSession = new SMBCorePrintSession(pCShare, n);
        sMBCorePrintSession.setSession(netBIOSSession);
        SMBSessionFactory._$14081(pCShare, sMBCorePrintSession);
        try {
            int n2 = SMBSessionFactory._$14047(pCShare, sMBCorePrintSession, 1);
            if (n2 != -1) {
                sMBCorePrintSession.setTreeId(n2);
                SMBCorePrintSession sMBCorePrintSession2 = sMBCorePrintSession;
                return sMBCorePrintSession2;
            }
        }
        catch (UnsupportedDeviceTypeException unsupportedDeviceTypeException) {
            // empty catch block
        }
        return null;
    }

    private static final SMBSession _$14178(PCShare pCShare, SMBPacket sMBPacket, NetBIOSSession netBIOSSession, int n) throws SMBException, IOException {
        SMBSession sMBSession = new SMBSession(pCShare, n);
        sMBSession.setSession(netBIOSSession);
        SMBSessionFactory._$14081(pCShare, sMBSession);
        return sMBSession;
    }

    private static final int _$14095() {
        return _$13986;
    }

    public static final boolean hasSessionDebug() {
        return SMBSession.isDebug();
    }

    public static final String isVersion() {
        return "0.1 Lite";
    }

    public static final SMBDiskSession OpenDisk(PCShare pCShare) throws SMBException, IOException {
        return (SMBDiskSession)SMBSessionFactory._$14200(pCShare, 0, 30000);
    }

    public static final SMBPrintSession OpenPrinter(PCShare pCShare) throws SMBException, IOException {
        return (SMBPrintSession)SMBSessionFactory._$14200(pCShare, 1, 30000);
    }

    private static SMBSession _$14200(PCShare pCShare, int n, int n2) throws SMBException, IOException {
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(String.valueOf(InetAddress.getLocalHost().getHostName()).concat(String.valueOf("_"))).concat(String.valueOf(_$8256++)));
        if (SMBSession.isDebug()) {
            SMBSession.println(String.valueOf(String.valueOf(String.valueOf("** New session from ").concat(String.valueOf(stringBuffer))).concat(String.valueOf(" to "))).concat(String.valueOf(pCShare.toString())));
            SMBSession.println(String.valueOf(String.valueOf(String.valueOf("** os.arch = ").concat(String.valueOf(System.getProperty("os.arch")))).concat(String.valueOf(", java.version: "))).concat(String.valueOf(System.getProperty("java.version"))));
        }
        NetBIOSSession netBIOSSession = new NetBIOSSession(n2);
        netBIOSSession.Call(pCShare.getNodeName(), stringBuffer.toString());
        SMBPacket sMBPacket = new SMBPacket();
        SMBSessionFactory._$14027(sMBPacket);
        sMBPacket.ExchangeSMB(netBIOSSession, sMBPacket, true);
        String string = (String)_$13974.elementAt(sMBPacket.getParameter(0));
        int n3 = 0;
        if (SMBSession.isDebug()) {
            SMBSession.println(String.valueOf("** SessionFactory: Negotiated SMB dialect ").concat(String.valueOf(string)));
        }
        while (n3 < SMBDialect.NumberOfDialects() && string.compareTo(SMBDialect.DialectString(n3)) != 0) {
            ++n3;
        }
        if ((n3 = SMBDialect.DialectType(n3)) == -1) {
            throw new IOException("Unknown SMB dialect");
        }
        SMBSession sMBSession = null;
        switch (n) {
            case 0: {
                sMBSession = SMBSessionFactory._$14129(pCShare, sMBPacket, netBIOSSession, n3);
                break;
            }
            case 1: {
                sMBSession = SMBSessionFactory._$14152(pCShare, sMBPacket, netBIOSSession, n3);
            }
        }
        return sMBSession;
    }

    private static final void _$13998(DialectSelector dialectSelector) {
        _$13974.removeAllElements();
        for (int i = 0; i < 1; ++i) {
            if (!dialectSelector.hasDialect(i)) continue;
            for (int j = 0; j < SMBDialect.NumberOfDialects(); ++j) {
                if (SMBDialect.DialectType(j) == i) {
                    _$13974.addElement(SMBDialect.DialectString(j));
                }
                if (!SMBSession.isDebug()) continue;
                SMBSession.println(String.valueOf("** Negotiate SMB dialect: ").concat(String.valueOf(SMBDialect.DialectString(j))));
            }
        }
    }

    public static final void setSessionDebug(boolean bl) {
        if (bl) {
            SMBSession.setDebug(1);
        } else {
            SMBSession.setDebug(0);
        }
    }

    static {
        _$8256 = 0;
        _$13986 = 4100;
        _$13961 = new DialectSelector();
        _$13974 = new Vector();
        _$13961.AddDialect(0);
        _$13961.AddDialect(1);
        SMBSessionFactory._$13998(_$13961);
    }
}

