/*
 * Decompiled with CFR 0.152.
 */
package com.starla.lite;

import com.starla.lite.NetBIOSSession;
import com.starla.lite.SMBErrorText;
import com.starla.lite.SMBSession;
import com.starla.util.DataPacker;
import java.io.IOException;

class SMBPacket {
    public static final int SIGNATURE = 4;
    public static final int COMMAND = 8;
    public static final int ERRORCODE = 9;
    public static final int ERRORCLASS = 9;
    public static final int ERROR = 11;
    public static final int FLAGS = 13;
    public static final int FLAGS2 = 14;
    public static final int PIDHIGH = 16;
    public static final int TID = 28;
    public static final int PID = 30;
    public static final int UID = 32;
    public static final int MID = 34;
    public static final int WORDCNT = 36;
    public static final int ANDXCOMMAND = 37;
    public static final int ANDXRESERVED = 38;
    public static final int PARAMWORDS = 37;
    public static final int MIN_RXLEN = 32;
    public static final int DEFAULT_BUFSIZE = 4096;
    public static final int FLG_RESPONSE = 128;
    private byte[] _$12161;
    private int _$12167;

    public SMBPacket() {
        this._$12161 = new byte[4096];
        this._$12176();
    }

    public SMBPacket(byte[] byArray) {
        this._$12161 = byArray;
    }

    public SMBPacket(int n) {
        this._$12161 = new byte[n];
        this._$12176();
    }

    public final void clearBytes() {
        int n = this.getByteOffset() - 2;
        DataPacker.putIntelShort((short)0, this._$12161, n);
    }

    public final void DumpPacket() {
        SMBSession.print("** SMB Packet Type: ");
        switch (this.getCommand()) {
            case 114: {
                SMBSession.print("NEGOTIATE");
                break;
            }
            case 115: {
                SMBSession.print("SESSION_SETUP");
                break;
            }
            case 112: {
                SMBSession.print("TREE_CONNECT");
                break;
            }
            case 117: {
                SMBSession.print("TREE_CONNECT_ANDX");
                break;
            }
            case 113: {
                SMBSession.print("TREE_DISCONNECT");
                break;
            }
            case 129: {
                SMBSession.print("SEARCH");
                break;
            }
            case 2: {
                SMBSession.print("OPEN_FILE");
                break;
            }
            case 45: {
                SMBSession.print("OPEN_ANDX");
                break;
            }
            case 10: {
                SMBSession.print("READ_FILE");
                break;
            }
            case 11: {
                SMBSession.print("WRITE_FILE");
                break;
            }
            case 4: {
                SMBSession.print("CLOSE_FILE");
                break;
            }
            case 3: {
                SMBSession.print("CREATE_FILE");
                break;
            }
            case 8: {
                SMBSession.print("GET_FILE_INFO");
                break;
            }
            case 128: {
                SMBSession.print("GET_DISK_INFO");
                break;
            }
            case 16: {
                SMBSession.print("CHECK_DIRECTORY");
                break;
            }
            case 7: {
                SMBSession.print("RENAME_FILE");
                break;
            }
            case 1: {
                SMBSession.print("DELETE_DIRECTORY");
                break;
            }
            default: {
                SMBSession.print(String.valueOf("0x").concat(String.valueOf(Integer.toHexString(this.getCommand()))));
            }
        }
    }

    public final synchronized void ExchangeSMB(NetBIOSSession netBIOSSession, SMBPacket sMBPacket, boolean bl) throws IOException {
        if (SMBSession.isDebug()) {
            this.DumpPacket();
        }
        netBIOSSession.Send(this._$12161, this.getLength());
        if (netBIOSSession.Receive(sMBPacket.getBuffer()) >= 32) {
            if (SMBSession.isDebug()) {
                sMBPacket.DumpPacket();
            }
            if (bl && !sMBPacket.isValidResponse()) {
                throw new IOException(SMBErrorText.ErrorString(sMBPacket.getErrorClass(), sMBPacket.getErrorCode()));
            }
            return;
        }
        throw new IOException("Invalid SMB Receive Packet");
    }

    public final synchronized void ExchangeSMB(SMBSession sMBSession, SMBPacket sMBPacket) throws IOException {
        this.ExchangeSMB(sMBSession, sMBPacket, false);
    }

    public final synchronized void ExchangeSMB(SMBSession sMBSession, SMBPacket sMBPacket, boolean bl) throws IOException {
        if (!sMBSession.isActive()) {
            throw new IOException("Session is closed");
        }
        if (SMBSession.isDebug()) {
            this.DumpPacket();
        }
        sMBSession.getSession().Send(this._$12161, this.getLength());
        if (sMBSession.getSession().Receive(sMBPacket.getBuffer()) >= 32) {
            if (SMBSession.isDebug()) {
                sMBPacket.DumpPacket();
            }
            if (bl && !sMBPacket.isValidResponse()) {
                throw new IOException(SMBErrorText.ErrorString(sMBPacket.getErrorClass(), sMBPacket.getErrorCode()));
            }
            return;
        }
        throw new IOException("Invalid SMB Receive Packet");
    }

    public final int getAndXCommand() {
        return this._$12161[37] & 0xFF;
    }

    public final byte[] getBuffer() {
        return this._$12161;
    }

    public final int getBufferLength() {
        return this._$12161.length - 4;
    }

    public final int getByteCount() {
        int n = 37 + 2 * this.getParameterCount();
        return DataPacker.getIntelShort(this._$12161, n);
    }

    public final int getByteOffset() {
        int n = this.getParameterCount();
        int n2 = 36 + 2 * n + 3;
        return n2;
    }

    public final int getCommand() {
        return this._$12161[8] & 0xFF;
    }

    public final int getErrorClass() {
        return this._$12161[9] & 0xFF;
    }

    public final int getErrorCode() {
        return this._$12161[11] & 0xFF;
    }

    public final int getFlags() {
        return this._$12161[13] & 0xFF;
    }

    public final int getFlags2() {
        return DataPacker.getIntelShort(this._$12161, 14);
    }

    public final int getLength() {
        return this.getByteOffset() + this.getByteCount() - 4;
    }

    public final int getLongErrorCode() {
        return DataPacker.getIntelInt(this._$12161, 9);
    }

    public final short getMultiplexId() {
        return DataPacker.getIntelShort(this._$12161, 34);
    }

    public final int getParameter(int n) throws IndexOutOfBoundsException {
        if (n > this.getParameterCount()) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = 36 + 2 * n + 1;
        return DataPacker.getIntelShort(this._$12161, n2) & 0xFFFF;
    }

    public final int getParameterCount() {
        return this._$12161[36];
    }

    public final short getProcessId() {
        return DataPacker.getIntelShort(this._$12161, 30);
    }

    public final short getTreeId() {
        return DataPacker.getIntelShort(this._$12161, 28);
    }

    public final short getUserId() {
        return DataPacker.getIntelShort(this._$12161, 32);
    }

    private final void _$12176() {
        this._$12161[4] = -1;
        this._$12161[5] = 83;
        this._$12161[6] = 77;
        this._$12161[7] = 66;
    }

    public final boolean isResponse() {
        int n = this.getFlags();
        return (n & 0x80) != 0;
    }

    public final boolean isValidResponse() {
        return this.isResponse() && this.getCommand() == this._$12167 && this.getErrorClass() == 0;
    }

    private final void _$5339(NetBIOSSession netBIOSSession) throws IOException {
        if (netBIOSSession.Receive(this._$12161) >= 32) {
            return;
        }
        throw new IOException("Short NetBIOS receive");
    }

    protected final void ReceiveSMB(SMBSession sMBSession) throws IOException {
        if (sMBSession.getSession().Receive(this._$12161) >= 32) {
            if (SMBSession.isDebug()) {
                this.DumpPacket();
            }
            return;
        }
        throw new IOException("Short NetBIOS receive");
    }

    private final void _$5332(NetBIOSSession netBIOSSession) throws IOException {
        netBIOSSession.Send(this._$12161, this.getLength());
    }

    protected final void SendSMB(SMBSession sMBSession) throws IOException {
        if (SMBSession.isDebug()) {
            this.DumpPacket();
        }
        sMBSession.getSession().Send(this._$12161, this.getLength());
    }

    public final void setAndXCommand(int n) {
        this._$12161[37] = (byte)n;
        this._$12161[38] = 0;
    }

    public final void setByteCount(int n) {
        int n2 = this.getByteOffset() - 2;
        DataPacker.putIntelShort((short)n, this._$12161, n2);
    }

    public final void setBytes(byte[] byArray) {
        int n = this.getByteOffset() - 2;
        DataPacker.putIntelShort((short)byArray.length, this._$12161, n);
        n += 2;
        int n2 = 0;
        while (n2 < byArray.length) {
            this._$12161[n + n2] = byArray[n2++];
        }
    }

    public final void setCommand(int n) {
        this._$12167 = n;
        this._$12161[8] = (byte)n;
    }

    public final void setErrorClass(int n) {
        this._$12161[9] = (byte)(n & 0xFF);
    }

    public final void setErrorCode(int n) {
        this._$12161[11] = (byte)(n & 0xFF);
    }

    public final void setFlags(int n) {
        this._$12161[13] = (byte)n;
    }

    public final void setFlags2(int n) {
        DataPacker.putIntelShort((short)n, this._$12161, 14);
    }

    public final void setMultiplexId(int n) {
        DataPacker.putIntelShort((short)n, this._$12161, 34);
    }

    public final void setParameter(int n, int n2) {
        int n3 = 36 + 2 * n + 1;
        DataPacker.putIntelShort((short)n2, this._$12161, n3);
    }

    public final void setParameterCount(int n) {
        this._$12161[36] = (byte)n;
    }

    public final void setProcessId(int n) {
        DataPacker.putIntelShort((short)n, this._$12161, 30);
    }

    public final void setTreeId(int n) {
        DataPacker.putIntelShort((short)n, this._$12161, 28);
    }

    public final void setUserId(int n) {
        DataPacker.putIntelShort((short)n, this._$12161, 32);
    }
}

