unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Buttons, ComCtrls, Tabnotbk, StdCtrls, Menus, MLmain, DSmain,
  DlgCover;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    Language1: TMenuItem;
    English1: TMenuItem;
    German1: TMenuItem;
    Russian1: TMenuItem;
    Label1: TLabel;
    Label2: TLabel;
    GroupBox1: TGroupBox;
    Button1: TButton;
    CheckBox1: TCheckBox;
    ListBox1: TListBox;
    Panel1: TPanel;
    RadioButton1: TRadioButton;
    BitBtn1: TBitBtn;
    TabbedNotebook1: TTabbedNotebook;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    RadioGroup1: TRadioGroup;
    ML: TMultiLanguage;
    DesignerML1: TDesignerML;
    procedure English1Click(Sender: TObject);
    procedure German1Click(Sender: TObject);
    procedure Russian1Click(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure MLLangChangeAfter(Sender: TObject; var lng,
      NewLng: TLanguage);
    procedure Button1Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure DesignerML1CompDesignEventAfter(Sender: TObject; State1,
      State2: Integer; C: TControl; dsNew: TdsElement);
    procedure DesignerML1CompDesignEventBefore(Sender: TObject;
      State: Integer; var State2: Integer; C: TControl;
      var dsNew: TdsElement; var CanDesign: Boolean);
    procedure DesignerML1DesignEventAfter(Sender: TObject; State1,
      State2: Integer);
    procedure DesignerML1DesignEventBefore(Sender: TObject;
      State1: Integer; var State: Integer; var CanChange: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

procedure SaveOneWordToFile(const S : string);

var
  Form1: TForm1;

implementation

{$R *.DFM}


procedure TForm1.English1Click(Sender: TObject);
begin
  ML.LanguageFormNumber := 0;
end;

procedure TForm1.German1Click(Sender: TObject);
begin
  ML.LanguageFormNumber := 1;
end;

procedure TForm1.Russian1Click(Sender: TObject);
begin
  ML.LanguageFormNumber := 2;
end;

procedure TForm1.RadioGroup1Click(Sender: TObject);
begin
  case RadioGroup1.ItemIndex of
  0: ML.LanguageFormNumber := 0;
  1: ML.LanguageFormNumber := 1;
  2: ML.LanguageFormNumber := 2;
  end;
end;

procedure TForm1.MLLangChangeAfter(Sender: TObject; var lng,
  NewLng: TLanguage);
begin
  Label1.Caption := NewLng.Title;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  i : integer;
  FileName : string;
begin
  ML.FileName := 'test.lgf';
  for i:=0 to 1000 do
    begin
      Caption := IntToStr(i);
      ML.ReadDictionary;
      ML.DeleteDictionary(FileName);
    end;
end;

procedure SaveOneWordToFile(const S : string);
var
  fs : Text;
  FileName : string;
begin
  FileName := 'c:\work\ml97\demo\2.txt';
  Assign(fs, FileName);
  try
    if FileExists(FileName) then
      Append(fs)
    else
      Rewrite(fs);
    Writeln(fs, s);
  finally
    Close(fs);
  end;
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
var
  Stream : TMemoryStream;
  S : String;
begin
  frmDesignerCover := TfrmDesignerCover.Create(nil);
  frmDesignerCover.FormOwner := self;
  Stream := TMemoryStream.Create;
  try
    Stream.WriteComponentRes(S, DesignerML1);
    Stream.Position := 0;
    Stream.ReadComponentRes(frmDesignerCover.DS);
    frmDesignerCover.DS.AddDefaultState(DesignerML1.Owner);
    frmDesignerCover.ShowModal;
  finally
    Stream.Destroy;
    frmDesignerCover.Free;
  end;
end;

procedure TForm1.DesignerML1CompDesignEventAfter(Sender: TObject; State1,
  State2: Integer; C: TControl; dsNew: TdsElement);
begin
  ShowMessage('CompDesignEventAfter : '+ C.Name + '. State: '+ IntToStr(State1)+' to '+
    IntToStr(State2));
end;

procedure TForm1.DesignerML1CompDesignEventBefore(Sender: TObject;
  State: Integer; var State2: Integer; C: TControl; var dsNew: TdsElement;
  var CanDesign: Boolean);
begin
  ShowMessage('CompDesignEventBefore : '+ C.Name + '. State: '+ IntToStr(State)+' to '+
    IntToStr(State2));
end;

procedure TForm1.DesignerML1DesignEventAfter(Sender: TObject; State1,
  State2: Integer);
begin
  ;
end;

procedure TForm1.DesignerML1DesignEventBefore(Sender: TObject;
  State1: Integer; var State: Integer; var CanChange: Boolean);
begin
  ;
end;

initialization
  RegisterLangType(TTabbedNotebook,  ['Pages']);
end.
