unit Aaplayr1;

{ Delphi 3 Demo program for flic panel component }
{ 9th Dec 1998 }

{ ------------------------------------------------------------------------- }
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls, Spin, Menus, Gauges,
  AAPlayr2, MMSystem, FlicPanel;

const
   SYSTEM_PATH_LENGTH = 144;
   USER_PATH_LENGTH = 255;
 AA_STOPPED = 1;             { Loaded but not playing }
 AA_QUEUED = 2;              { Animation is waiting to play }
 AA_PLAYING = 3;             { Animation is playing }
 AA_PAUSED = 4;              { Animation is paused }
 AA_DONE = 5;                { Animation has ended playing, }
						      { and is awaiting an aaStop call }

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Open1: TMenuItem;
    Exit1: TMenuItem;
    OpenDialog1: TOpenDialog;
    Gauge1: TGauge;
    Bevel3: TBevel;
    OpenDialog2: TOpenDialog;
    LoopPlay: TMenuItem;
    N3: TMenuItem;
    Exitprogram1: TMenuItem;
    AnimGroupBox: TGroupBox;
    Label3: TLabel;
    WidthValue: TEdit;
    HeightValue: TEdit;
    FramesLabel: TLabel;
    FramesValue: TEdit;
    SpeedValue: TEdit;
    Anim2GroupBox: TGroupBox;
    Label5: TLabel;
    SpeedEdit: TSpinEdit;
    XEdit: TEdit;
    YEdit: TEdit;
    Label6: TLabel;
    FramePanel: TPanel;
    LoopPanel: TPanel;
    Label4: TLabel;
    NotifyGroupBox: TGroupBox;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    CheckBox7: TCheckBox;
    CheckBox8: TCheckBox;
    CheckBox9: TCheckBox;
    CheckBox10: TCheckBox;
    OpenDialog3: TOpenDialog;
    NotifyCancelButton: TButton;
    Sound1: TMenuItem;
    Associate1: TMenuItem;
    ButtonPanel: TPanel;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    Loopsound1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure SpeedEditChange(Sender: TObject);
    procedure OpenFlicFile(AFilename: string);
    procedure Open1Click(Sender: TObject);
    procedure XEditChange(Sender: TObject);
    procedure YEditChange(Sender: TObject);
    procedure Associate1Click(Sender: TObject);
    procedure NotifyCheckBoxClick(Sender: TObject);
    procedure LoopPlayClick(Sender: TObject);
    procedure NotifyCancelButtonClick(Sender: TObject);
    procedure Exitprogram1Click(Sender: TObject);
    procedure Help2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Loopsound1Click(Sender: TObject);
  private
    { Private declarations }
//    SoundLoops: integer;
    SoundPtrs: array[1..10] of PChar;
    SoundFlags: array[1..10] of Boolean;
  public
    { Public declarations }
   protected
    { Protected declarations }
    procedure WndProc(var Message: TMessage); override;
  end;

var
  Form1: TForm1;
  { The following two are needed because trying to access the message
      numbers in the flic panel component in a form's WndProc
      causes a GPF when WndProc is called during form (and hence
      flic panel) creation: }
   NotifyMessageNum: word;
   StopMessageNum: word;
   FrameMessageNum: word;
   RedimMessageNum: word;

{ ------------------------------------------------------------------------- }
implementation

{$R *.DFM}

{ ------------------------------------------------------------------------- }
procedure TForm1.FormCreate(Sender: TObject);

var
   tempp: integer;

begin

   for tempp := 1 to 10 do
      begin
      GetMem(SoundPtrs[tempp], SYSTEM_PATH_LENGTH);
      end;

   for tempp := 1 to 10 do
      begin
      SoundFlags[tempp] := FALSE;
      end;

end;

{ ------------------------------------------------------------------------- }
procedure TForm1.FormDestroy(Sender: TObject);

var
   tempp: integer;

begin

   for tempp := 1 to 10 do
      begin
      FreeMem(SoundPtrs[tempp], SYSTEM_PATH_LENGTH);
      end;

end;

{ ------------------------------------------------------------------------- }
procedure TForm1.Open1Click(Sender: TObject);

begin

   if OpenDialog1.Execute then
      begin
      OpenFlicFile(OpenDialog1.Filename);
      Open1.enabled := FALSE;
      end;

end;

{ ------------------------------------------------------------------------- }
procedure TForm1.OpenFlicFile(AFilename: string);

var
   tempstr: string[12];

begin
   form2.Enabled := TRUE;
   form2.visible := TRUE;
   { If these are in Form1's constructor, causes GPF }
   NotifyMessageNum := form2.flicpanel1.NotifyMessageNum;
   StopMessageNum := form2.flicpanel1.StopMessageNum;
   FrameMessageNum := form2.flicpanel1.FrameMessageNum;
   RedimMessageNum := form2.flicpanel1.RedimMessageNum;

   with form2.flicpanel1 do
      begin
      FileName := AFileName;
      CallbackHandle := Form1.handle;
//      Stretchable := TRUE;
      Open;
      str(FlicWidth, tempstr);
      WidthValue.Text := tempstr;
      str(FlicHeight, tempstr);
      HeightValue.Text := tempstr;
      str(FlicFrames, tempstr);
      FramesValue.Text := tempstr;
      str(DesignSpeed, tempstr);
      SpeedValue.Text := tempstr;
      SpeedEdit.Value := Speed;
      SpeedEdit.Enabled := TRUE;
      XEdit.Enabled := TRUE;
      YEdit.Enabled := TRUE;
      Gauge1.progress := 1;
      FramePanel.Caption := '1';
      LoopPanel.Caption := '1';
      Gauge1.maxvalue := FlicFrames;
      Associate1.enabled := TRUE;
      LoopPlay.Enabled := TRUE;           { turn on play looping menu }
      Loopsound1.Enabled := TRUE;           { turn on sound looping menu }
      X := 0;
      Y := 0;
      PlayLoops := 0;                     { play animation once }
      PlayFrames := FlicFrames;
      end;

//   form2.flicpanel1.width := form2.flicpanel1.flicwidth * 2;
//   form2.flicpanel1.paint;
   form2.Width := form2.flicpanel1.Width + 16;
   form2.Height := form2.flicpanel1.Height + 33;
   form2.Caption := ExtractFilename(AFilename);
   CheckBox1.Enabled := TRUE;
   CheckBox2.Enabled := TRUE;
   CheckBox3.Enabled := TRUE;
   CheckBox4.Enabled := TRUE;
   CheckBox5.Enabled := TRUE;
   CheckBox6.Enabled := TRUE;
   CheckBox7.Enabled := TRUE;
   CheckBox8.Enabled := TRUE;
   CheckBox9.Enabled := TRUE;
   CheckBox10.Enabled := TRUE;
   Associate1.Enabled := TRUE;      { turn on sound association button }
end;

{ ------------------------------------------------------------------------- }
procedure TForm1.SpeedEditChange(Sender: TObject);

begin
   form2.flicpanel1.Speed := SpeedEdit.Value;
end;


{ ------------------------------------------------------------------------- }
procedure TForm1.Associate1Click(Sender: TObject);

begin

   if OpenDialog2.Execute then
      begin
      form2.flicpanel1.Sound := OpenDialog2.Filename;
      Caption := ExtractFilename(form2.flicpanel1.Filename) + ' + ' +
                                    ExtractFilename(OpenDialog2.Filename);
      end;

end;


{ ------------------------------------------------------------------------- }
procedure TForm1.XEditChange(Sender: TObject);

var
   temp, temp2: integer;

begin

   if Sender = XEdit then
      begin
      val(XEdit.Text, temp2, temp);

      if (temp = 0) and (temp2 > -1) then
         begin
         form2.flicpanel1.X := temp2;
         end;

      end;

end;

{ ------------------------------------------------------------------------- }
procedure TForm1.YEditChange(Sender: TObject);

var
   temp, temp2: integer;

begin

   if Sender = YEdit then
      begin
      val(YEdit.Text, temp2, temp);

      if (temp = 0) and (temp2 > -1) then
         begin
         form2.flicpanel1.Y := temp2;
         end;

      end;

end;


{ ------------------------------------------------------------------------- }
procedure TForm1.NotifyCheckBoxClick(Sender: TObject);

var
   temp, temp2: integer;

begin
   val(TCheckBox(Sender).Caption, temp2, temp);

   if ((SoundFlags[temp2] = FALSE) and (form2.flicpanel1.FlicLoaded = TRUE)) then
      begin

      if OpenDialog3.Execute then
         begin

         with form2.flicpanel1 do
            Notify(0, CurrentFrame, temp2);

         SoundPtrs[temp2] := StrPLCopy(SoundPtrs[temp2], OpenDialog3.Filename,
                                                      SYSTEM_PATH_LENGTH);
         TCheckBox(Sender).Enabled := FALSE;
         SoundFlags[temp2] := TRUE;
         end
      else
         begin
         TCheckBox(Sender).Checked := FALSE;   { user cancelled }
         end;

      end;

end;

{ ------------------------------------------------------------------------- }
procedure TForm1.LoopPlayClick(Sender: TObject);

begin

   if LoopPlay.Checked = TRUE then
      begin
      form2.flicpanel1.PlayFrames := form2.flicpanel1.FlicFrames;
      form2.flicpanel1.PlayLoops := 0;
      LoopPlay.Checked := FALSE;
      end
   else
      begin
      form2.flicpanel1.PlayLoops := 0;
      form2.flicpanel1.PlayFrames := 0;
      LoopPlay.Checked := TRUE;
      end;

end;

{ ------------------------------------------------------------------------- }
procedure TForm1.NotifyCancelButtonClick(Sender: TObject);

var
   tempp: integer;

begin

   if (form2.flicpanel1.FlicLoaded = TRUE) then
      begin
      form2.flicpanel1.CancelAll;
      CheckBox1.Enabled := FALSE;
      CheckBox2.Enabled := FALSE;
      CheckBox3.Enabled := FALSE;
      CheckBox4.Enabled := FALSE;
      CheckBox5.Enabled := FALSE;
      CheckBox6.Enabled := FALSE;
      CheckBox7.Enabled := FALSE;
      CheckBox8.Enabled := FALSE;
      CheckBox9.Enabled := FALSE;
      CheckBox10.Enabled := FALSE;
      CheckBox1.Checked := FALSE;
      CheckBox2.Checked := FALSE;
      CheckBox3.Checked := FALSE;
      CheckBox4.Checked := FALSE;
      CheckBox5.Checked := FALSE;
      CheckBox6.Checked := FALSE;
      CheckBox7.Checked := FALSE;
      CheckBox8.Checked := FALSE;
      CheckBox9.Checked := FALSE;
      CheckBox10.Checked := FALSE;
      CheckBox1.Enabled := TRUE;
      CheckBox2.Enabled := TRUE;
      CheckBox3.Enabled := TRUE;
      CheckBox4.Enabled := TRUE;
      CheckBox5.Enabled := TRUE;
      CheckBox6.Enabled := TRUE;
      CheckBox7.Enabled := TRUE;
      CheckBox8.Enabled := TRUE;
      CheckBox9.Enabled := TRUE;
      CheckBox10.Enabled := TRUE;
      end;

   for tempp := 1 to 10 do
      begin
      SoundFlags[tempp] := FALSE;
      end;

end;

{ ------------------------------------------------------------------------- }
procedure TForm1.Exitprogram1Click(Sender: TObject);

begin
   Application.Terminate;
end;

{ ------------------------------------------------------------------------- }
procedure TForm1.Help2Click(Sender: TObject);

begin
   WinHelp(Form1.handle, 'flicpanel.hlp', HELP_CONTENTS, 0);
end;

{ ------------------------------------------------------------------------- }
procedure TForm1.WndProc(var Message: TMessage);

begin

   with Message do
      begin

      if Msg = NotifyMessageNum then
         begin

         if (lParam > 0) and (lParam < 11) then
            begin
            sndPlaySound(SoundPtrs[lParam], SND_ASYNC + SND_NODEFAULT);
            end;

         end
      else
         begin

         if Msg = StopMessageNum then
            begin
            if SoundFlags[1] = FALSE then
               CheckBox1.Enabled := TRUE;
            if SoundFlags[2] = FALSE then
               CheckBox2.Enabled := TRUE;
            if SoundFlags[3] = FALSE then
               CheckBox3.Enabled := TRUE;
            if SoundFlags[4] = FALSE then
               CheckBox4.Enabled := TRUE;
            if SoundFlags[5] = FALSE then
               CheckBox5.Enabled := TRUE;
            if SoundFlags[6] = FALSE then
               CheckBox6.Enabled := TRUE;
            if SoundFlags[7] = FALSE then
               CheckBox7.Enabled := TRUE;
            if SoundFlags[8] = FALSE then
               CheckBox8.Enabled := TRUE;
            if SoundFlags[9] = FALSE then
               CheckBox9.Enabled := TRUE;
            if SoundFlags[10] = FALSE then
               CheckBox10.Enabled := TRUE;
           end
         else
            begin

            if Msg = FrameMessageNum then
               begin

               with form2.flicpanel1 do
                  begin
                  Gauge1.progress := lParam;
                  Form1.FramePanel.Caption := inttostr(lParam);
                  Form1.LoopPanel.Caption := inttostr(wParam);
                  end;

               end//if Msg = FrameMessageNum
            else
               begin

               if Msg = RedimMessageNum then
                  begin
                  messagedlg('Notification array has redimensioned.'+#13+'New size is '+
                              inttostr(lParam),mtInformation,[mbOK],0);
                  end;

               end;

            end;

         end;

      end;

   inherited WndProc(Message);
end;

{ ------------------------------------------------------------------------- }
procedure TForm1.Button1Click(Sender: TObject);

begin
   form2.flicpanel1.Play;
   CheckBox1.Enabled := FALSE;
   CheckBox2.Enabled := FALSE;
   CheckBox3.Enabled := FALSE;
   CheckBox4.Enabled := FALSE;
   CheckBox5.Enabled := FALSE;
   CheckBox6.Enabled := FALSE;
   CheckBox7.Enabled := FALSE;
   CheckBox8.Enabled := FALSE;
   CheckBox9.Enabled := FALSE;
   CheckBox10.Enabled := FALSE;
end;

{ ------------------------------------------------------------------------- }
procedure TForm1.Button2Click(Sender: TObject);

var
   tempstr: string;

begin

   if form2.flicpanel1.status = AA_PLAYING then
      begin
      form2.flicpanel1.Pause;

         if SoundFlags[1] = FALSE then
            CheckBox1.Enabled := TRUE;
         if SoundFlags[2] = FALSE then
            CheckBox2.Enabled := TRUE;
         if SoundFlags[3] = FALSE then
            CheckBox3.Enabled := TRUE;
         if SoundFlags[4] = FALSE then
            CheckBox4.Enabled := TRUE;
         if SoundFlags[5] = FALSE then
            CheckBox5.Enabled := TRUE;
         if SoundFlags[6] = FALSE then
            CheckBox6.Enabled := TRUE;
         if SoundFlags[7] = FALSE then
            CheckBox7.Enabled := TRUE;
         if SoundFlags[8] = FALSE then
            CheckBox8.Enabled := TRUE;
         if SoundFlags[9] = FALSE then
            CheckBox9.Enabled := TRUE;
         if SoundFlags[10] = FALSE then
            CheckBox10.Enabled := TRUE;
         Gauge1.progress := form2.flicpanel1.CurrentFrame;
         str(form2.flicpanel1.CurrentFrame, tempstr);
         FramePanel.Caption := tempstr;
         str(form2.flicpanel1.CurrentLoop, tempstr);
         LoopPanel.Caption := tempstr;
      end
   else

      if form2.flicpanel1.status = AA_PAUSED then
         begin
      form2.flicpanel1.Resume;

            CheckBox1.Enabled := FALSE;
            CheckBox2.Enabled := FALSE;
            CheckBox3.Enabled := FALSE;
            CheckBox4.Enabled := FALSE;
            CheckBox5.Enabled := FALSE;
            CheckBox6.Enabled := FALSE;
            CheckBox7.Enabled := FALSE;
            CheckBox8.Enabled := FALSE;
            CheckBox9.Enabled := FALSE;
            CheckBox10.Enabled := FALSE;
         end;

end;

{ ------------------------------------------------------------------------- }
procedure TForm1.Button3Click(Sender: TObject);

var
   tempstr: string;

begin
         form2.flicpanel1.Stop;

         if SoundFlags[1] = FALSE then
            CheckBox1.Enabled := TRUE;
         if SoundFlags[2] = FALSE then
            CheckBox2.Enabled := TRUE;
         if SoundFlags[3] = FALSE then
            CheckBox3.Enabled := TRUE;
         if SoundFlags[4] = FALSE then
            CheckBox4.Enabled := TRUE;
         if SoundFlags[5] = FALSE then
            CheckBox5.Enabled := TRUE;
         if SoundFlags[6] = FALSE then
            CheckBox6.Enabled := TRUE;
         if SoundFlags[7] = FALSE then
            CheckBox7.Enabled := TRUE;
         if SoundFlags[8] = FALSE then
            CheckBox8.Enabled := TRUE;
         if SoundFlags[9] = FALSE then
            CheckBox9.Enabled := TRUE;
         if SoundFlags[10] = FALSE then
            CheckBox10.Enabled := TRUE;
         Gauge1.progress := form2.flicpanel1.CurrentFrame;
         str(form2.flicpanel1.CurrentFrame, tempstr);
         FramePanel.Caption := tempstr;
         str(form2.flicpanel1.CurrentLoop, tempstr);
         LoopPanel.Caption := tempstr;
end;

{ ------------------------------------------------------------------------- }
procedure TForm1.Button4Click(Sender: TObject);

var
   tempstr:string;

begin
         form2.flicpanel1.Previous;
         str(form2.flicpanel1.CurrentFrame, tempstr);
         FramePanel.Caption := tempstr;
         str(form2.flicpanel1.CurrentLoop, tempstr);
         LoopPanel.Caption := tempstr;
         Gauge1.progress := form2.flicpanel1.CurrentFrame;
end;

{ ------------------------------------------------------------------------- }
procedure TForm1.Button5Click(Sender: TObject);

var
   tempstr: string;

begin
         form2.flicpanel1.Back;
         str(form2.flicpanel1.CurrentFrame, tempstr);
         FramePanel.Caption := tempstr;
         str(form2.flicpanel1.CurrentLoop, tempstr);
         LoopPanel.Caption := tempstr;
         Gauge1.progress := form2.flicpanel1.CurrentFrame;
end;

{ ------------------------------------------------------------------------- }
procedure TForm1.Button6Click(Sender: TObject);

var
   tempstr: string;
   
begin
         form2.flicpanel1.Step;
         str(form2.flicpanel1.CurrentFrame, tempstr);
         FramePanel.Caption := tempstr;
         str(form2.flicpanel1.CurrentLoop, tempstr);
         LoopPanel.Caption := tempstr;
         Gauge1.progress := form2.flicpanel1.CurrentFrame;
end;

{ ------------------------------------------------------------------------- }
procedure TForm1.Button7Click(Sender: TObject);

var
   tempstr: string;

begin
         form2.flicpanel1.Next;
         str(form2.flicpanel1.CurrentFrame, tempstr);
         FramePanel.Caption := tempstr;
         str(form2.flicpanel1.CurrentLoop, tempstr);
         LoopPanel.Caption := tempstr;
         Gauge1.progress := form2.flicpanel1.CurrentFrame;
end;

{ ------------------------------------------------------------------------- }
procedure TForm1.Button8Click(Sender: TObject);

var
   tempp: integer;

begin
         form2.flicpanel1.Eject;
         WidthValue.Text := '';
         HeightValue.Text := '';
         FramesValue.Text := '';
         SpeedValue.Text := '';
         SpeedEdit.Value := 0;
         XEdit.Text := '4';
         YEdit.Text := '4';
         SpeedEdit.Enabled := FALSE;
         XEdit.Enabled := FALSE;
         YEdit.Enabled := FALSE;
         Gauge1.Progress := 0;
         FramePanel.Caption := '';
         LoopPanel.Caption := '';
         form2.Enabled := FALSE;
         form2.Visible := FALSE;
         Associate1.Enabled := FALSE;     // disable associate sound menu
         LoopPlay.Checked := FALSE;       // turn off play looping menu
         LoopPlay.Enabled := FALSE;       // turn off play looping menu
         Loopsound1.Checked := FALSE;           { turn off sound looping menu }
         Loopsound1.Enabled := FALSE;           { turn off sound looping menu }
         CheckBox1.Checked := FALSE;
         CheckBox2.Checked := FALSE;
         CheckBox3.Checked := FALSE;
         CheckBox4.Checked := FALSE;
         CheckBox5.Checked := FALSE;
         CheckBox6.Checked := FALSE;
         CheckBox7.Checked := FALSE;
         CheckBox8.Checked := FALSE;
         CheckBox9.Checked := FALSE;
         CheckBox10.Checked := FALSE;
         CheckBox1.Enabled := FALSE;
         CheckBox2.Enabled := FALSE;
         CheckBox3.Enabled := FALSE;
         CheckBox4.Enabled := FALSE;
         CheckBox5.Enabled := FALSE;
         CheckBox6.Enabled := FALSE;
         CheckBox7.Enabled := FALSE;
         CheckBox8.Enabled := FALSE;
         CheckBox9.Enabled := FALSE;
         CheckBox10.Enabled := FALSE;
         Open1.enabled := TRUE;

         for tempp := 1 to 10 do
            begin
            SoundFlags[tempp] := FALSE;
            end;

end;


procedure TForm1.Loopsound1Click(Sender: TObject);
begin

   if Loopsound1.Checked = TRUE then
      begin
      form2.flicpanel1.SoundLooping := FALSE;
      Loopsound1.Checked := FALSE;
      end
   else
      begin
      form2.flicpanel1.SoundLooping := TRUE;
      Loopsound1.Checked := TRUE;
      end;


end;

end.
