unit demo1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ComCtrls, EnhSpeech;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    GBCommand: TGroupBox;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    YouSaid: TLabel;
    BTTrain: TBitBtn;
    BTAbout: TBitBtn;
    VUMeter: TProgressBar;
    voice: TEnhVoiceCommand;
    GBText: TGroupBox;
    text: TEnhVoiceText;
    EDText: TEdit;
    BTNSpeak: TBitBtn;
    BTNTranslate: TBitBtn;
    BTNAbout: TBitBtn;
    BTNGeneral: TBitBtn;
    BTNLexicon: TBitBtn;
    RBCommand: TRadioButton;
    RBText: TRadioButton;
    procedure BTTrainClick(Sender: TObject);
    procedure BTAboutClick(Sender: TObject);
    procedure voiceVUMeter(sender: TObject; level: Integer);
    procedure voiceCommandRecognize(sender: TObject; ID: Longint;
      ApplicationName, StateName: string; flags, ActionSize: Longint;
      action: Pointer; NumLists: Longint; ListValues: PChar;
      command: string);
    procedure voiceCommandOther(sender: TObject; ApplicationName,
      StateName, command: string);
    procedure voiceUtteranceBegin(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BTNGeneralClick(Sender: TObject);
    procedure BTNAboutClick(Sender: TObject);
    procedure BTNTranslateClick(Sender: TObject);
    procedure BTNLexiconClick(Sender: TObject);
    procedure BTNSpeakClick(Sender: TObject);
    procedure RBCommandClick(Sender: TObject);
    procedure RBTextClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.BTTrainClick(Sender: TObject);
begin
voice.TrainGeneral(handle,'');
end;

procedure TForm1.BTAboutClick(Sender: TObject);
begin
voice.AboutDlg(handle,'');
end;

procedure TForm1.voiceVUMeter(sender: TObject; level: Integer);
begin
VUMeter.position:=trunc(longint(level)/$FFFF*100);
end;

procedure TForm1.voiceCommandRecognize(sender: TObject; ID: Longint;
  ApplicationName, StateName: string; flags, ActionSize: Longint;
  action: Pointer; NumLists: Longint; ListValues: PChar; command: string);
begin
YouSaid.caption:=command;
end;

procedure TForm1.voiceCommandOther(sender: TObject; ApplicationName,
  StateName, command: string);
begin
YouSaid.caption:='<undecipherable>';
end;

procedure TForm1.voiceUtteranceBegin(Sender: TObject);
begin
YouSaid.caption:='';
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
GBCommand.enabled:=voice.exists;
GBText   .enabled:=text .exists;
RBCommand.enabled:=voice.exists;
RBText   .enabled:=text .exists;
BTTrain     .enabled:=voice.TrainGeneral(0,'');
BTAbout     .enabled:=voice.AboutDlg    (0,'');
BTNAbout    .enabled:=text .AboutDlg    (0,'');
BTNGeneral  .enabled:=text .GeneralDlg  (0,'');
BTNTranslate.enabled:=text .TranslateDlg(0,'');
BTNLexicon  .enabled:=text .LexiconDlg  (0,'');
end;

procedure TForm1.BTNGeneralClick(Sender: TObject);
begin
text.GeneralDlg(handle,'');
end;

procedure TForm1.BTNAboutClick(Sender: TObject);
begin
text.AboutDlg(handle,'');
end;

procedure TForm1.BTNTranslateClick(Sender: TObject);
begin
text.TranslateDlg(handle,'');
end;

procedure TForm1.BTNLexiconClick(Sender: TObject);
begin
text.LexiconDlg(handle,'');
end;

procedure TForm1.BTNSpeakClick(Sender: TObject);
begin
if EDText.text<>'' then
  begin
  RBText.checked:=true;
  voice.enabled:=false;
  text.speak(EDText.text,VTXTST_STATEMENT+VTXTSP_NORMAL,'');
  end;  { if }
end;

procedure TForm1.RBCommandClick(Sender: TObject);
begin
voice.enabled:=true;
end;

procedure TForm1.RBTextClick(Sender: TObject);
begin
voice.enabled:=false;
end;

end.
