unit Unit2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, clipbrd, enhavicap, vfw;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    ListBox1: TListBox;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    scaled: TCheckBox;
    BitBtn4: TBitBtn;
    BitBtn5: TBitBtn;
    BitBtn6: TBitBtn;
    preview: TCheckBox;
    Label3: TLabel;
    DlgCompression: TBitBtn;
    DlgDisplay: TBitBtn;
    DlgFormat: TBitBtn;
    DlgSource: TBitBtn;
    RadioGroup1: TRadioGroup;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    video: TEnhAVICap;
    img: TImage;
    Label7: TLabel;
    Label8: TLabel;
    procedure BitBtn2Click(Sender: TObject);
    procedure ListBox1DblClick(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure previewClick(Sender: TObject);
    procedure scaledClick(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure BitBtn6Click(Sender: TObject);
    procedure BitBtn5Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure DlgCompressionClick(Sender: TObject);
    procedure DlgDisplayClick(Sender: TObject);
    procedure DlgFormatClick(Sender: TObject);
    procedure DlgSourceClick(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure videoFrame(Sender: TObject; h: Integer; VHdr: PVideoHdr);
  private
    { Private declarations }
    w:integer;
    h:integer;
    caps:TCapDriverCaps;
  public
    { Public declarations }
  end;

var Form1:TForm1;

implementation

{$R *.DFM}

function FrameCallBack(AWnd:HWnd;lpVHdr:PVideoHdr):longint; stdcall;
var BmpHead:PBitmapInfo;
    h      :THandle;
    punt   :pointer;
begin
GetMem(BmpHead,CapGetVideoFormatSize(AWnd));
CapGetVideoFormat(AWnd,BmpHead,sizeof(TBitmapInfoHeader));
form1.label3.caption:=format('%4.4s %d %d',[PChar(@(BmpHead.bmiHeader.biCompression)),
                                            lpVHdr.dwBufferLength,
                                            lpVHdr.dwBytesUsed]);
BmpHead.bmiHeader.biSizeImage:=lpVHdr.dwBytesUsed;
h:=ICImageDecompress(0,0,BmpHead,lpVHdr.lpData,nil);
if h<>0 then                      
  begin
  punt:=GlobalLock(h);
  SetDIBits(form1.img.canvas.handle,form1.img.picture.bitmap.handle,
            0,BmpHead.bmiHeader.biHeight,
            pointer(longint(punt)+PBitmapInfoHeader(punt).biSize),
            PBitmapInfo(punt)^,
            DIB_RGB_COLORS);
  GlobalUnlock(h);
  GlobalFree(h);
  form1.img.repaint;
  end;
FreeMem(BmpHead,CapGetVideoFormatSize(AWnd));
result:=1;
end;  { FrameCallBack }

procedure TForm1.BitBtn2Click(Sender: TObject);
var BmpHead:TBitmapInfo;
begin
if ListBox1.ItemIndex<>-1 then
  begin
  video.OpenVideo(ListBox1.ItemIndex);
  if video.IsOpen then
    begin
    CapGetVideoFormat(video.CapWnd,@BmpHead,sizeof(BmpHead));
    img.picture.bitmap.width :=BmpHead.bmiHeader.biWidth ;
    img.picture.bitmap.height:=BmpHead.bmiHeader.biHeight;
    end;  { if }
  end;  { if }
end;

procedure TForm1.ListBox1DblClick(Sender: TObject);
var BmpHead:TBitmapInfo;
begin
if ListBox1.ItemIndex<>-1 then
  begin
  video.ConnectDriver(ListBox1.ItemIndex);
  if video.IsOpen then
    begin
    CapGetVideoFormat(video.CapWnd,@BmpHead,sizeof(BmpHead));
    img.picture.bitmap.width :=BmpHead.bmiHeader.biWidth ;
    img.picture.bitmap.height:=BmpHead.bmiHeader.biHeight;
    end;  { if }
  end;  { if }
end;

procedure TForm1.BitBtn3Click(Sender: TObject);
begin
video.CloseVideo;
end;

procedure TForm1.previewClick(Sender: TObject);
begin
if preview.checked then
  video.preview:=true
else
  video.overlay:=true;
end;

procedure TForm1.scaledClick(Sender: TObject);
begin
video.PreviewScaled:=scaled.checked;
end;

procedure TForm1.BitBtn4Click(Sender: TObject);
begin
if video.ToClipboard then
  img.picture.assign(clipboard);
end;

procedure TForm1.BitBtn6Click(Sender: TObject);
begin
video.CaptureStart('c:\avitest.avi');
end;

procedure TForm1.BitBtn5Click(Sender: TObject);
begin
video.CaptureStop;
end;

procedure TForm1.FormCreate(Sender: TObject);
var x:integer;
begin
edit1.text:=video.VFWVersion;
for x:=0 to video.CapDrivers.count-1 do
  ListBox1.items.add(format('%d - %s',[x,video.CapDrivers.strings[x]]));
ListBox1.ItemIndex:=0;
if video.width <>160 then video.width :=160;
if video.height<>120 then video.height:=120;
img.left:=video.left+video.width+16;
form1.height:=video.top+video.height+video.left+
              GetSystemMetrics(SM_CYDLGFRAME)*2+GetSystemMetrics(SM_CYCAPTION);
end;

procedure TForm1.DlgCompressionClick(Sender: TObject);
begin
if video.DlgCompression then MessageBeep(0);
end;

procedure TForm1.DlgDisplayClick(Sender: TObject);
begin
if video.DlgDisplay then MessageBeep(0);
end;

procedure TForm1.DlgFormatClick(Sender: TObject);
begin
if video.DlgFormat then MessageBeep(0);
end;

procedure TForm1.DlgSourceClick(Sender: TObject);
begin
if video.DlgSource then MessageBeep(0);
end;

procedure TForm1.RadioGroup1Click(Sender: TObject);
begin
case RadioGroup1.ItemIndex of
  0 : begin
      video.preview:=false;
      video.overlay:=false;
      end;
  1 : video.preview:=true;
  2 : video.overlay:=true;
  end;  { case }
end;

procedure TForm1.videoFrame(Sender: TObject; h: Integer; VHdr: PVideoHdr);
var punt:pointer;
begin
form1.label3.caption:=format('%d %d',[VHdr.dwBufferLength,
                                      VHdr.dwBytesUsed]);
punt:=GlobalLock(h);
SetDIBits(img.canvas.handle,img.picture.bitmap.handle,
          0,PBitmapInfoHeader(punt).biHeight,
          pointer(longint(punt)+PBitmapInfoHeader(punt).biSize),
          PBitmapInfo(punt)^,
          DIB_RGB_COLORS);
GlobalUnlock(h);
img.repaint;
end;

end.
