unit Demoform;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, Mask, DBCtrls, DB, DBTables, DstTable,
  DstQuery, ExtCtrls, DstTools;

type
  TDescStatDemoForm = class(TForm)
    DataSource1: TDataSource;
    BitBtn1: TBitBtn;
    Edit1: TEdit;
    Edit2: TEdit;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    Edit3: TEdit;
    BitBtn4: TBitBtn;
    Edit4: TEdit;
    DBNavigator1: TDBNavigator;
    DBEdit1: TDBEdit;
    Edit5: TEdit;
    Edit6: TEdit;
    Edit7: TEdit;
    Edit8: TEdit;
    BitBtn5: TBitBtn;
    Edit9: TEdit;
    Edit10: TEdit;
    labTableName: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    labFieldName: TLabel;
    BitBtn6: TBitBtn;
    Label1: TLabel;
    Edit11: TEdit;
    BitBtn7: TBitBtn;
    Label13: TLabel;
    Edit12: TEdit;
    BitBtn8: TBitBtn;
    Label14: TLabel;
    Edit13: TEdit;
    BitBtn9: TBitBtn;
    ComboBox1: TComboBox;
    BitBtn10: TBitBtn;
    OpenDialog1: TOpenDialog;
    Edit14: TEdit;
    Label15: TLabel;
    BitBtn11: TBitBtn;
    DescStatQuery1: TDescStatQuery;
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure DBNavigator1Click(Sender: TObject; Button: TNavigateBtn);
    procedure BitBtn6Click(Sender: TObject);
    procedure BitBtn7Click(Sender: TObject);
    procedure BitBtn8Click(Sender: TObject);
    procedure BitBtn5Click(Sender: TObject);
    procedure BitBtn9Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure BitBtn10Click(Sender: TObject);
    procedure Uncalculated;
    procedure BitBtn11Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  DescStatDemoForm: TDescStatDemoForm;
  diff: double;
  glTableName, glFileName: string;

implementation

{$R *.DFM}

procedure TDescStatDemoForm.BitBtn1Click(Sender: TObject);
begin
 with DescStatQuery1 do
  begin   { mean (must calculate before anything else) }
   if ((Sender as TBitBtn) = BitBtn1) then
    Initialize;
   if datasetLoaded then
    begin
     diff := FieldByName(StatFieldName).AsFloat - mean;
     Edit1.Text := FormatFloat('#.000',mean);
     Edit4.Text := FormatFloat('#.000',diff);
     Edit5.Text := intToStr(dataCount);
     Edit6.Text := FormatFloat('#.000',minimum);
     Edit7.Text := FormatFloat('#.000',maximum);
     Edit8.Text := FormatFloat('#.000',range);
     Edit14.Text := FormatFloat('#.000',total);
     BitBtn3.Enabled := True;
     BitBtn8.Enabled := True
    end
  end
end;

procedure TDescStatDemoForm.BitBtn2Click(Sender: TObject);
begin  { std. dev. (must calculate variance first) }
 with DescStatQuery1 do
  begin
   Edit2.Text := FormatFloat('#.000',stddev);
   Edit9.Text := FormatFloat('#.000',coeffVariation);
   Edit10.Text := FormatFloat('#.000',mode)
  end;
 BitBtn6.Enabled := True
end;

procedure TDescStatDemoForm.BitBtn3Click(Sender: TObject);
begin  { sample variance (must calculate mean first) }
 Edit3.Text := FormatFloat('#.000',DescStatQuery1.sampleVar);
 BitBtn2.Enabled := True;
 BitBtn5.Enabled := True;
 BitBtn7.Enabled := True
end;

procedure TDescStatDemoForm.DBNavigator1Click(Sender: TObject;
  Button: TNavigateBtn);
begin
 with DescStatQuery1 do
  diff := FieldByName(StatFieldName).AsFloat-mean*ScaleBy;
 Edit4.Text := FormatFloat('#.000',diff)
end;

procedure TDescStatDemoForm.BitBtn6Click(Sender: TObject);
begin  { shows chart of freqency distribution and scatter plots }
 DescStatQuery1.SummaryChart
end;

procedure TDescStatDemoForm.BitBtn7Click(Sender: TObject);
begin  { higher moments (skew, kurtosis) -- (must calculate mean first) }
 with DescStatQuery1 do
  begin
   Edit11.Text := FormatFloat('#.000',beta1)+' '+skewSign;
   Edit13.Text := FormatFloat('#.000',beta2)
  end
end;

procedure TDescStatDemoForm.BitBtn8Click(Sender: TObject);
begin { median (must calculate mean first) }
 with DescStatQuery1 do
  Edit12.Text := FormatFloat('#.000',median)
end;

procedure TDescStatDemoForm.BitBtn5Click(Sender: TObject);
begin   { shows frequency distribution of sampled data }
 DescStatQuery1.FrequencyDisplay
end;

procedure TDescStatDemoForm.BitBtn9Click(Sender: TObject);
begin
 DescStatQuery1.Summarize; { calculates all statistics }
 BitBtn2.Enabled := True;
 BitBtn3.Enabled := True;
 BitBtn5.Enabled := True;
 BitBtn6.Enabled := True;
 BitBtn7.Enabled := True;
 BitBtn1Click(Sender);    { display mean and totals }
 BitBtn8Click(Sender);    { display median }
 BitBtn3Click(Sender);    { display variance }
 BitBtn2Click(Sender);    { display std. dev. }
 BitBtn7Click(Sender);    { display skew, kurtosis }
end;

procedure TDescStatDemoForm.ComboBox1Change(Sender: TObject);
begin
 with DescStatQuery1 do
  begin
   StatFieldName := ComboBox1.Text;
   DBEdit1.DataField := StatFieldName;
   labFieldName.Caption := 'Field Analyzed: '+StatFieldName;
   Initialize
  end;
 Uncalculated
end;

procedure TDescStatDemoForm.BitBtn10Click(Sender: TObject);
begin
 with DescStatQuery1 do
 if OpenDialog1.Execute then
  begin
   DescStatQuery1.Close;
   DataSource1.Enabled := False;
   glFileName := OpenDialog1.FileName;
   glTableName := ExtractFileName(glFileName);
   DatabaseName := ExtractFilePath(glFileName);
   Screen.Cursor := crHourGlass;
   SQL.Clear;
   SQL.Add('Select * from "'+glTableName+'"');
   labTableName.Caption := 'Table Name: '+glTableName;
   ComboBox1.Items.Assign(NumericFields);
   if (NumericFields.IndexOf(StatFieldName) < 0) then
    StatFieldName := NumericFields[0];
   ComboBox1.Text := StatFieldName;
   DBEdit1.DataField := StatFieldName;
   BitBtn1.Enabled := (ComboBox1.Items.Count > 0);
   BitBtn9.Enabled := (ComboBox1.Items.Count > 0);
   BitBtn11.Enabled := (ComboBox1.Items.Count > 0);
   labFieldName.Caption := 'Field Analyzed: '+StatFieldName;
   DataSource1.Enabled := True;
   DescStatQuery1.Open;
   BitBtn10.Caption := glTableName;
   Screen.Cursor := crDefault;
   Uncalculated
  end;
end;

procedure TDescStatDemoForm.Uncalculated;
begin
 Edit1.Text := 'Uncalculated';
 Edit2.Text := 'Uncalculated';
 Edit3.Text := 'Uncalculated';
 Edit4.Text := 'Uncalculated';
 Edit5.Text := 'Uncalculated';
 Edit6.Text := 'Uncalculated';
 Edit7.Text := 'Uncalculated';
 Edit8.Text := 'Uncalculated';
 Edit9.Text := 'Uncalculated';
 Edit10.Text := 'Uncalculated';
 Edit11.Text := 'Uncalculated';
 Edit12.Text := 'Uncalculated';
 Edit13.Text := 'Uncalculated';
 Edit14.Text := 'Uncalculated';
 BitBtn2.Enabled := False;
 BitBtn3.Enabled := False;
 BitBtn5.Enabled := False;
 BitBtn6.Enabled := False;
 BitBtn7.Enabled := False;
 BitBtn8.Enabled := False;
end;

procedure TDescStatDemoForm.BitBtn11Click(Sender: TObject);
begin
 DescStatQuery1.Output;
 BitBtn8.Enabled := True;
 BitBtn2.Enabled := True;
 BitBtn3.Enabled := True;
 BitBtn5.Enabled := True;
 BitBtn6.Enabled := True;
 BitBtn7.Enabled := True;
end;

end.
