// Rompo Punyanitya, free component http://www.eisa.net.au/~lom
// email at lom@eisa.net.au 
unit ThreadDir;
interface
uses Classes,SysUtils;
type
  TAttribute = (ftReadOnly, ftHidden, ftSystem, ftVolumeID, ftDirectory, ftArchive, ftNormal);
  TAttributes = set of TAttribute;
  TOnRead     = procedure(Sender: TObject;ItemPath : AnsiString;ItemInfo: TSearchRec) of object;
  TThreadDir  = class(TThread)
  private
   FPath      : AnsiString;
   FFileName  : AnsiString;
   FOnRead    : TOnRead;
   FAttribute : Integer;
   procedure ReadDir;
  protected
   procedure Execute; override;
  public
   constructor Create(aPriority : TThreadPriority;aPath,aFileName : AnsiString;aAttributes : integer;AOnRead : TOnRead);
  end;
  TDirReader  = Class(TComponent)
  private
   FPriority   : TThreadPriority;
   FFileName   : AnsiString;
   FPath       : AnsiString;
   FAttribute  : Integer;
   FAttributes : TAttributes;
   FOnRead     : TOnRead;
   FBeforeRead : TNotifyEvent;
   FAfterRead  : TNotifyEvent;
   Procedure SetAttributes(Value : TAttributes);
   function GetAttribute : Integer;
  public
   constructor Create(AOwner : TComponent);override;
   procedure   Dir;
   property Attribute : Integer read GetAttribute;
  published
   property Priority   : TThreadPriority read FPriority    write FPriority;
   property FileName   : AnsiString      read FFileName    write FFileName;
   property Path       : AnsiString      read FPath        write FPath;
   property Attributes : TAttributes     read FAttributes  write SetAttributes;
   property OnRead     : TOnRead         read FOnRead      write FOnRead;
   property BeforeRead : TNotifyEvent    read FBeforeRead  write FBeforeread;
   property AfterRead  : TNotifyEvent    read FAfterRead   write FAfterRead;
  end;
procedure Register;
function SlashSep(const Path, S: String): String;
implementation
Function TDirReader.GetAttribute : Integer;
begin
	 result := FAttribute;
end;
function SlashSep(const Path, S: String): String;
begin
     if AnsiLastChar(Path)^ <> '\' then
     Result := Path + '\' + S
     else
     Result := Path + S;
end;
procedure TThreadDir.ReadDir;
var SearchRec : TSearchRec;
    Status : Integer;
begin
     Status := FindFirst(PChar(SlashSep(FPath,FFileName)),FAttribute, SearchRec);
     try
        while Status = 0 do
        begin
             if ((SearchRec.Attr and FAttribute) <> 0) and Assigned(FOnRead) Then
             FOnRead(Self,FPath,SearchRec);
             Status := FindNext(SearchRec);
        end;
     finally
     FindClose(SearchRec);
     end;
end;
procedure TThreadDir.Execute;
begin
     Synchronize(ReadDir);
end;
constructor TThreadDir.Create(aPriority : TThreadPriority;aPath,aFileName : AnsiString;aAttributes : integer;AOnRead : TOnRead);
begin
     FPath      := aPath;
     FFileName  := aFileName;
     FAttribute := aAttributes;
     FOnRead    := aOnRead;
     Priority   := aPriority;
     FreeOnTerminate := True;
     inherited Create(False);
end;
Procedure TDirReader.SetAttributes(Value : TAttributes);
begin
     if Value <> FAttributes then
     begin
          FAttributes := Value;
          FAttribute  := 0;
          if (FtReadOnly in FAttributes) then
          FAttribute := FAttribute or FaReadOnly;
          if ftHidden in FAttributes then
          FAttribute := FAttribute or faHidden;
          if ftSystem in FAttributes then
          FAttribute := FAttribute or faSysFile;
          if ftDirectory in FAttributes then
          FAttribute := FAttribute or faVolumeID;
          if ftDirectory in FAttributes then
          FAttribute := FAttribute or faDirectory;
          if ftArchive in FAttributes then
          FAttribute := FAttribute or faArchive;
          if ftNormal in FAttributes then
          FAttribute := FAttribute or faAnyFile;
     end;
end;
constructor TDirReader.Create(AOwner : TComponent);
begin
     inherited Create(AOwner);
     GetDir(0,FPath);
     FFileName := '*.*';
end;
procedure TDirReader.Dir;
begin
     if Assigned(FBeforeRead) then FBeforeRead(Self);
     TThreadDir.Create(FPriority,FPath,FFileName,FAttribute,FOnRead);
     if Assigned(FAfterRead) then FAfterRead(Self);
end;
procedure Register;
begin
     RegisterComponents('Cyber Lom', [TDirReader]);
end;
end.
