unit DBDateTimePicker;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, DB, DBCtrls;

type
  TDBDateTimePicker = class(TDateTimePicker)
  private
    FDataLink: TFieldDataLink;
    FReadOnly: boolean;
    bChanging: boolean;
    bUpdating: boolean;
    NewOnChange: TNotifyEvent;
    function GetDataSource: TDataSource;
    function GetDataField: string;
    procedure SetDataSource(Value: TDataSource);
    procedure SetDataField(Value: string);
    procedure DataChange(Sender: TObject);
    procedure UpdateData(Sender: TObject);
    procedure CMExit(var Message: TWMNoParams); message CM_EXIT;
  protected
    procedure Change(Sender: TObject);
  public
    constructor Create(AOwner: TComponent); override;
    destructor  Destroy; override;
    procedure LlamarChange;
  published
    property DataSource: TDataSource read GetDataSource write SetDataSource;
    property DataField: string read GetDataField write SetDataField;
    property ReadOnly: Boolean read FReadOnly write FReadOnly default False;
    property OnChanging: TNotifyEvent read NewOnChange write NewOnChange;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Data Controls', [TDBDateTimePicker]);
end;

function TDBDateTimePicker.GetDataSource: TDataSource;
begin
     GetDataSource := FDataLink.DataSource;
end;

procedure TDBDateTimePicker.SetDataSource(Value: TDataSource);
begin
     FDataLink.DataSource := Value;
end;

function TDBDateTimePicker.GetDataField: string;
begin
     GetDataField := FDataLink.FieldName;
end;

procedure TDBDateTimePicker.SetDataField(Value: string);
begin
     FDataLink.FieldName := Value;
end;

constructor TDBDateTimePicker.Create(AOwner: TComponent);
begin
     inherited Create(AOwner); { always call the inherited constructor first }
{     FReadOnly := True; }{ this is already here }
     FDataLink := TFieldDataLink.Create; { construct the data-link object }
     FDataLink.OnDataChange := DataChange;
     FDataLink.OnUpdateData := UpdateData;
     (Self as TDateTimePicker).OnChange := Change;
end;

destructor TDBDateTimePicker.Destroy;
begin
     FDataLink.OnDataChange := nil;
     FDataLink.OnUpdateData := nil;
     FDataLink.Free; { always destroy owned objects first... }
     inherited Destroy; { ...then call inherited destructor }
end;

procedure TDBDateTimePicker.DataChange(Sender: TObject);
begin
     if not(csDestroying in ComponentState) and
        not bChanging then
     begin
     bUpdating := True;
     if (FDataLink.Field = nil) or
        FDataLink.Field.IsNull then { if there is no field assigned... }
     begin
        Date := 1; { ...set to invalid date }
        Time := 1;
     end
     else
     begin
          Date := FDataLink.Field.AsDateTime; { otherwise, set calendar to the date }
          Time := FDAtaLink.Field.AsDateTime;
     end;
     bUpdating := False;
     end;
end;

procedure TDBDateTimePicker.Change(Sender: TObject);
begin
     if not bUpdating then
     begin
     bChanging := True;
     if FDataLink.Edit then
        FDataLink.Modified;
     bChanging := False;
     end;
     if Assigned(NewOnChange) then NewOnChange(Sender);
end;

procedure TDBDateTimePicker.UpdateData(Sender: TObject);
begin
     if Kind = dtkDate then
        FDataLink.Field.AsDateTime := Date { set field link to calendar date }
     else
        FDataLink.Field.AsDateTime := Time { set field link to calendar date }
end;

procedure TDBDateTimePicker.CMExit(var Message: TWMNoParams);
begin
     try
        FDataLink.UpdateRecord; { tell data link to update database }
     except
        on Exception do SetFocus; { if it failed, don't let focus leave }
     end;
     inherited;
end;

procedure TDBDateTimePicker.LlamarChange;
begin
{     Change;}
end;

end.
