unit mainform;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Blowfish, Registry, ComCtrls, Buttons, ExtCtrls, ShellAPI;

type
  TPassRecord = record
    AccountName: string;
    LoginID: string;
    Password: string;
    Notes: string;
end;

type
  TfrmMain = class(TForm)
    cboAccount: TComboBox;
    edtLogin: TEdit;
    edtPassword: TEdit;
    Blowfish1: TBlowfish;
    sdlDataFile: TSaveDialog;
    stbMain: TStatusBar;
    pnlControls: TPanel;
    spdNew: TSpeedButton;
    spdOpen: TSpeedButton;
    spdSave: TSpeedButton;
    spdClose: TSpeedButton;
    lblAccount: TLabel;
    lblLogin: TLabel;
    lblPassword: TLabel;
    Bevel1: TBevel;
    spdAdd: TSpeedButton;
    spdDelete: TSpeedButton;
    mmoNotes: TMemo;
    lblNotes: TLabel;
    spdExit: TSpeedButton;
    odlDataFile: TOpenDialog;
    spdSaveAs: TSpeedButton;
    spdChangePassword: TSpeedButton;
    spdAboutTSM: TSpeedButton;
    lblVersion: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    Bevel2: TBevel;
    procedure FormCreate(Sender: TObject);
    procedure cboAccountChange(Sender: TObject);
    procedure spdNewClick(Sender: TObject);
    procedure spdOpenClick(Sender: TObject);
    procedure spdSaveClick(Sender: TObject);
    procedure spdAddClick(Sender: TObject);
    procedure spdDeleteClick(Sender: TObject);
    procedure edtLoginChange(Sender: TObject);
    procedure edtPasswordChange(Sender: TObject);
    procedure mmoNotesChange(Sender: TObject);
    procedure spdCloseClick(Sender: TObject);
    procedure spdExitClick(Sender: TObject);
    procedure spdSaveAsClick(Sender: TObject);
    procedure spdChangePasswordClick(Sender: TObject);
    procedure spdAboutTSMClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    DataMAC: string;
    RecordList: TStringList;
    Changed: Boolean;
    Loading: Boolean;
    CurrentRecord: TPassRecord;
    function  Unpack(const StringToUnpack: string): TPassRecord;
    function  Pack(const RecordToPack: TPassRecord): string;
    procedure LoadCombo;
    procedure ClearData;
    procedure SaveData;
    procedure LoadData;
    procedure UpdateData(const DataToUpdate: TPassRecord);
    function  GatherData: TPassRecord;
    procedure SpreadData(const DataToSpread: TPassRecord);
    function  GetPassword: string;
    function  CheckPassword(const DataFileToCheck: string): Boolean;
    procedure OpenFile(const FileToOpen: string);
    procedure CheckSave;
    procedure SetChanged(const NewState: Boolean);
    procedure SetButtons;
    procedure SetFields;
    function  FindRecord(const DataToFind: TPassRecord): integer;
    procedure BurnString(var StringToBurn: string);
    procedure BurnDataRecord(var DataRecord: TPassRecord);
  public
    Password: string;
    DataFileName: string;
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

uses
     newacct, login;

const
     RELVER            = '1.03';
     LIT_PAD           = 'TSM padd';
     LIT_IV            = 'afafaqerJHV87%RhG(/f8zf';
     LIT_WRONGPASSWORD = 'The password was not correct. The data file was not opened';
     LIT_OVERWRITE     = ' exists already. Do you want to overwrite it?';
     LIT_SAVECHANGES   = 'You have changed your data. Do you want to save your changes?';

procedure TfrmMain.SetChanged(const NewState: Boolean);
begin
     // if NewState is true, then we always set
     // if NewState is false we always reset
     if NewState then
     begin
          // save previous changed states
          Changed := Changed or NewState;
     end
     else
     begin
          // reset
          Changed := false;
     end; {if Newstate}

     if Changed then
     begin
          stbMain.Panels[1].Text := 'MOD';
     end
     else
     begin
          stbMain.Panels[1].Text := '';
     end; {if Changed}
end; {TfrmMain.SetChanged}

procedure TfrmMain.BurnString(var StringToBurn: string);
var
     i: integer;
begin
     for i := 1 to Length(StringToBurn) do
     begin
          // reset each byte of the string
          StringToBurn[i] := ' ';
     end; {for i}

     // set the length to zero
     StringToBurn := '';
end; {TfrmMain.BurnString}

function TfrmMain.GetPassword: string;
var
     frmLogin: TfrmLogin;
     PasswordTotest: string;
     TempString: string;
begin
     // show the password screen and get a passord
     frmLogin := TfrmLogin.Create(self);
     frmLogin.ShowModal;
     PasswordToTest := frmLogin.edtPassword.Text;
     frmLogin.Free;

     // only proceed if we have a password
     if PasswordToTest <> '' then
     begin
          // set up blowfish
          Blowfish1.CipherMode := CBC;
          Blowfish1.LoadIVString(PasswordToTest);
          Blowfish1.InitialiseString(PasswordToTest);
          Blowfish1.EncryptString(PasswordToTest, TempString);
          Blowfish1.CBCMACString(TempString);
          Blowfish1.Burn;

          // store the password and MAC
          DataMAC := TempString;
          Password := PasswordToTest;

          Result := DataMAC;
     end;

     // Burn Data
     BurnString(PasswordToTest);
     BurnString(TempString);
end; {TfrmMain.GetPassword}

function TfrmMain.CheckPassword(const DataFileToCheck: string): Boolean;
var
     DataFile: TextFile;
     MACFromFile: string;
begin
     if not FileExists(DataFileToCheck) then
     begin
          Result := False;
          Exit;
     end;

     AssignFile(DataFile, DataFileToCheck);

     Reset(DataFile);

     // read the mac
     ReadLn(DataFile, MACFromFile);

     CloseFile(DataFile);


     if MACFromFile <> DataMAC then
     begin
          // password is not verified, exit;
          Result := False;
     end
     else
     begin
          Result := True;
     end;

     // Burn
     BurnString(MACFromFile);
end; {TfrmMain.CheckPassword}

procedure TfrmMain.ClearData;
begin
     // stop the combo box autolocate
     Loading := True;

     RecordList.Clear;

     cboAccount.Items.Clear;
     cboAccount.Text := '';
     edtLogin.Text := '';
     edtPassword.Text := '';
     mmoNotes.Lines.Clear;

     // set the input fields
     SetFields;

     Loading := False;
end; {TfrmMain.ClearData}

procedure TfrmMain.LoadData;
var
     DataFile: TextFile;
     DataLine: string;
begin
     // load in the account names from the data file
     AssignFile(DataFile, DataFileName);

     Reset(DataFile);

     // read the mac - this is a dummy read as we have already
     // checked this.
     ReadLn(DataFile, DataLine);

     // read in the records
     while not EOF(DataFile) do
     begin
          // read the data record and add to the list
          ReadLn(DataFile,DataLine);
          RecordList.Add(DataLine);
     end;

     CloseFile(DataFile);

     // update the status bar
     stbMain.Panels[2].Text := DataFileName;

     LoadCombo;

     // reset the changed status
     SetChanged(False);
end; {TfrmMain.LoadData}

procedure TfrmMain.SaveData;
var
     DataFile: TextFile;
     i: integer;
begin
     // save the information back to the file
     // update the status panel
     stbMain.Panels[2].Text := DataFileName;

     // open the data file
     AssignFile(DataFile, DataFileName);

     FileMode := 1;

     Rewrite(DataFile);

     // save the MAC
     WriteLn(DataFile, DataMAC);

     for i := 0 to RecordList.Count-1 do
     begin
          WriteLn(DataFile, RecordList.Strings[i]);
     end;

     // close the file
     CloseFile(DataFile);

     // update the changed status
     SetChanged(False);
end; {TfrmMain.SaveData}

procedure TfrmMain.UpdateData(const DataToUpdate: TPassRecord);
var
     i: integer;
begin
     if RecordList.Count > 0 then
     begin
          i := FindRecord(DataToUpdate);
          RecordList.Strings[i] := Pack(DataToUpdate);
     end;
end; {TfrmMain.UpdateData}

function TfrmMain.FindRecord(const DataToFind: TPassRecord): integer;
var
     i: integer;
     TempString: string;
     KeyString: string;
     KeyString1: string;
begin
     Result := 0;

     TempString := Pack(DataToFind);
     KeyString := Copy(TempString,1, Pos(';',TempString)-1);

     for i := 0 to RecordList.Count-1 do
     begin
          KeyString1 := Copy(RecordList.Strings[i], 1, Pos(';', RecordList.Strings[i])-1);
          if KeyString1 = KeyString then
          begin
               Result := i;
               Exit;
          end;
     end;
end; {TfrmMain.FindRecord}

procedure TfrmMain.LoadCombo;
var
     DataRecord: TPassRecord;
     i: integer;
begin
     // we should implement some sort of burn here
     cboAccount.Items.Clear;

     // load from scratch
     for i := 0 to RecordList.Count-1 do
     begin
          DataRecord := UnPack(RecordList.Strings[i]);
          cboAccount.Items.Add(DataRecord.AccountName);
     end;

     // update the status line
     stbMain.Panels[0].Text := IntToStr(RecordList.Count);

     // reset the default display
     if cboAccount.Items.Count > 0 then
     begin
          cboAccount.ItemIndex := 0;
          cboAccountChange(self);
     end
     else
     begin
          // there are no records - clear
          cboAccount.Text := '';
          edtLogin.Text := '';
          edtPassword.Text := '';
          mmoNotes.Lines.Clear;
     end;

     // set the enabled state of the fields
     SetFields;

     // Burn the temp record
     BurnDataRecord(DataRecord);
end; {TfrmMain.LoadCombo}

procedure TfrmMain.FormCreate(Sender: TObject);
var
     Reg: TRegistry;
begin
     // display the version on the main window
     lblVersion.Caption := RELVER;
     
     // create list
     RecordList := TStringList.Create;

     // get the name of the file to read if there is one
     Reg := TRegistry.Create;

     // try to find the default file
     if Reg.OpenKey('Software\TSMInc\PassKeep',False) then
     begin
          DataFileName := Reg.ReadString('Datafile');

          OpenFile(DataFileName);
     end
     else
     begin
          SetButtons;
          SetFields;
     end;

     Reg.Free;
end; {TfrmMain.FormCreate}

procedure TfrmMain.OpenFile(const FileToOpen: string);
begin
     // if there is a data file, then attempt to open it
     if FileExists(FileToOpen) and (FileToOpen <> '') then
     begin
          // clear the current data
          ClearData;

          // get the password for the new file
          GetPassword;

          if not CheckPassword(FileToOpen) then
          begin
               // password did not verify - clear the info
               DataFileName := '';
               stbMain.Panels[2].Text := 'No data file';

               // tell the user
               MessageDlg(LIT_WRONGPASSWORD, mtError, [mbOK], 0);
          end
          else
          begin
               DataFileName := FileToOpen;

               // Load the data
               LoadData;
          end;
     end
     else
     begin
          // no data file - clear the info
          DataFileName := '';
          stbMain.Panels[2].Text := 'Data file not found';
     end;

     SetButtons;
     SetFields;

end; {TfrmMain.OpenFile}

function TfrmMain.Pack(const RecordToPack: TPassRecord): string;
var
     TempString: string;
     TempString1: string;
begin
     // load blowfish
     Blowfish1.CipherMode := CBC;
     Blowfish1.LoadIVString(LIT_IV);
     Blowfish1.InitialiseString(Password + LIT_PAD);

     TempString := '';
     Blowfish1.EncryptString(RecordToPack.AccountName, TempString1);
     TempString := TempString + TempString1;
     TempString := TempString + ';';
     Blowfish1.EncryptString(RecordToPack.LoginId, TempString1);
     TempString := TempString + TempString1;
     TempString := TempString + ';';
     Blowfish1.EncryptString(RecordToPack.Password, TempString1);
     TempString := TempString + TempString1;
     TempString := TempString + ';';
     Blowfish1.EncryptString(RecordToPack.Notes, TempString1);
     TempString := TempString + TempString1;
     Result := TempString;

     // burn Blowfish
     Blowfish1.Burn;

     // burn temp variables
     BurnString(TempString);
     BurnString(TempString1);
end; {TfrmMain.Pack}

function TfrmMain.Unpack(const StringToUnpack: string): TPassRecord;
var
     ParsePos: integer;
     TempString: string;
begin
     // load blowfish
     Blowfish1.CipherMode := CBC;
     Blowfish1.LoadIVString(LIT_IV);
     Blowfish1.InitialiseString(Password + LIT_PAD);

     // parse the data record
     TempString := StringToUnpack;
     ParsePos := Pos(';',TempString);
     Result.AccountName := Copy(TempString,1,ParsePos-1);
     TempString := Copy(TempString,ParsePos+1,Length(TempString)-ParsePos);
     ParsePos := Pos(';',TempString);
     Result.LoginId := Copy(TempString,1,ParsePos-1);
     TempString := Copy(TempString,ParsePos+1,Length(TempString)-ParsePos);
     ParsePos := Pos(';',TempString);
     Result.Password := Copy(TempString,1,ParsePos-1);
     TempString := Copy(TempString,ParsePos+1,Length(TempString)-ParsePos);
     Result.Notes := TempString;

     // decrypt the strings
     Blowfish1.DecryptString(Result.AccountName, TempString);
     Result.AccountName := TempString;
     Blowfish1.DecryptString(Result.LoginId, TempString);
     Result.LoginId := TempString;
     Blowfish1.DecryptString(Result.Password, TempString);
     Result.Password := TempString;
     Blowfish1.DecryptString(Result.Notes, TempString);
     Result.Notes := TempString;

     // burn Blowfish
     Blowfish1.Burn;

     // burn temp variables
     BurnString(TempString);
end; {TfrmMain.Unpack}

procedure TfrmMain.cboAccountChange(Sender: TObject);
var
     i: integer;
     DataRecord: TPassRecord;
begin
     Loading := True;

     // set defaults
     edtLogin.Text := '';
     edtPassword.Text := '';
     mmoNotes.Lines.Clear;
     CurrentRecord.AccountName := '';
     CurrentRecord.LoginID := '';
     CurrentRecord.Password := '';

     // find a matching record
     for i := 0 to RecordList.Count-1 do
     begin
          DataRecord := UnPack(RecordList.Strings[i]);
          if DataRecord.AccountName = cboAccount.Text then
          begin
               SpreadData(DataRecord);
               CurrentRecord := DataRecord;
          end;
     end;

     Loading := False;

     SetFields;

     // Burn the temp record
     BurnDataRecord(DataRecord);
end; {TfrmMain.cboAccountChange}

procedure TfrmMain.BurnDataRecord(var DataRecord: TPassRecord);
begin
     // burn each of the strings individually
     BurnString(DataRecord.AccountName);
     BurnString(DataRecord.LoginId);
     BurnString(DataRecord.Password);
     BurnString(DataRecord.Notes);
end; {TfrmMain.BurnDataRecord}

procedure TfrmMain.SetFields;
begin
     //set the edit boxes
     if cboAccount.Text = '' then
     begin
          edtLogin.Enabled := False;
          edtPassword.Enabled := False;
          mmoNotes.Enabled := False;
     end
     else
     begin
          edtLogin.Enabled := True;
          edtPassword.Enabled := True;
          mmoNotes.Enabled := True;
     end;
end; {TfrmMain.SetFields}

procedure TfrmMain.spdNewClick(Sender: TObject);
var
     Reg: TRegistry;
begin
     // if the old file has changed, save the changes to it
     CheckSave;

     Reg := TRegistry.Create;

     // create a new data file
     if odlDataFile.Execute then
     begin
          // check if the file exists
          if FileExists(odlDataFile.FileName) then
          begin
               // file exists - should we overwrite?
               if MessageDlg(odlDataFile.FileName + LIT_OVERWRITE, mtConfirmation, [mbOK, mbCancel] ,0) = mrOK then
               begin
                    // set the data filename
                    DataFileName := odlDataFile.FileName;

                    // get the password fr the file
                    GetPassword;

                    // Save the file
                    SaveData;

                    // set the current file in the registry
                    Reg.OpenKey('Software\TSMInc\PassKeep',True);
                    Reg.WriteString('Datafile', DataFileName);
               end; {if MessageDlg}
          end
          else
          begin
               // set the data filename
               DataFileName := odlDataFile.FileName;

               // get the password fr the file
               GetPassword;

               // Save the file
               SaveData;

               // set the current file in the registry
               Reg.OpenKey('Software\TSMInc\PassKeep',True);
               Reg.WriteString('Datafile', DataFileName);
          end; {if FileExists}
     end;

     // Update the button and field status
     SetButtons;
     SetFields;

     // release the registry
     Reg.Free;
end; {TfrmMain.spdNewClick}

procedure TfrmMain.spdOpenClick(Sender: TObject);
var
     Reg: TRegistry;
begin
     // if the old file has changed, save the changes to it
     CheckSave;

     // create the registy object to save the path to the file
     Reg := TRegistry.Create;

     if odlDataFile.Execute then
     begin
          DataFileName := odlDataFile.FileName;

          OpenFile(DataFileName);

          // set the current file in the registry
          Reg.OpenKey('Software\TSMInc\PassKeep',True);
          Reg.WriteString('Datafile', DataFileName);
     end;
     Reg.Free;
end; {TfrmMain.spdOpenClick}

procedure TfrmMain.spdSaveClick(Sender: TObject);
begin
     SaveData;
end; {TfrmMain.spdSaveClick}

procedure TfrmMain.spdSaveAsClick(Sender: TObject);
var
     Reg: TRegistry;
begin
     Reg := TRegistry.Create;

     if sdlDataFile.Execute then
     begin
          DataFileName := sdlDataFile.FileName;
          SaveData;

          // set the current file in the registry
          Reg.OpenKey('Software\TSMInc\PassKeep',True);
          Reg.WriteString('Datafile', DataFileName);
     end;
     Reg.Free;
end; {TfrmMain.spdSaveAsClick}

procedure TfrmMain.spdAddClick(Sender: TObject);
var
     frmNewAcct: TfrmNewAcct;
     TempString: string;
     NewAccount: TPassRecord;
     i: integer;
begin
     frmNewAcct := TfrmNewAcct.Create(self);
     frmNewAcct.ShowModal;
     if frmNewAcct.NewAccountName <> '' then
     begin
          // create the new record
          NewAccount.AccountName := frmNewAcct.NewAccountName;
          TempString := Pack(NewAccount);
          RecordList.Add(TempString);
          RecordList.Sort;

          // update the changed status
          SetChanged(True);
     end; {if}
     frmNewAcct.Free;

     // load in any new records into the combobox
     LoadCombo;

     // find the record in the list
     for i := 0 to cboAccount.Items.Count-1 do
     begin
          if cboAccount.Items.Strings[i] = NewAccount.AccountName then
          begin
               cboAccount.ItemIndex := i;
               cboAccountChange(self);
               SetButtons;
               edtLogin.SetFocus;
               Exit;
          end;
     end;

     // set the state of the speed buttons
     SetButtons;

     // Burn the temp record
     BurnDataRecord(NewAccount);
end; {TfrmMain.spdAddClick}

procedure TfrmMain.spdDeleteClick(Sender: TObject);
var
     i: integer;
     DataRecord: TPassRecord;
begin
     // find a matching record
     for i := 0 to RecordList.Count-1 do
     begin
          DataRecord := UnPack(RecordList.Strings[i]);
          if DataRecord.AccountName = cboAccount.Text then
          begin
               RecordList.Delete(i);
               Break;
          end;
     end;

     // Load the combo box again
     LoadCombo;

     // update the changed status
     SetChanged(True);

     // set the state of the speed buttons
     SetButtons;

     // Burn the temp record
     BurnDataRecord(DataRecord);
end; {TfrmMain.spdDeleteClick}

procedure TfrmMain.edtLoginChange(Sender: TObject);
var
     DataRecord: TPassRecord;
begin
     if Loading then Exit;

     DataRecord := GatherData;

     if edtLogin.Text <> CurrentRecord.LoginID then
     begin
          UpdateData(DataRecord);
          SetChanged(True);
     end;

     // Burn the temp record
     BurnDataRecord(DataRecord);
end; {TfrmMain.edtLoginChange}

procedure TfrmMain.edtPasswordChange(Sender: TObject);
var
     DataRecord: TPassRecord;
begin
     if Loading then Exit;

     DataRecord := GatherData;

     if edtPassword.Text <> CurrentRecord.Password then
     begin
          UpdateData(DataRecord);
          SetChanged(True);
     end;

     // Burn the temp record
     BurnDataRecord(DataRecord);
end; {TfrmMain.edtPasswordChange}

procedure TfrmMain.mmoNotesChange(Sender: TObject);
var
     DataRecord: TPassRecord;
begin
     if Loading then Exit;

     DataRecord := GatherData;

     if DataRecord.Notes <> CurrentRecord.Notes then
     begin
          UpdateData(DataRecord);
          SetChanged(True);
     end;

     // Burn the temp record
     BurnDataRecord(DataRecord);
end; {TfrmMain.mmoNotesChange}

function TfrmMain.GatherData: TPassRecord;
var
     i: integer;
begin
     Result.AccountName := cboAccount.Text;
     Result.LoginID := edtLogin.Text;
     Result.Password := edtPassword.Text;
     Result.Notes := '';
     for i := 0 to mmoNotes.Lines.Count-1 do
     begin
          Result.Notes := Result.Notes + mmoNotes.Lines[i] + ';';
     end;
end; {TfrmMain.GatherData}

procedure TfrmMain.SpreadData(const DataToSpread: TPassRecord);
var
     SepPos: integer;
     TempString: string;
     TempString1: string;
begin
     cboAccount.Text := DataToSpread.AccountName;
     edtLogin.Text := DataToSpread.LoginID;
     edtPassword.Text := DataToSpread.Password;
     mmoNotes.Lines.Clear;
     TempString := DataToSpread.Notes;
     SepPos := Pos(';', TempString);
     while SepPos <> 0 do
     begin
          TempString1 := Copy(TempString,1,SepPos-1);
          mmoNotes.Lines.Add(TempString1);
          TempString := Copy(TempString,SepPos+1,Length(TempString));
          SepPos := Pos(';', TempString);
     end;

     // burn the temp variables
     BurnString(TempString);
     BurnString(TempString1);
end; {TfrmMain.SpreadData}

procedure TfrmMain.spdCloseClick(Sender: TObject);
begin
     // check if there is data to be saved
     CheckSave;

    // Close the data file
    DataFileName := '';

    // clear the display
    ClearData;
    stbMain.Panels[0].Text := '0';
    stbMain.Panels[1].Text := '';
    stbMain.Panels[2].Text := 'No data file';

    SetButtons;
end; {TfrmMain.spdCloseClick}

procedure TfrmMain.CheckSave;
begin
     if Changed then
     begin
          // ask if we want to save
          if MessageDlg(LIT_SAVECHANGES, mtConfirmation, [mbYes, mbNo], 0) = mrYes then
          begin
               SaveData;
          end;
     end;
end; {TfrmMain.CheckSave}

procedure TfrmMain.SetButtons;
begin
     if DataFileName = '' then
     begin
          spdNew.Enabled := True;
          spdOpen.Enabled := True;
          spdSave.Enabled := False;
          spdSaveAs.Enabled := False;
          spdClose.Enabled := False;
          spdAdd.Enabled := False;
          spdDelete.Enabled := False;
          spdChangePassword.Enabled := False;
     end
     else
     begin
          spdNew.Enabled := True;
          spdOpen.Enabled := True;
          spdSave.Enabled := True;
          spdSaveAs.Enabled := True;
          spdClose.Enabled := True;
          spdAdd.Enabled := True;
          spdDelete.Enabled := True;
          spdChangePassword.Enabled := True;
     end;

     spdDelete.Enabled := (RecordList.Count > 0);
end; {TfrmMain.SetButtons}

procedure TfrmMain.spdExitClick(Sender: TObject);
begin
     // check for save
     CheckSave;
     Halt;
end; {TfrmMain.spdExitClick}

procedure TfrmMain.spdChangePasswordClick(Sender: TObject);
var
     OldPassword: string;
     NewPassword: string;
     TempRecord: TPassRecord;
     i: integer;
begin
     // save the old password
     OldPassword := Password;

     // get the new password
     GetPassword;
     NewPassword := Password;

     if Password <> '' then
     begin
          // rename the password file
          DeleteFile(DataFileName + '.bak');
          RenameFile(DataFileName, DataFileName + '.bak');

          // convert the encrypted passwords
          for i := 0 to RecordList.Count-1 do
          begin
               // decrypt the old password
               Password := OldPassword;
               TempRecord := UnPack(RecordList.Strings[i]);
               Password := NewPassword;
               RecordList.Strings[i] := Pack(TempRecord);
          end;

          // Save the file
          SaveData;
     end;

     // Burn the temp passwords
     BurnString(OldPassword);
     BurnString(NewPassword);

     // Burn the temp record
     BurnDataRecord(TempRecord);
end; {TfrmMain.spdChangePasswordClick}

procedure TfrmMain.spdAboutTSMClick(Sender: TObject);
begin
     ShellExecute(GetDesktopWindow(), nil, PChar('http://www.crypto-central.com/html/software.html'), nil, nil, SW_SHOWNORMAL);
end; {TfrmMain.spdAboutTSMClick}

procedure TfrmMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
     CheckSave;
end;

end.

