// Borland C++ Builder
// Copyright (c) 1995, 1998 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Blowfish.pas' rev: 3.00

#ifndef BlowfishHPP
#define BlowfishHPP
#include <SysUtils.hpp>
#include <Classes.hpp>
#include <SysInit.hpp>
#include <System.hpp>

//-- user supplied -----------------------------------------------------------

namespace Blowfish
{
//-- type declarations -------------------------------------------------------
#pragma pack(push, 1)
struct SingleBytes
{
	Byte byte3;
	Byte byte2;
	Byte byte1;
	Byte byte0;
} ;
#pragma pack(pop)

class DELPHICLASS EKeyError;
class PASCALIMPLEMENTATION EKeyError : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	/* Exception.Create */ __fastcall EKeyError(const System::AnsiString Msg) : Sysutils::Exception(Msg
		) { }
	/* Exception.CreateFmt */ __fastcall EKeyError(const System::AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	/* Exception.CreateRes */ __fastcall EKeyError(int Ident, Extended Dummy) : Sysutils::Exception(Ident
		, Dummy) { }
	/* Exception.CreateResFmt */ __fastcall EKeyError(int Ident, const System::TVarRec * Args, const int 
		Args_Size) : Sysutils::Exception(Ident, Args, Args_Size) { }
	/* Exception.CreateHelp */ __fastcall EKeyError(const System::AnsiString Msg, int AHelpContext) : Sysutils::
		Exception(Msg, AHelpContext) { }
	/* Exception.CreateFmtHelp */ __fastcall EKeyError(const System::AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext
		) { }
	/* Exception.CreateResHelp */ __fastcall EKeyError(int Ident, int AHelpContext) : Sysutils::Exception(
		Ident, AHelpContext) { }
	/* Exception.CreateResFmtHelp */ __fastcall EKeyError(int Ident, const System::TVarRec * Args, const 
		int Args_Size, int AHelpContext) : Sysutils::Exception(Ident, Args, Args_Size, AHelpContext) { }
	
public:
	/* TObject.Destroy */ __fastcall virtual ~EKeyError(void) { }
	
};

class DELPHICLASS EFileError;
class PASCALIMPLEMENTATION EFileError : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	/* Exception.Create */ __fastcall EFileError(const System::AnsiString Msg) : Sysutils::Exception(Msg
		) { }
	/* Exception.CreateFmt */ __fastcall EFileError(const System::AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	/* Exception.CreateRes */ __fastcall EFileError(int Ident, Extended Dummy) : Sysutils::Exception(Ident
		, Dummy) { }
	/* Exception.CreateResFmt */ __fastcall EFileError(int Ident, const System::TVarRec * Args, const int 
		Args_Size) : Sysutils::Exception(Ident, Args, Args_Size) { }
	/* Exception.CreateHelp */ __fastcall EFileError(const System::AnsiString Msg, int AHelpContext) : 
		Sysutils::Exception(Msg, AHelpContext) { }
	/* Exception.CreateFmtHelp */ __fastcall EFileError(const System::AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext
		) { }
	/* Exception.CreateResHelp */ __fastcall EFileError(int Ident, int AHelpContext) : Sysutils::Exception(
		Ident, AHelpContext) { }
	/* Exception.CreateResFmtHelp */ __fastcall EFileError(int Ident, const System::TVarRec * Args, const 
		int Args_Size, int AHelpContext) : Sysutils::Exception(Ident, Args, Args_Size, AHelpContext) { }
	
public:
	/* TObject.Destroy */ __fastcall virtual ~EFileError(void) { }
	
};

class DELPHICLASS EInputError;
class PASCALIMPLEMENTATION EInputError : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	/* Exception.Create */ __fastcall EInputError(const System::AnsiString Msg) : Sysutils::Exception(Msg
		) { }
	/* Exception.CreateFmt */ __fastcall EInputError(const System::AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	/* Exception.CreateRes */ __fastcall EInputError(int Ident, Extended Dummy) : Sysutils::Exception(Ident
		, Dummy) { }
	/* Exception.CreateResFmt */ __fastcall EInputError(int Ident, const System::TVarRec * Args, const 
		int Args_Size) : Sysutils::Exception(Ident, Args, Args_Size) { }
	/* Exception.CreateHelp */ __fastcall EInputError(const System::AnsiString Msg, int AHelpContext) : 
		Sysutils::Exception(Msg, AHelpContext) { }
	/* Exception.CreateFmtHelp */ __fastcall EInputError(const System::AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext
		) { }
	/* Exception.CreateResHelp */ __fastcall EInputError(int Ident, int AHelpContext) : Sysutils::Exception(
		Ident, AHelpContext) { }
	/* Exception.CreateResFmtHelp */ __fastcall EInputError(int Ident, const System::TVarRec * Args, const 
		int Args_Size, int AHelpContext) : Sysutils::Exception(Ident, Args, Args_Size, AHelpContext) { }
	
public:
	/* TObject.Destroy */ __fastcall virtual ~EInputError(void) { }
	
};

#pragma pack(push, 1)
struct DoublWord
{
	
	union
	{
		Byte fByte[4];
		SingleBytes w;
		int LWord;
		
	};
} ;
#pragma pack(pop)

typedef DoublWord *PDoublWord;

typedef Byte TBlock[8];

typedef TBlock *PBlock;

typedef int PArray[18];

typedef int SArray[4][256];

#pragma pack(push, 1)
struct Tblf_ctx
{
	bool KeyInit;
	bool IVInit;
	Byte IV[8];
	Byte ct[8];
	int S[4][256];
	int P[18];
	union
	{
		int LongBuffer[2];
		Byte ByteBuffer[8];
		
	};
} ;
#pragma pack(pop)

enum TCipherMode { ECB, CBC, CFB, OFB };

enum TStringMode { smEncode, smNormal };

class DELPHICLASS TBlowfish;
class PASCALIMPLEMENTATION TBlowfish : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	Tblf_ctx ctx;
	DoublWord *FPtrL;
	DoublWord *FPtrR;
	Byte FBuffer[4105];
	TBlock *PtrBuffer;
	TCipherMode FCipherMode;
	TStringMode FStringMode;
	void __fastcall Blowfish_Core_Key_Setup(const Byte * KeyArray, const int KeyArray_Size, const int KeyLength
		);
	void __fastcall Blowfish_Core_Block_Encrypt(void);
	void __fastcall Blowfish_Core_Block_Decrypt(void);
	void __fastcall EncryptBuffer(const int Len);
	void __fastcall DecryptBuffer(const int Len);
	void __fastcall EncryptBlockMode(void);
	void __fastcall DecryptBlockMode(void);
	void __fastcall DoRound(DoublWord &a, DoublWord &b, Byte n);
	void __fastcall InitArray(void);
	void __fastcall EncBlock(void);
	void __fastcall DecBlock(void);
	System::AnsiString __fastcall EncodeString(System::AnsiString InputString);
	System::AnsiString __fastcall DecodeString(System::AnsiString InputString);
	void __fastcall CheckKeys(void);
	void __fastcall NagRegister(void);
	
public:
	void __fastcall InitialiseString(const System::AnsiString Key);
	void __fastcall InitialiseByte(const Byte * Key, const int Key_Size, int Keylength);
	void __fastcall LoadIVString(const System::AnsiString IVString);
	void __fastcall LoadIVByte(const Byte * IVByte, const int IVByte_Size, int IVLength);
	void __fastcall EncryptBlock(const Byte * Input, Byte * Output);
	void __fastcall DecryptBlock(const Byte * Input, Byte * Output);
	void __fastcall EncryptFile(const System::AnsiString InputFileName, System::AnsiString OutputFileName
		);
	void __fastcall DecryptFile(const System::AnsiString InputFileName, System::AnsiString OutputFileName
		);
	void __fastcall EncryptStream(const Classes::TStream* Input, const Classes::TStream* Output);
	void __fastcall DecryptStream(const Classes::TStream* Input, const Classes::TStream* Output);
	void __fastcall EncryptString(const System::AnsiString Input, System::AnsiString &Output);
	void __fastcall DecryptString(const System::AnsiString Input, System::AnsiString &Output);
	void __fastcall CBCMACBlock(Byte * MAC);
	void __fastcall CBCMACString(System::AnsiString &MAC);
	void __fastcall Burn(void);
	System::AnsiString __fastcall GetVersion(void);
	
__published:
	__property TCipherMode CipherMode = {read=FCipherMode, write=FCipherMode, nodefault};
	__property TStringMode StringMode = {read=FStringMode, write=FStringMode, nodefault};
public:
	/* TComponent.Create */ __fastcall virtual TBlowfish(Classes::TComponent* AOwner) : Classes::TComponent(
		AOwner) { }
	/* TComponent.Destroy */ __fastcall virtual ~TBlowfish(void) { }
	
};

//-- var, const, procedure ---------------------------------------------------
#define BLOCKSIZE (Byte)(8)
#define BUFFERSIZE (Word)(4096)
extern PACKAGE void __fastcall Register(void);

}	/* namespace Blowfish */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Blowfish;
#endif
//-- end unit ----------------------------------------------------------------
#endif	// Blowfish
