-- =====================================================================
-- Table 'Description of state of TSearchDBGrid objects'
-- =====================================================================

Create table Sys_Grids (
Gr_App_Nam VarChar2(60)       NOT NULL,       -- Application name
Gr_Grd_Nam VarChar2(60)       NOT NULL,       -- State name
Gr_Grd_Cmt VarChar2(60)       NOT NULL,       -- Description
Gr_Grd_Srh VarChar2(2000),                    -- SearchList
Gr_Grd_Chs VarChar2(2000),                    -- ChoiceList
Gr_Grd_Bld VarChar2(2000),                    -- BuildList
Gr_Grd_Ord VarChar2(2000),                    -- OrderList
-- =====================================================================
CONSTRAINT gr_Grd_Name PRIMARY KEY (gr_App_Nam, gr_Grd_Nam, gr_Grd_Cmt)
);

-- =====================================================================
-- Table 'Description of the reports'
-- =====================================================================

Create table Sys_Report (
Re_App_Nam VarChar2(60)         NOT NULL,   -- Application name
Re_Grp_Nam VarChar2(60)         NOT NULL,   -- Report group name
Re_Rpt_Nam VarChar2(60)         NOT NULL,   -- Report name
Re_Rpt_Fmt Long,                            -- Text of the report template
Re_Rpt_Prv VarChar2(1),                     -- Sign of preview
Re_Rpt_Ori VarChar2(1),                     -- Orientation of the report
Re_Rpt_One VarChar2(1),                     -- Printing of one record
Re_Rpt_Prn VarChar2(60),                    -- Output file
-- =====================================================================
CONSTRAINT Re_Rpt_Name PRIMARY KEY (re_App_Nam, re_Grp_Nam, re_Rpt_Nam),
CONSTRAINT re_Rpt_Prn UNIQUE (re_Rpt_Prn),
CONSTRAINT re_Rpt_Ori
 CHECK (re_Rpt_Ori = 'L' or re_Rpt_Ori = 'P' or re_Rpt_Ori is null)
);
