//
// DirectXCCP 6.0, Copyright (C) 1998, Weston Software.  All Rights Reserved.
// See the documentation for specific license details.
//
#include "dxcpp.h"
#include "resource.h"
#include "spider.h"

extern CADirect3DRM *pD3D;

////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////
CASpider::CASpider( CADirect3DRM *pD3D, LPDIRECT3DRMFRAME pRef ) :
  CADirect3DRMFrame( pD3D, pRef )
{
  D3DRMLOADRESOURCE res = { NULL, NULL, "XOF" };
  
  m_iTick = 0;
  m_iTickLeft = 0;
  m_iTickRight = 0;

  // load the spider's body
	m_pMeshBuilder = new CADirect3DRMMeshBuilder( pD3D );
  res.lpName = MAKEINTRESOURCE( IDR_SPIDER );
  m_pMeshBuilder->Load( &res, NULL, D3DRMLOAD_FROMRESOURCE | D3DRMLOAD_FIRST, NULL, NULL);
  m_pMeshBuilder->Scale( D3DVAL(0.5), D3DVAL(0.5), D3DVAL(0.5));
	AddVisual( m_pMeshBuilder->I() );

  // load the spider's head
  m_pHead = new CADirect3DRMFrame( pD3D, NULL );
	CADirect3DRMMeshBuilder *pHeadMesh = new CADirect3DRMMeshBuilder( pD3D );
  res.lpName = MAKEINTRESOURCE( IDR_SPIDER1 );
  pHeadMesh->Load( &res, NULL, D3DRMLOAD_FROMRESOURCE | D3DRMLOAD_FIRST, NULL, NULL);
  pHeadMesh->Scale( D3DVAL(0.5), D3DVAL(0.5), D3DVAL(0.5));
  m_pHead->AddVisual( pHeadMesh->I() );
  AddVisual( m_pHead->I() );
  delete pHeadMesh;

  // load the spider's legs
  m_pLeftLeg = new CADirect3DRMFrame( pD3D, NULL );
	m_pMeshLeft = new CADirect3DRMMeshBuilder( pD3D );
  res.lpName = MAKEINTRESOURCE( IDR_SPIDER2 );
  m_pMeshLeft->Load( &res, NULL, D3DRMLOAD_FROMRESOURCE | D3DRMLOAD_FIRST, NULL, NULL);
  m_pMeshLeft->Scale( D3DVAL(0.5), D3DVAL(0.5), D3DVAL(0.5));
  m_pLeftLeg->AddVisual( m_pMeshLeft->I() );
  AddVisual( m_pLeftLeg->I() );

  m_pRightLeg = new CADirect3DRMFrame( pD3D, NULL );
	m_pMeshRight = new CADirect3DRMMeshBuilder( pD3D );
  res.lpName = MAKEINTRESOURCE( IDR_SPIDER3 );
  m_pMeshRight->Load( &res, NULL, D3DRMLOAD_FROMRESOURCE | D3DRMLOAD_FIRST, NULL, NULL);
  m_pMeshRight->Scale( D3DVAL(0.5), D3DVAL(0.5), D3DVAL(0.5));
  m_pRightLeg->AddVisual( m_pMeshRight->I() );
  AddVisual( m_pRightLeg->I() );

  // setup the spider's movement
  D3DRMANIMATIONOPTIONS opt = 
    D3DRMANIMATION_CLOSED | D3DRMANIMATION_SCALEANDROTATION;
  m_pAniHead = new CADirect3DRMAnimation( pD3D );
  m_pAniHead->SetOptions( opt );
  m_pAniHead->SetFrame( m_pHead->I() );

  // move the head
  D3DRMQUATERNION quat;
  D3DVECTOR vAxis = {0, 1, 0 };
  D3DRMQuaternionFromRotation( &quat, &vAxis, 0 );   
  m_pAniHead->AddRotateKey( 0, &quat );

  D3DRMQuaternionFromRotation( &quat, &vAxis, .25 );
  m_pAniHead->AddRotateKey( 100, &quat );

  D3DRMQuaternionFromRotation( &quat, &vAxis, -.25 );
  m_pAniHead->AddRotateKey( 200, &quat );

  D3DRMQuaternionFromRotation( &quat, &vAxis, 0 );   
  m_pAniHead->AddRotateKey( 300, &quat );

  D3DVECTOR vYAxis = { 0, 1, 0 };
  D3DVECTOR vZAxis = { 0, 0, 1 };

  // move the left leg
  m_pAniLeft = new CADirect3DRMAnimation( pD3D );
  m_pAniLeft->SetOptions( opt );
  m_pAniLeft->SetFrame( m_pLeftLeg->I() );

  D3DRMQuaternionFromRotation( &quat, &vYAxis, 0 );   
  m_pAniLeft->AddRotateKey( 0, &quat );

  D3DRMQuaternionFromRotation( &quat, &vYAxis, D3DVALUE(.16) );
  m_pAniLeft->AddRotateKey( 100, &quat );

  D3DRMQuaternionFromRotation( &quat, &vZAxis, D3DVALUE(.16) );
  m_pAniLeft->AddRotateKey( 150, &quat );

  D3DRMQuaternionFromRotation( &quat, &vYAxis, D3DVALUE(-.16) );
  m_pAniLeft->AddRotateKey( 200, &quat );

  D3DRMQuaternionFromRotation( &quat, &vYAxis, 0 );   
  m_pAniLeft->AddRotateKey( 300, &quat );

  // move the right leg
  m_pAniRight = new CADirect3DRMAnimation( pD3D );
  m_pAniRight->SetOptions( opt );
  m_pAniRight->SetFrame( m_pRightLeg->I() );

  D3DRMQuaternionFromRotation( &quat, &vYAxis, 0 );   
  m_pAniRight->AddRotateKey( 0, &quat );

  D3DRMQuaternionFromRotation( &quat, &vYAxis, D3DVALUE(-.16) );
  m_pAniRight->AddRotateKey( 100, &quat );

  D3DRMQuaternionFromRotation( &quat, &vZAxis, D3DVALUE(-.16) );
  m_pAniRight->AddRotateKey( 150, &quat );

  D3DRMQuaternionFromRotation( &quat, &vYAxis, D3DVALUE(.16) );
  m_pAniRight->AddRotateKey( 200, &quat );

  D3DRMQuaternionFromRotation( &quat, &vYAxis, 0 );   
  m_pAniRight->AddRotateKey( 300, &quat );
}

CASpider::~CASpider()
{
  delete m_pMeshBuilder;
  delete m_pMeshLeft;
  delete m_pMeshRight;
  delete m_pAniHead;  
  delete m_pAniLeft;
  delete m_pAniRight;

  delete m_pHead;  
  delete m_pLeftLeg;  
  delete m_pRightLeg;
}

void CASpider::Tick()
{
  m_pAniHead->SetTime( D3DVALUE( m_iTick = (m_iTick += 10) % 300 ));
  m_pAniLeft->SetTime( D3DVALUE( m_iTickLeft = (m_iTickLeft += 6) % 300 ));
  m_pAniRight->SetTime( D3DVALUE( m_iTickRight = (m_iTickRight += 6) % 300 ));
}

