#include "stdafx.h"
#include "pop3.h"


class CApp : public CWinApp
{
protected:
  virtual BOOL InitInstance();
};

CApp theApp;


BOOL CApp::InitInstance()
{
	//initialise sockets
	if (!AfxSocketInit())
  {
    TRACE(_T("Failed to initialise the Winsock stack\n"));
    return FALSE;
  }

	//try out the POP3 Client class
  CPop3Connection p3;

	//you should change the parameters to connect to the 
	//address, name and password for your own POP3 mailbox
	if (!p3.Connect(_T("mail.someisp.com"), _T("auser"), _T("apassword")))
  {
    DWORD dwError = GetLastError();
		CString sError = p3.GetLastCommandResponse();
    return FALSE;
  }

	if (!p3.Noop())
  {
    DWORD dwError = GetLastError();
		CString sError = p3.GetLastCommandResponse();
  }

	int nMails;
	int nSize;
  if (!p3.Statistics(nMails, nSize))
  {
    DWORD dwError = GetLastError();
		CString sError = p3.GetLastCommandResponse();
  }

  if (nMails)
  {
    CPop3Message message;
    DWORD dwSize;
    if (!p3.GetMessageSize(1, dwSize))
    {
      DWORD dwError = GetLastError();
			CString sError = p3.GetLastCommandResponse();
    }
    if (!p3.Retrieve(1, message))
    {
      DWORD dwError = GetLastError();
			CString sError = p3.GetLastCommandResponse();
    }
    else
    {
      CFile f;
      if (f.Open(_T("c:\\message.dat"), CFile::modeCreate | CFile::modeWrite | CFile::shareDenyWrite))
      {
        const char* pszMessage = message.GetMessageText();
        f.Write(pszMessage, strlen(pszMessage));
      }
      else
        TRACE(_T("Failed to write message to file\n"));
    }

    for (int i=1; i<=nMails; i++)
    {
      CString sID;
      if (!p3.GetMessageID(i, sID))
      {
        DWORD dwError = GetLastError();
  			CString sError = p3.GetLastCommandResponse();
      }
    }

    if (!p3.Delete(1))
    {
      DWORD dwError = GetLastError();
			CString sError = p3.GetLastCommandResponse();
    }

    if (p3.Delete(nMails+1))
    {    
      DWORD dwError = GetLastError();
			CString sError = p3.GetLastCommandResponse();
      TRACE(_T("Succeeded in deleting a non-existance message ???\n"));
    }

    if (!p3.Reset())
    {
      DWORD dwError = GetLastError();
			CString sError = p3.GetLastCommandResponse();
    }
  }
  else
    TRACE(_T("No mails at the PO\n"));


  if (!p3.Disconnect())
  {
    DWORD dwError = GetLastError();
		CString sError = p3.GetLastCommandResponse();
  }

	return FALSE;
}