/*
/--------------------------------------------------------------------
|
|   DOC.CPP    Document class implementation (where the bitmaps live)
|
|	Copyright (c) 1998 Bernard Delme
|
\--------------------------------------------------------------------
*/

#include "stdafx.h"
#include "piclook.h"
#include "doc.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPLViewerDoc

IMPLEMENT_DYNCREATE(CPLViewerDoc, CDocument)

BEGIN_MESSAGE_MAP(CPLViewerDoc, CDocument)
	//{{AFX_MSG_MAP(CPLViewerDoc)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPLViewerDoc construction/destruction

CPLViewerDoc::CPLViewerDoc()
{
	m_pDib = 0;
}

CPLViewerDoc::~CPLViewerDoc()
{
	DeleteContents();
}

BOOL CPLViewerDoc::OnOpenDocument(LPCTSTR lpszPathName)
{
    // recycle document
    DeleteContents();

	m_pDib = new CBmpClass;

    // have PaintLib perform I/O instead of Serialization
    BOOL bRet = TRUE;
	try {
#ifdef _IGNORES_PALETTE
		thisApp.GetDecoder()->MakeBmpFromFile(lpszPathName, m_pDib, 32);
#else
		thisApp.GetDecoder()->MakeBmpFromFile(lpszPathName, m_pDib);
#endif
	}
	catch (CTextException e)
	{
		AfxMessageBox(e);
	    DeleteContents();
	    bRet = FALSE;
	}

    if (bRet)
	{
		SetPathName(lpszPathName);
		SetModifiedFlag(FALSE);     // start off with unmodified
		char *cp = strrchr(lpszPathName,'\\');
		if (cp) // establish this image's directory as our new wd
		{
			*cp = '\0';
			SetCurrentDirectory(lpszPathName);
			// pretend we did not touch that string
			*cp = '\\';
		}
	}

    return bRet;		// Belgian resolution enhancement technology :-)
}

/*
BOOL CPLViewerDoc::OnSaveDocument( LPCTSTR lpszPathName )
{
	if (m_pDib)
	{
		m_pDib->SaveAsBmp(lpszPathName);
		return TRUE;
	}
	else
		return FALSE;
}
*/
//////////////////
// Delete contents of doc: delete the DIB
//
void CPLViewerDoc::DeleteContents()
{
	if (m_pDib) delete m_pDib;
	m_pDib = 0;
}

/////////////////////////////////////////////////////////////////////////////
// CPLViewerDoc diagnostics

#ifdef _DEBUG
void CPLViewerDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CPLViewerDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}

#endif //_DEBUG
