/*
/--------------------------------------------------------------------
|
|      DIBVFW.H         DrawDib windows bitmap class declaration
|
|      Copyright (c) 1998 Bernard Delme
|
|	See Paul DiLascia's excellent january and march 97 MSJ articles.
|	This version optionally draws using the 'video for windows' DrawDib API.
|	This is supposedly faster, and offers dithering, too.
|
\--------------------------------------------------------------------
*/

#ifndef INCL_DRAWDIB
#define INCL_DRAWDIB

#include "dibsect.h"

class CDrawDibBmp : public CDIBSection
{
protected:
	DECLARE_DYNAMIC(CDrawDibBmp)

public:
	CDrawDibBmp();
	virtual ~CDrawDibBmp();

	// Extended Draw function; can use DrawDib or not.
	BOOL DrawEx(CDC& dc, const CRect* rcDst=NULL, const CRect* rcSrc=NULL,
#ifndef _IGNORES_PALETTE
		BOOL bUseDrawDib=TRUE, CPalette* pPal=NULL, BOOL bForeground=FALSE);
#else
		BOOL bUseDrawDib=TRUE, CPalette* pPal=NULL, BOOL bForeground=TRUE);
#endif
	// default args fine
	virtual void Draw( CDC *pDC, int x, int y, DWORD rop = -1 )
		{ DrawEx( *pDC ); }
	
	virtual void StretchDraw( CDC *pDC, int x, int y, double Factor, DWORD = -1 );
	virtual BOOL DrawExtract( CDC* pDC, CPoint pntDest, CRect rcSrc );

private:
	HDRAWDIB m_hdd;		// for DrawDib API

#ifndef _IGNORES_PALETTE
	CPalette m_pal;		// logical palette

	BOOL CreatePalette(CPalette& pal);

public:
	void BuildLogPalette();
	CPalette* GetLogPalette();

#endif	// _IGNORES_PALETTE
};

#endif // INCL_DRAWDIB
