/////////////////////////////////////////////////////////////////////////////
// Copyright (C) 1998 by Jorge Lodos
// All rights reserved
//
// Distribute and use freely, except:
// 1. Don't alter or remove this notice.
// 2. Mark the changes you made
//
// Send bug reports, bug fixes, enhancements, requests, etc. to:
//    lodos@cigb.edu.cu
/////////////////////////////////////////////////////////////////////////////

//	adapted to paintlib by bdelmee@skynet.be, 1998

#ifndef INCL_DIBCTL
#define INCL_DIBCTL

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#ifdef _NO_DRAWDIB
#include "DibSect.h"
#else
#include "DibVfw.h"
#endif

/////////////////////////////////////////////////////////////////////////////
// CDIBStatic window

class CDIBStatic : public CStatic
{
// Construction
public:
	CDIBStatic() : m_bHasFile(FALSE)	{};
	virtual ~CDIBStatic()	{};

// Attributes
private:
#ifndef _NO_DRAWDIB
	CDrawDibBmp m_DIB;
#else
	CDIBSection	m_DIB;
#endif
	BOOL	m_bHasFile;

// Operations
public:
	BOOL IsValidDib() const { return m_bHasFile; }
	BOOL LoadDib(LPCTSTR lpszFileName);
	void UpdateDib();
	void RemoveDib();
	
	BOOL DoRealizePalette(BOOL bForceBackGround);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDIBStatic)
	//}}AFX_VIRTUAL

protected:
	void ClearDib();
	void PaintDib(BOOL bDibValid);

	// Generated message map functions
protected:
	//{{AFX_MSG(CDIBStatic)
	afx_msg HBRUSH CtlColor(CDC* pDC, UINT nCtlColor);
	afx_msg BOOL OnQueryNewPalette();
	afx_msg void OnPaletteChanged(CWnd* pFocusWnd);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // INCL_DIBCTL
