/*
/--------------------------------------------------------------------
|
|      RESSRC.CPP        Resource Data Source Class
|
|      This is a class which takes a windows resource as a source of
|      picture data.
|
|      Copyright (c) 1996-1998 Ulrich von Zadow
|
\--------------------------------------------------------------------
*/

#include "stdpch.h"

#include "ressrc.h"
#include "except.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNAMIC (CResourceSource, CDataSource);

CResourceSource::CResourceSource
    ()
{
  m_hRsrc = NULL;
  m_hGlobal = NULL;
}

CResourceSource::~CResourceSource
    ()
{
  if (m_hGlobal)
    Close();
}

int CResourceSource::Open
    ( int ResourceID,
      char * pResType
    )
{
  if (!pResType)
    m_hRsrc = FindResource (AfxGetInstanceHandle (),
                            MAKEINTRESOURCE (ResourceID),
                            RT_RCDATA);
   else
    m_hRsrc = FindResource (AfxGetInstanceHandle (),
                            MAKEINTRESOURCE (ResourceID),
                            pResType);

  if (!m_hRsrc)
  {
    char sz[256];
    sprintf (sz, "FindResource Failed (Code %i).\n", GetLastError());
    TRACE (sz);
    return ERR_FILE_NOT_FOUND;
  }

  m_hGlobal = LoadResource (AfxGetInstanceHandle(), m_hRsrc);
  if (!m_hGlobal)
  {
    char sz[256];
    sprintf (sz, "LoadResource Failed (Code %i).\n", GetLastError());
    TRACE (sz);
    return ERR_FILE_NOT_FOUND;
  }

  BYTE * pBuffer;
  pBuffer = (BYTE *)LockResource (m_hGlobal);
  if (!pBuffer)
  {
    TRACE ("LockResource failed.\n");
    return (ERR_FILE_NOT_FOUND);
  }
  int DataLen = ::SizeofResource (AfxGetInstanceHandle (), m_hRsrc);

  // We've got the resource mapped to memory
  char sz[256];
  sprintf (sz, "Resource: %i", ResourceID);
  CDataSource::Open (sz, pBuffer, DataLen);
  return 0;
}

void CResourceSource::Close
    ()
{
  UnlockResource(m_hGlobal);
  FreeResource(m_hGlobal);
  m_hGlobal = NULL;
}

