/*
/--------------------------------------------------------------------
|
|      GRITEM.H          Graphic item class
|
|      Abstract base class for an item on a canvas. Saves position
|      and size information as well as opacity of the item. The
|      actual draw method is implemented in derived classes.
|
|      Copyright (c) 1996-1998 Ulrich von Zadow
|
\--------------------------------------------------------------------
*/

#ifndef INCL_GRITEM
#define INCL_GRITEM

#include "bitmap.h"

class CGrItem : public CObject
{

DECLARE_DYNAMIC (CGrItem);

public:
  CGrItem
    ( int x,            // Position on the canvas
      int y,
      int w,            // Width
      int h,            // Height
      int z,            // Position in z-Order
      BYTE Opacity      // Opacity of the object. 255 is completely
                        // opaque, 0 is completely transparent.
    );
    // Create and initialize a GrItem.

  ~CGrItem
    ();

  virtual void Draw
    ( CBmp * pCanvas,
      CRect * pUpdateRect
    ) = 0;
    // Responsible for drawing the object on the canvas. Implemented
    // in a derived class.


  void GetRect
    ( CRect * pRect
    );
    // Returns dimensions as a rectangle.

  // Member variables.

  int    m_x, m_y;     // Position on the canvas
  int    m_w, m_h;     // Width & Height
  int    m_z;          // Position in z-Order
  BYTE   m_Opacity;    // Opacity of the object. 255 is completely
                       // opaque, 0 is completely transparent.

protected:
  void clip
    ( CBmp * pDestBmp,
      CRect * pUpdRect
    );
    // Clips pUpdRect to the current item and canvas.

};

#endif
