/*
/--------------------------------------------------------------------
|
|   VIEW.H    view class declaration
|
|	Copyright (c) 1998 Bernard Delme
|
\--------------------------------------------------------------------
*/

#ifndef INCL_VIEW
#define INCL_VIEW

class CPLView : public CScrollView
{
protected: // create from serialization only
    CPLView();
    DECLARE_DYNCREATE(CPLView)

// Attributes
public:
    CPLViewerDoc* GetDocument()
    {
		ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CPLViewerDoc)));
		return (CPLViewerDoc*) m_pDocument;
    }

// Operations
public:

// Implementation
public:
    virtual ~CPLView();
    virtual void OnDraw(CDC* pDC);  // overridden to draw this view

    virtual void OnInitialUpdate();
    virtual void OnActivateView(BOOL bActivate, CView* pActivateView,
				    CView* pDeactiveView);

	// Printing support
protected:
    virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
    BOOL m_bFit;	// whether to fit image to view
    BOOL m_bDither;	// whether to use palette dithering;

// Generated message map functions
protected:
    //{{AFX_MSG(CPLView)
    afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnSize(UINT nType, int cx, int cy);
    afx_msg LRESULT OnDoRealize(WPARAM wParam, LPARAM lParam);  // user message
    afx_msg void OnUpdateFitImage(CCmdUI* pCmdUI);
    afx_msg void OnFitImage();
    afx_msg void OnUpdateDither(CCmdUI* pCmdUI);
    afx_msg void OnDither();
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnCancelMode();
	afx_msg void OnEditCopy();
	//}}AFX_MSG
    DECLARE_MESSAGE_MAP()
};

#endif	// INCL_VIEW
