/////////////////////////////////////////////////////////////////////////////
// Copyright (C) 1998 by Jorge Lodos
// All rights reserved
//
// Distribute and use freely, except:
// 1. Don't alter or remove this notice.
// 2. Mark the changes you made
//
// Send bug reports, bug fixes, enhancements, requests, etc. to:
//    lodos@cigb.edu.cu
/////////////////////////////////////////////////////////////////////////////

/*
/--------------------------------------------------------------------
|
|	DIBCTL.CPP    graphic file preview in static control implementation
|
|	Adapted from Mr.Lodos's code in order to use PaintLib's
|	windows bitmap class and multi-format decoding
|
|	B.Delme 1998
|
\--------------------------------------------------------------------
*/

#include "stdafx.h"
#include "PicLook.h"
#include "DIBCtl.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDIBStatic

BEGIN_MESSAGE_MAP(CDIBStatic, CStatic)
	//{{AFX_MSG_MAP(CDIBStatic)
	ON_WM_CTLCOLOR_REFLECT()
	ON_WM_QUERYNEWPALETTE()
	ON_WM_PALETTECHANGED()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


BOOL CDIBStatic::LoadDib(LPCTSTR lpszFileName)
{
	try 
	{
		thisApp.GetDecoder()->MakeBmpFromFile(lpszFileName, &m_DIB);
		m_bHasFile = TRUE;
#ifndef _IGNORES_PALETTE
		// as we keep reusing the same bitmap, 
		// we need to refresh the palette for each new file
		m_DIB.BuildLogPalette();
#endif
	}
	catch (CTextException e)
	{
		//AfxMessageBox(e);
		TRACE0((LPCSTR) e );
		//m_DIB.freeMembers();
		m_bHasFile = FALSE;
	}
	UpdateDib();
	return m_bHasFile;
}

void CDIBStatic::ClearDib()
{
	ASSERT_VALID(this);
	
	CClientDC dc(this);
	CRect rectPaint;
	GetClientRect(&rectPaint);    
	rectPaint.InflateRect(-1,-1);
	    
	dc.FillSolidRect(&rectPaint, m_bHasFile ? 
		::GetSysColor(COLOR_3DFACE) :
		::GetSysColor(COLOR_3DSHADOW) );
//	ModifyStyle(m_bHasFile ? WS_BORDER : 0, m_bHasFile ? 0 : WS_BORDER);
}

void CDIBStatic::PaintDib(BOOL bDibValid)
{
	ASSERT_VALID(this);
	ClearDib();
		
	CRect PaintRect;
	GetClientRect(&PaintRect);    
	PaintRect.InflateRect(-1, -1);
	CClientDC dc(this);

	if (bDibValid)
	{
		int nDestX, nDestY;
		double stretchFactor = 1.0;
		if (m_DIB.GetWidth() > PaintRect.Width() || m_DIB.GetHeight() > PaintRect.Height())
		{ // The bitmap doesn't fit, scale to fit 
			double rx = (double) m_DIB.GetWidth() / PaintRect.Width();
			double ry = (double) m_DIB.GetHeight() / PaintRect.Height();
			stretchFactor = 1.0 / max( rx, ry );
		}

		nDestX = PaintRect.left + (PaintRect.Width() - int(stretchFactor * m_DIB.GetWidth())) / 2;
		nDestY = PaintRect.top + (PaintRect.Height() - int(stretchFactor * m_DIB.GetHeight())) / 2;
		m_DIB.StretchDraw( &dc, nDestX, nDestY, stretchFactor );
	}
}

void CDIBStatic::UpdateDib()
{
	ASSERT_VALID(this);
	PaintDib(IsValidDib());
}

/////////////////////////////////////////////////////////////////////////////
// CDIBStatic message handlers

HBRUSH CDIBStatic::CtlColor(CDC* pDC, UINT nCtlColor) 
{
	UpdateDib();

	// TODO: Return a non-NULL brush if the parent's handler should not be called
	return (HBRUSH)GetStockObject(NULL_BRUSH);
}

BOOL CDIBStatic::OnQueryNewPalette() 
{
#ifndef _IGNORES_PALETTE
	return DoRealizePalette(FALSE);
#else
	return FALSE;
#endif
}

void CDIBStatic::OnPaletteChanged(CWnd* pFocusWnd) 
{
	(void) DoRealizePalette(TRUE);
}

BOOL CDIBStatic::DoRealizePalette(BOOL bForceBackGround)
{
#ifdef _IGNORES_PALETTE
	return FALSE;
#else
	if (IsValidDib())
	{
		CPalette *pPal = m_DIB.GetLogPalette();
		if (pPal == NULL)
			return FALSE;

		CClientDC dc(this);
		CPalette *pOldPalette = dc.SelectPalette( pPal, bForceBackGround );
		UINT nChanged = dc.RealizePalette();
		dc.SelectPalette( pOldPalette, TRUE );

		if (nChanged == 0)	// no change to our mapping
			return FALSE;
		
		// some changes have been made; invalidate
		UpdateDib();
	}

	return TRUE;
#endif	// _IGNORES_PALETTE
}

void CDIBStatic::RemoveDib() 
{
	//m_DIB.Invalidate(); 
	//m_DIB.freeMembers();
	m_bHasFile = FALSE;
	UpdateDib(); 
}
