// MainDlg.cpp : implementation file
//

#include "stdafx.h"
#include "testdib.h"
#include "MainDlg.h"
#include "anydec.h"
#include "pictdec.h"
#include "dibgrit.h"
#include "shadow.h"
#include "drawhelp.h"
#include "anybmp.h"
#include "except.h"
#include "dibsect.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Worker thread to load the pics.

UINT FadePic
    ( LPVOID pParam
    )
{
  CDibtestDlg * pDlg = (CDibtestDlg *) pParam;

  pDlg->DoWork();

  return 0;
}


/////////////////////////////////////////////////////////////////////////////
// CDibtestDlg dialog

CDibtestDlg::CDibtestDlg
    ( char * pszDirName
    )
	: CDialog(CDibtestDlg::IDD, NULL)
{
	//{{AFX_DATA_INIT(CDibtestDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

  m_pBigBmp = new CWinBmp ();
  m_pBmp = new CDIBSection ();

  InitializeCriticalSection(&m_Critical);
  m_pDIBWnd = new CMTDIBWnd (m_pBmp, &m_Critical);

  m_sDirName = pszDirName;
  if (m_sDirName.Right(1) != '\\')
    m_sDirName += '\\';

  m_x = 0;
  m_y = 0;
}
            
CDibtestDlg::~CDibtestDlg
    ()
{
  delete m_pDIBWnd;

  delete m_pBmp;
  delete m_pBigBmp;

  DeleteCriticalSection(&m_Critical);
}

void CDibtestDlg::DoWork
    ()
{

  CAnyPicDecoder Decoder;
  CGrItemArray DIBArray;
  int i,j;
  CRect OldRect, NewRect;

  Decoder.SetTraceConfig (2, NULL); //"C:\\paintlib.log");

  createBkGrnd (&Decoder);
  m_pDIBWnd->InvalidateRect (NULL);
  m_pDIBWnd->UpdateWindow ();

  testResource ();

  // Load the files
  loadRes (&Decoder, &DIBArray, IDR_LOGO1);
  loadRes (&Decoder, &DIBArray, IDR_LOGO);

  CDIBGrItem * pAmmonitItem = ((CDIBGrItem*)DIBArray.GetItem(0));
  CDIBGrItem * pParserItem = ((CDIBGrItem*)DIBArray.GetItem(1));

  SetDlgItemText (IDS_FNAME, "Blt without alpha channel.");
  for (i=0; i<100; i++)
  {
    update (&DIBArray, &OldRect, &NewRect);

    // Move
    pAmmonitItem->m_x += 1;
    pAmmonitItem->m_y += 1;
    pParserItem->m_x -=1;
  }

  RGBAPIXEL ShadowColor;
  SetRGBAPixel (&ShadowColor, 0x80, 0x80, 0xFF, 0x00);

  CShadowItem * pShadow;
  pShadow = new CShadowItem (200, 100,
                             400, 200,
                             1, 64,
                             &ShadowColor, NULL);
  DIBArray.AddItem (pShadow);

  // Set alpha channel
  setAlphaChannel (&DIBArray);

  SetDlgItemText (IDS_FNAME, "Blt with alpha channel.");
  pParserItem->m_Opacity = 50;

  for (i=0; i<100; i++)
  {
    update (&DIBArray, &OldRect, &NewRect);

    // Move
    pAmmonitItem->m_x += 1;
    pAmmonitItem->m_y -= 1;
    pAmmonitItem->m_Opacity -=2;

    pParserItem->m_x -=1;
    pParserItem->m_Opacity += 2;
  }

  SetDlgItemText (IDS_FNAME, "Blt with size changes.");

  for (j=0; j<DIBArray.GetSize(); j++)
  {
    CDIBGrItem * pItem = ((CDIBGrItem*)DIBArray.GetItem(j));
    pItem->m_w /= 2;
    pItem->m_h /= 2;
  }
  pAmmonitItem->m_Opacity = 255;
  pParserItem->m_Opacity = 255;

  // Remove shadow.
  DIBArray.RemoveAt (2);
  delete pShadow->m_pAlphaBmp;
  delete pShadow;

  for (i=0; i<79; i++)
  {
    update (&DIBArray, &OldRect, &NewRect);

    // Move
    pAmmonitItem->m_x += 1;
    pAmmonitItem->m_w -= 2;
    if (i & 1)
      pAmmonitItem->m_h -= 1;
     else
      pAmmonitItem->m_h -= 2;
    pAmmonitItem->m_Opacity -= 3;

    pParserItem->m_x -= 1;
    pParserItem->m_w += 3;
    pParserItem->m_h += 1;
  }

  // Delete all the bitmaps.
  for (i=0; i<2; i++)
  {
    CBmp * pBmp = ((CDIBGrItem *)DIBArray.GetItem(i))->GetBmp();
    delete (pBmp);
  }

  SetDlgItemText (IDS_FNAME, "Test finished.");

}


void CDibtestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDibtestDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP

}

BEGIN_MESSAGE_MAP(CDibtestDlg, CDialog)
	//{{AFX_MSG_MAP(CDibtestDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDibtestDlg message handlers

BOOL CDibtestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

  CRect Rect;

  // Resize bitmap window so it fills the frame.
  CWnd * pWnd = GetDlgItem(IDS_BMPFRAME);
  if (pWnd)
  {
    pWnd->GetWindowRect(Rect);
    ScreenToClient (Rect);
    Rect.InflateRect (-2, -2);
    m_pDIBWnd->MoveWindow (Rect, TRUE);
  }

  // Create DIBs as canvas.
  int Width = Rect.right-Rect.left;
  int Height = Rect.bottom-Rect.top;

  m_pBigBmp->Create (Width, Height, 32, FALSE);
  m_pBmp->Create (Width, Height, 32, FALSE);

  AfxBeginThread (FadePic, (LPVOID) this);
  m_pDIBWnd->NewDIBNotify();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CDibtestDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDibtestDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

int CDibtestDlg::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CDialog::OnCreate(lpCreateStruct) == -1)
		return -1;

  m_pDIBWnd->Create (NULL, "DIBWnd", 0, CRect (0,0,10,10),
                      this, 2001);

	return 0;
}


/////////////////////////////////////////////////////////////////////
// CDibtestDlg locals


void CDibtestDlg::loadFile
    ( CPicDecoder * pDecoder,
      CGrItemArray * pDIBArray,
      const char * pszFName
    )
    // Tries to load a file. Does error checking.
{
  CString s ("Datei: ");
  CDIBGrItem * pDIBItem;

  s += pszFName;
  SetDlgItemText (IDS_FNAME, s);

  try
  {
    CWinBmp * pNewBmp = new CWinBmp();
    pDecoder->MakeBmpFromFile (pszFName, pNewBmp);

    pDIBItem = new CDIBGrItem (m_x, m_y, //161, 121,
                               pNewBmp->GetWidth(),
                               pNewBmp->GetHeight(),
                               1,
                               255,
                               pNewBmp);
    m_x += 480;
    m_y += 130;
    pDIBArray->AddItem (pDIBItem);
  }
  catch (CTextException e)
  {
    char sz[256];
    TRACE ("Error decoding %s: %s", pszFName, (const char *)e);
    sprintf (sz, "Error: %s", (const char *)e);
    MessageBox (sz);
  }
  catch (CMemoryException e)
  {
    TRACE ("Error decoding %s: Out of memory.\n", pszFName);
  }
}


void CDibtestDlg::loadRes
    ( CPicDecoder * pDecoder,
      CGrItemArray * pDIBArray,
      int ResourceID
    )
    // Tries to load a resource. Does error checking.
{
  char sz[256];
  CDIBGrItem * pDIBItem;

  sprintf (sz, "Resource: ID %i", ResourceID);
  SetDlgItemText (IDS_FNAME, sz);

  try
  {
    CWinBmp * pNewBmp = new CWinBmp();
    pDecoder->MakeBmpFromResource (ResourceID, pNewBmp);

    pDIBItem = new CDIBGrItem (m_x, m_y, //161, 121,
                               pNewBmp->GetWidth(),
                               pNewBmp->GetHeight(),
                               1,
                               255,
                               pNewBmp);
    m_x += 480;
    m_y += 130;
    pDIBArray->AddItem (pDIBItem);
  }
  catch (CTextException e)
  {
    char sz[256];
    TRACE ("Error decoding resource %x: %s", ResourceID, (const char *)e);
    sprintf (sz, "Error: %s", (const char *)e);
    MessageBox (sz);
  }
  catch (CMemoryException e)
  {
    TRACE ("Error decoding resource %x: Out of memory.\n", ResourceID);
  }
}


void CDibtestDlg::createBkGrnd
    ( CPicDecoder * pDecoder
    )
{
  CWinBmp * pTileBmp = new CWinBmp();
  try
  {
    pDecoder->MakeBmpFromResource (IDR_CANVAS, pTileBmp);
  }
  catch (CTextException e)
  {
    char sz[256];
    TRACE ("Error decoding ID_CANVAS: %s", (const char *)e);
    sprintf (sz, "Error: %s", (const char *)e);
    MessageBox (sz);
  }
  catch (CMemoryException e)
  {
    TRACE ("Error decoding ID_CANVAS: Out of memory.\n");
  }

  int w = pTileBmp->GetWidth();
  int h = pTileBmp->GetHeight();
  int xmult = m_pBmp->GetWidth()/w;
  int ymult = m_pBmp->GetHeight()/h;
  CRect DestRect;

  EnterCriticalSection (&m_Critical);
  for (int x=0; x<=xmult; x++)
    for (int y=0; y<=ymult; y++)
    {
      DestRect = CRect (x*w, y*h, (x+1)*w, (y+1)*h);
      DrawOnBmp (m_pBmp, &DestRect, pTileBmp, 255);
    }
  m_pBigBmp->CreateCopy (*m_pBmp);
  LeaveCriticalSection (&m_Critical);

  delete pTileBmp;
}                                                                  

void CDibtestDlg::setAlphaChannel
    ( CGrItemArray * pDIBArray
    )
{
  CPictDecoder AlphaDecoder (NULL);
  CAnyBmp * pAlphaBmp = new CAnyBmp();

  AlphaDecoder.MakeBmpFromResource (IDR_LOGOALPH, pAlphaBmp, 8);

  for (int j=0; j<2; j++)
  {
    CDIBGrItem * pItem = ((CDIBGrItem*)pDIBArray->GetItem(j));
    pItem->GetBmp()->SetAlphaChannel (pAlphaBmp);
  }

  CShadowItem * pShadow;
  pShadow = (CShadowItem *)pDIBArray->GetItem(2);
  pShadow->m_pAlphaBmp = pAlphaBmp;
  pShadow->m_pLineArray = pAlphaBmp->GetLineArray();
  pShadow->m_w = pAlphaBmp->GetWidth();
  pShadow->m_h = pAlphaBmp->GetHeight();
}


void CDibtestDlg::update
    ( CGrItemArray * pDIBArray,
      CRect * pOldRect,
      CRect * pNewRect
    )
{
  CRect UpdateRect;
  CDIBGrItem CanvasItem (0, 0,
                         m_pBigBmp->GetWidth(), m_pBigBmp->GetHeight(),
                         0, 255, m_pBigBmp);

  // Calculate update rectangle.
  *pOldRect = *pNewRect;
  pDIBArray->GetRect (pNewRect);
  UpdateRect.UnionRect (pOldRect, pNewRect);

  // Draw
  EnterCriticalSection (&m_Critical);
  CanvasItem.Draw (m_pBmp, &UpdateRect);
  pDIBArray->Draw (m_pBmp, &UpdateRect);
  LeaveCriticalSection (&m_Critical);

  m_pDIBWnd->InvalidateRect (&UpdateRect);
  m_pDIBWnd->UpdateWindow ();
}


void CDibtestDlg::testResource
    ()
{
  CWinBmp TestBmp;

  TestBmp.CreateRes (IDB_TEST3);
  TestBmp.CreateRes (IDB_TEST4);
  TestBmp.CreateRes (IDB_TEST8);
}