// MainDlg.cpp : implementation file
//

#include "stdafx.h"
#include "testdec.h"
#include "MainDlg.h"
#include "anydec.h"
#include "except.h"
#include "dibsect.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////
// Worker thread to load the pics.

UINT FadePic
    ( LPVOID pParam
    )
{
  CDibtestDlg * pDlg = (CDibtestDlg *) pParam;

  pDlg->DoWork();

  return 0;
}


/////////////////////////////////////////////////////////////////////
// CDibtestDlg dialog

CDibtestDlg::CDibtestDlg
    ( char * pszDirName
    )
	: CDialog(CDibtestDlg::IDD, NULL)
{
	//{{AFX_DATA_INIT(CDibtestDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

  m_pBmp = new CDIBSection();
  m_pBigBmp = new CWinBmp();

  InitializeCriticalSection(&m_Critical);
  m_pDIBWnd = new CMTDIBWnd (m_pBmp, &m_Critical);

  m_sDirName = pszDirName;
  if (m_sDirName.Right(1) != '\\')
    m_sDirName += '\\';
}

CDibtestDlg::~CDibtestDlg
    ()
{
  delete m_pDIBWnd;

  delete m_pBmp;
  delete m_pBigBmp;

  delete m_pThreadCritical;

  DeleteCriticalSection(&m_Critical);
}

void CDibtestDlg::DoWork
    ()
{

  //---------------------- CBmp tests. ---------------------------

  CAnyPicDecoder Decoder;
  Decoder.SetTraceConfig (2, NULL);  //"c:\paintlib.log");

  m_bStopDecoding = FALSE;

  m_pThreadCritical = new CCriticalSection ();
  m_pThreadCritical->Lock();

  // This can be used if a specific file should be tested:
//  displayFile (&Decoder, "d:\\prog\\paintlib\\testpic\\kaputt\\trunct.jpg");
  displayDir (&Decoder, m_sDirName);
  if (!m_bStopDecoding)
    SetDlgItemText (IDS_FNAME, "Test beendet.");

  m_pThreadCritical->Unlock ();

//  Only 8 and 32 bpp work in the current version!

//  doBmpTest (98, 98, 1, IDB_TEST3);

//  doBmpTest (99, 99, 4, IDB_TEST4);
//  doBmpTest (101, 101, 16, 0);
//  doBmpTest (102, 102, 24, 0);

  doBmpTest (100, 100, 8, IDB_TEST8);
  doBmpTest (101, 101, 8, 0);
  doBmpTest (103, 103, 32, 0);

}


void CDibtestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDibtestDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP

}                                        

BEGIN_MESSAGE_MAP(CDibtestDlg, CDialog)
	//{{AFX_MSG_MAP(CDibtestDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_CREATE()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////
// CDibtestDlg message handlers

BOOL CDibtestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

  CRect Rect;

  // Resize bitmap window so it fills the frame.
  CWnd * pWnd = GetDlgItem(IDS_BMPFRAME);
  if (pWnd)
  {
    pWnd->GetWindowRect(Rect);
    ScreenToClient (Rect);
    Rect.InflateRect (-2, -2);
    m_pDIBWnd->MoveWindow (Rect, TRUE);
  }

  // Create DIBs as canvas.
  int Width = Rect.right-Rect.left;
  int Height = Rect.bottom-Rect.top;

  m_pBigBmp->Create (Width, Height, 32, FALSE);
  m_pBmp->Create (Width, Height, 32, FALSE);

  m_pThread = AfxBeginThread (FadePic, (LPVOID) this);
  m_pDIBWnd->NewDIBNotify();

	return TRUE;  // return TRUE  unless you set the focus to a control
}


void CDibtestDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CDibtestDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

int CDibtestDlg::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CDialog::OnCreate(lpCreateStruct) == -1)
		return -1;

  m_pDIBWnd->Create (NULL, "DIBWnd", 0, CRect (0,0,10,10),
                      this, 2001);

	return 0;
}


/////////////////////////////////////////////////////////////////////
// CDibtestDlg locals

void CDibtestDlg::displayDir
    ( CPicDecoder * pDecoder,
      const char * pszDirName
    )
    // Tries to display all files in a directory and its
    // subdirectories.
{
  WIN32_FIND_DATA FindData;
  HANDLE hSearch;
  BOOL bOK;
  char sz[256];

  TRACE ("Searching directory %s.\n", pszDirName);

  displayFilesInDir (pDecoder, pszDirName, "*.bmp");
  displayFilesInDir (pDecoder, pszDirName, "*.eps");
  displayFilesInDir (pDecoder, pszDirName, "*.jpg");
  displayFilesInDir (pDecoder, pszDirName, "*.pct");
  displayFilesInDir (pDecoder, pszDirName, "*.png");
  displayFilesInDir (pDecoder, pszDirName, "*.tga");
  displayFilesInDir (pDecoder, pszDirName, "*.tif");
  
  // Recurse directories

  sprintf (sz, "%s*.*", pszDirName);
  hSearch = FindFirstFile (sz, &FindData);
  bOK = (hSearch != INVALID_HANDLE_VALUE);
  while (bOK)
  {
    if (FindData.cFileName[0] != '.' &&
        (FindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
    {
      sprintf (sz, "%s%s\\", pszDirName, FindData.cFileName);
      displayDir (pDecoder, sz);
    }
    if (m_bStopDecoding)
      return;
    bOK = FindNextFile (hSearch, &FindData);
  }
  FindClose (hSearch);

}

void CDibtestDlg::displayFilesInDir
    ( CPicDecoder * pDecoder,
      const char * pszDirName,
      const char * pszFName
    )
    // Tries to display all files in a directory matching
    // the specified file name.
{
  WIN32_FIND_DATA FindData;
  HANDLE hSearch;
  BOOL bOK;
  char sz[256];

  sprintf (sz, "%s%s", pszDirName, pszFName);

  hSearch = FindFirstFile (sz, &FindData);
  bOK = (hSearch != INVALID_HANDLE_VALUE);
  while (bOK)
  {         
    if (FindData.cFileName[0] != '.' &&
        !(FindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
    {
      sprintf (sz, "%s%s", pszDirName, FindData.cFileName);
      displayFile (pDecoder, sz);
    }
    if (m_bStopDecoding)
      return;
    bOK = FindNextFile (hSearch, &FindData);
  }
  FindClose (hSearch);
}

void CDibtestDlg::displayFile
    ( CPicDecoder * pDecoder,
      char * pszFName
    )
    // Tries to load a file & display it. Does error checking.
{
  CWinBmp NewBmp;

  try
  {
    pDecoder->MakeBmpFromFile (pszFName, &NewBmp);
    if (m_bStopDecoding)
      return;
    EnterCriticalSection (&m_Critical);
    m_pBmp->CreateCopy (*m_pBigBmp, 32);
    CDIBSection TestBmp;
    TestBmp.CreateCopy (NewBmp, 32);
    m_pBmp->AlphaBlt (&TestBmp, 0, 0); 

    LeaveCriticalSection (&m_Critical);

    m_pDIBWnd->NewDIBNotify ();
    m_pDIBWnd->UpdateWindow ();

    CString s ("Datei: ");
    s += pszFName;
    SetDlgItemText (IDS_FNAME, s);
  }
  catch (CTextException e)
  {
    char sz[1024];
    sprintf (sz, "Error decoding %s: %s", pszFName, (const char *)e);
    CPicDecoder::Trace (1, sz);

  }
  catch (CMemoryException e)
  {
    TRACE ("Error decoding %s: Out of memory.\n", pszFName);
  }
}


void CDibtestDlg::doBmpTest
    ( int Width,
      int Height,
      int bpp,
      int ID
    )
    // Tests the bitmap class used for defects by calling its methods
    // with one type of bitmap.
{
  // Create empty
  EnterCriticalSection (&m_Critical);
  m_pBmp->Create (Width, Height, bpp, FALSE);
  LeaveCriticalSection (&m_Critical);

  m_pDIBWnd->NewDIBNotify ();
  m_pDIBWnd->UpdateWindow ();

  // Load from resource
  if (ID)
    m_pBigBmp->CreateRes (ID);
   else
    m_pBigBmp->Create (Width, Height, bpp, FALSE);

  // Assignment
  EnterCriticalSection (&m_Critical);
  m_pBmp->CreateCopy (*m_pBigBmp);
  LeaveCriticalSection (&m_Critical);

  m_pDIBWnd->NewDIBNotify ();
  m_pDIBWnd->UpdateWindow ();

  // Put in clipboard
  m_pBmp->ToClipBoard(); 

  // Save to disk
  m_pBmp->SaveAsBmp("c:\\test.bmp");

  // CDIBSection tests
  HANDLE hBmp = m_pBmp->GetHandle();
  BITMAPINFOHEADER * pBMI = m_pBmp->GetBMI();
  m_pBmp->Detach();
  DeleteObject (hBmp);
  delete pBMI;
  
}

void CDibtestDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
  m_bStopDecoding = TRUE;

  // Wait for the decoder thread to terminate.
  m_pThreadCritical->Lock (5000);  
}
