/*
/--------------------------------------------------------------------
|
|   DOC.H    Document class declaration
|
|	Copyright (c) 1998 Bernard Delme
|
\--------------------------------------------------------------------
*/

#ifndef INCL_DOCUMENT
#define INCL_DOCUMENT

#include "dibvfw.h"			// DrawDib windows bitmap

#ifdef _NO_DRAWDIB
#	define CBmpClass CWinBmp
#else
#	define CBmpClass CDrawDibBmp
#endif

class CPLViewerDoc : public CDocument
{
protected: // create from serialization only
	CPLViewerDoc();
	DECLARE_DYNCREATE(CPLViewerDoc)

// Attributes
public:
	CSize GetDocSize()
	    { return m_pDib->GetSize(); }
#ifndef _IGNORES_PALETTE
	CPalette* GetDocPalette()
	    { return m_pDib->GetLogPalette(); }
#endif

// Operations
public:
	virtual void DeleteContents();
	CBmpClass *GetDib() { return m_pDib; }

// Implementation
protected:
	virtual ~CPLViewerDoc();
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);

protected:
	CBmpClass *m_pDib;

#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif


// virtual BOOL OnSaveDocument( LPCTSTR lpszPathName );

// Generated message map functions
protected:
	//{{AFX_MSG(CPLViewerDoc)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#endif	// INCL_DOCUMENT
