/*
/--------------------------------------------------------------------
|
|	DIBVFW.CPP	PaintLib windows DrawDib bitmap class implementation
|
|      Copyright (c) 1998 Bernard Delme
|
\--------------------------------------------------------------------
*/

#include "stdafx.h"
#include "DibVfw.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

IMPLEMENT_DYNAMIC(CDrawDibBmp, CDIBSection);

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CDrawDibBmp::CDrawDibBmp()
{
	m_hdd = NULL;
}

CDrawDibBmp::~CDrawDibBmp()
{
	if (m_hdd)
	{
		DrawDibClose(m_hdd);
		m_hdd = NULL;
	}
}

//////////////////////////////////////////////////////////////////////
// Draw DIB on caller's DC. Does stretching from source to destination
// rectangles. Generally, you can let the following default to zero/NULL:
//
//		bUseDrawDib = whether to use use DrawDib, default TRUE
//		pPal	      = palette, default=NULL, (use DIB's palette)
//		bForeground = realize in foreground (default FALSE)
//
// If you are handling palette messages, you should use bForeground=FALSE,
// since you will realize the foreground palette in WM_QUERYNEWPALETTE.
//
BOOL CDrawDibBmp::DrawEx(CDC& dc, const CRect* rcDst, const CRect* rcSrc,
	BOOL bUseDrawDib, CPalette* pPal, BOOL bForeground)
{
	ASSERT(GetHandle());
	if (! GetHandle())
		return FALSE;

#ifndef _IGNORES_PALETTE
	// Select, realize palette
	if (pPal==NULL)				// no palette specified:
		pPal = GetLogPalette();		// use default
	CPalette* pOldPal = dc.SelectPalette(pPal, !bForeground);
	dc.RealizePalette();
#endif
	// Compute rectangles where NULL specified
	if (!rcSrc) 
	{	// if no source rect, use whole bitmap
		CRect rc = CRect(CPoint(0,0), GetSize());
		rcSrc = &rc;
	}
	if (!rcDst) // if no destination rect, use source
		rcDst = rcSrc;

	BOOL bRet = FALSE;
	if (bUseDrawDib)
	{
		if (!m_hdd)	VERIFY(m_hdd = DrawDibOpen());

		// Let DrawDib do the work!
		bRet = DrawDibDraw(m_hdd, dc,
			rcDst->left, rcDst->top, rcDst->Width(), rcDst->Height(),
			m_pBMI,
			m_pBits,
			rcSrc->left, rcSrc->top, rcSrc->Width(), rcSrc->Height(),
#ifndef _IGNORES_PALETTE
			bForeground ? 0 : DDF_BACKGROUNDPAL);
#else
			DDF_HALFTONE);
#endif
	}
	else	    // use normal draw function
	{
		::StretchDIBits(dc.GetSafeHdc(),
				rcDst->left,		// Destination x
				rcDst->top,		// Destination y
				rcDst->Width(),	// Destination width
				rcDst->Height(),	// Destination height
				rcSrc->left,		// Source x
				rcSrc->top,		// Source y
				rcSrc->Width(),	// Source width
				rcSrc->Height(),	// Source height
				m_pBits,			// Pointer to bits
				(BITMAPINFO *) m_pBMI,	// BITMAPINFO
				DIB_RGB_COLORS,	// Options
				SRCCOPY);			// Raster operator code
	}

#ifndef _IGNORES_PALETTE
	if (pOldPal)
		dc.SelectPalette(pOldPal, TRUE);
#endif
	return bRet;
}

// play with the elastic bitmap...
void CDrawDibBmp::StretchDraw( CDC *pDC, int x, int y, double Factor, DWORD )
{
	// Compute rectangles
	CSize bmSize = GetSize();
	CRect rcSrc(0,0,bmSize.cx,bmSize.cy);
	CRect rcDst(x,y,x+int(Factor * bmSize.cx),y+int(Factor * bmSize.cy));
	(void) DrawEx( *pDC, &rcDst, &rcSrc );
}

// Draw part of the DIB on a DC.
// *untested* yet...
BOOL CDrawDibBmp::DrawExtract( CDC* pDC, CPoint pntDest, CRect rcSrc )
{
	// Compute rectangle
	CRect rcDst(pntDest,rcSrc.Size());
	return DrawEx( *pDC, &rcDst, &rcSrc );
}

// all code below related to colormap management
#ifndef _IGNORES_PALETTE

#define PALVERSION 0x300	// magic number for LOGPALETTE

const int	MAXPALCOLORS = 256;

//////////////////
// Create the palette. Use halftone palette for hi-color bitmaps.
//
BOOL CDrawDibBmp::CreatePalette(CPalette& pal)
{
	// should not already have palette
	ASSERT(pal.m_hObject==NULL);

	BOOL bRet = FALSE;
	if (m_pClrTab)
	{
		RGBQUAD* colors = new RGBQUAD[MAXPALCOLORS];
		UINT nColors = GetNumColors();	// 256, really...
		// Allocate memory for logical palette 
		int len = sizeof(LOGPALETTE) + sizeof(PALETTEENTRY) * nColors;
		LOGPALETTE* pLogPal = (LOGPALETTE*)new char[len];
		if (!pLogPal)
		{
			delete [] colors;
			return FALSE;
		}

		// set version and number of palette entries
		pLogPal->palVersion = PALVERSION;
		pLogPal->palNumEntries = nColors;

		// copy color entries 
		for (UINT i = 0; i < nColors; i++)
		{
			BYTE * pb = (BYTE *) (m_pClrTab+i);
			pLogPal->palPalEntry[i].peRed   = pb[RGBA_RED  ];
			pLogPal->palPalEntry[i].peGreen = pb[RGBA_GREEN];
			pLogPal->palPalEntry[i].peBlue  = pb[RGBA_BLUE ];
			pLogPal->palPalEntry[i].peFlags = 0;
		}

		// create the palette and destroy LOGPAL
		bRet = pal.CreatePalette(pLogPal);
		delete [] colors;
		delete [] (char*)pLogPal;
	}
	else
	{
		// If the file itself did not contain a colormap, we will use 
		// a default palette and rely on DrawDib's halftoning.
		// When displaying higher-color images on 8bpp hardware,
		// this is suboptimal though. Ideally we should build the 
		// palette according to an histogram of the actual RGB values.
		// "SeeDib" from MS Source Code Samples does that nicely
		CWindowDC dcScreen(NULL);
		bRet = pal.CreateHalftonePalette(&dcScreen);
	}
	return bRet;
}

// this is implicitly done the first time one calls GetLogPalette
// e.g. in DrawEx(); but one needs to call it when recycling a
// bitmap with a new contents (e.g. decoding a second file)
void CDrawDibBmp::BuildLogPalette(void)
{
	if (m_pal.m_hObject)
		m_pal.DeleteObject();
	
	CreatePalette(m_pal);
}


CPalette* CDrawDibBmp::GetLogPalette(void)
{
	// build the palette the 1st time we're asked to provide it
	if (HPALETTE(m_pal) == NULL)
		// the bitmap has hopefully been populated (by a decoder),
		// we can associate it with a logical palette
		CreatePalette(m_pal);
	return &m_pal;
}

#endif	// _IGNORES_PALETTE
