#include "stdafx.h"
#include "testpipe.h"
#include "testpipeDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CTestpipeDlg::CTestpipeDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTestpipeDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTestpipeDlg)
	m_sServer = _T("");
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CTestpipeDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTestpipeDlg)
	DDX_Text(pDX, IDC_SERVER, m_sServer);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTestpipeDlg, CDialog)
	//{{AFX_MSG_MAP(CTestpipeDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_GETTIME, OnGettime)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BOOL CTestpipeDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CTestpipeDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CTestpipeDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CTestpipeDlg::OnGettime() 
{
  CWaitCursor wc;

  UpdateData();
	CNamedPipe clientPipe;

  if (!CNamedPipe::ServerAvailable(m_sServer, _T("TEST_PJTIME"), 1000))
  {
    AfxMessageBox(_T("instance of the specified named pipe is not available to be connected to"));
    return;
  }

  SYSTEMTIME st;
  ZeroMemory(&st, sizeof(SYSTEMTIME));


  //Connect to the server using Create and a Read call
  ///*
  if (!clientPipe.Open(m_sServer, _T("TEST_PJTIME"), GENERIC_READ | FILE_SHARE_READ, 0, NULL, 0))
  {
    AfxMessageBox(_T("Failed to connect to the specified named pipe"));
    return;
  }

#ifdef _DEBUG
  afxDump << clientPipe;
  clientPipe.AssertValid();
#endif

  DWORD dwBytesWritten;
  if (!clientPipe.Read(&st, sizeof(SYSTEMTIME), dwBytesWritten, NULL))
  {
    AfxMessageBox(_T("Failed in call to read from the specified named pipe"));
    return;
  }
  //*/


  ////Connect to the server using the Call function
  /*
  DWORD dwBytesRead;
  if (!CNamedPipe::Call(m_sServer, _T("TEST_PJTIME"), NULL, 0, &st, sizeof(SYSTEMTIME), dwBytesRead, 5000))
  {
    AfxMessageBox(_T("Failed during connection to the server"));
    return;
  }
  */

  //Update the values on the UI
  TCHAR sTime[256];
  GetTimeFormat(LOCALE_USER_DEFAULT, LOCALE_NOUSEROVERRIDE, &st, NULL, sTime, 256);
  GetDlgItem(IDC_TIME)->SetWindowText(sTime);

  TCHAR sDate[256];
  GetDateFormat(LOCALE_USER_DEFAULT, LOCALE_NOUSEROVERRIDE, &st, NULL, sDate, 256);
  GetDlgItem(IDC_DATE)->SetWindowText(sDate);


  //Close the pipe once were finished with it
  if (!clientPipe.Close())
  {
    AfxMessageBox(_T("Failed in call to close the specified named pipe"));
    return;
  }


}
