unit MChatLnk;

interface

uses
  Wintypes, Winprocs, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, NBLib32;

type
  TForm1 = class(TForm)
    Label2: TLabel;
    LabelStatus: TLabel;
    Label4: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label5: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    RecMemo: TMemo;
    SendMemo: TMemo;
    ButtonExit: TButton;
    ButtonStart: TButton;
    ButtonStop: TButton;
    LANGroupBox: TGroupBox;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    WANGroupBox: TGroupBox;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    TimerBlink: TTimer;
    NBLink1: TNBLink;
    Label1: TLabel;
    HowToConnect: TRadioGroup;
    BoxCallName: TComboBox;
    BoxOurName: TComboBox;
    procedure MemoClear;
    procedure MemoEnabled;
    procedure MemoDisabled;
    procedure StartBlink(S: String);
    procedure StopBlink;
    procedure FormCreate(Sender: TObject);
    procedure ButtonStartClick(Sender: TObject);
    procedure ButtonStopClick(Sender: TObject);
    procedure ButtonExitClick(Sender: TObject);
    procedure TimerBlinkTimer(Sender: TObject);
    procedure NBLink1Open(Sender: TObject; RetCode: Byte);
    procedure NBLink1Connect(Sender: TObject; RetCode: Byte);
    procedure NBLink1Break(Sender: TObject; RetCode: Byte);
    procedure NBLink1HangUp(Sender: TObject; RetCode: Byte);
    procedure NBLink1Close(Sender: TObject; RetCode: Byte);
    procedure NBLink1ReceivePing(Sender: TObject; Size: Word;
      Data: Pointer; RetCode: Byte);
    procedure NBLink1SendPing(Sender: TObject; RetCode: Byte);
    procedure NBLink1SendData(Sender: TObject; RetCode: Byte);
    procedure NBLink1ReceiveData(Sender: TObject; Size: Word; Data: Pointer;
      RetCode: Byte);
    procedure SendMemoKeyPress(Sender: TObject; var Key: Char);
    procedure HowToConnectClick(Sender: TObject);
    procedure NBLink1Error(Sender: TObject; Operation: TNBOperation; Lana,
      ErrorCode: Byte);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

const
  MaxData = MaxSessionData;

type
  PBuffer = ^TBuffer;
  TBuffer = array[0..MaxData - 1] of Char;

var
  Form1: TForm1;

  CharBuffer: PBuffer;
  CountChar: Integer;
  CountInBytes: Integer;
  CountOutBytes: Integer;
  CountInPackets: Integer;
  CountOutPackets: Integer;
  CountInPings: Integer;
  CountOutPings: Integer;
  SavedCallName: String;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  New(CharBuffer);
  CheckBox1.Enabled := nbNetBEUI in NBLink1.SupportedTransportsLAN;
  CheckBox1.Checked := CheckBox1.Enabled;
  CheckBox2.Enabled := nbOverIPX in NBLink1.SupportedTransportsLAN;
  CheckBox2.Checked := CheckBox2.Enabled;
  CheckBox3.Enabled := nbOverTCP in NBLink1.SupportedTransportsLAN;
  CheckBox3.Checked := CheckBox3.Enabled;
  CheckBox4.Enabled := nbNetBEUI in NBLink1.SupportedTransportsWAN;
  CheckBox4.Checked := CheckBox4.Enabled;
  CheckBox5.Enabled := nbOverIPX in NBLink1.SupportedTransportsWAN;
  CheckBox5.Checked := CheckBox5.Enabled;
  CheckBox6.Enabled := nbOverTCP in NBLink1.SupportedTransportsWAN;
  CheckBox6.Checked := CheckBox6.Enabled;
  MemoClear;
  MemoDisabled;
  BoxCallName.ItemIndex := 2;
  BoxOurName.ItemIndex := 3;
end;

procedure TForm1.MemoClear;
begin
  RecMemo.Clear;
  SendMemo.Clear;
  SendMemo.Enabled := False;
  CountChar := 0;
  CountInBytes := 0;
  CountOutBytes := 0;
  CountInPackets := 0;
  CountOutPackets := 0;
  CountInPings := 0;
  CountOutPings := 0;
  Label4.Caption := IntToStr(CountInBytes);
  Label5.Caption := IntToStr(CountOutBytes);
  Label7.Caption := IntToStr(CountInPackets);
  Label10.Caption := IntToStr(CountOutPackets);
  Label12.Caption := IntToStr(CountInPings);
  Label14.Caption := IntToStr(CountOutPings);
end;

procedure TForm1.MemoEnabled;
begin
  RecMemo.Color := clWindow;
  SendMemo.Color := clWindow;
  SendMemo.Enabled := True;
  SendMemo.SetFocus;
end;

procedure TForm1.MemoDisabled;
begin
  RecMemo.Color := clBtnFace;
  SendMemo.Color := clBtnFace;
  RecMemo.Enabled := False;
  SendMemo.Enabled := False;
end;

procedure TForm1.StartBlink(S: String);
begin
  TimerBlink.Enabled := True;
  LabelStatus.Caption := S;
  LabelStatus.Visible := True;
end;

procedure TForm1.StopBlink;
begin
  TimerBlink.Enabled := False;
  LabelStatus.Visible := True;
end;

procedure TForm1.TimerBlinkTimer(Sender: TObject);
begin
  with LabelStatus do Visible := not Visible;
end;

procedure TForm1.ButtonStartClick(Sender: TObject);
var
  TransportsLAN: TTransports;
  TransportsWAN: TTransports;
begin
  TransportsLAN := [];
  TransportsWAN := [];
  if CheckBox1.Checked then Include(TransportsLAN, nbNetBEUI);
  if CheckBox2.Checked then Include(TransportsLAN, nbOverIPX);
  if CheckBox3.Checked then Include(TransportsLAN, nbOverTCP);
  if CheckBox4.Checked then Include(TransportsWAN, nbNetBEUI);
  if CheckBox5.Checked then Include(TransportsWAN, nbOverIPX);
  if CheckBox6.Checked then Include(TransportsWAN, nbOverTCP);
  NBLink1.TransportsLAN := TransportsLAN;
  NBLink1.TransportsWAN := TransportsWAN;
  SavedCallName := BoxCallName.Text;
  NBLink1.OurName := BoxOurName.Text;
  NBLink1.Open(anForce);
  if csOpening in NBLink1.NBComponentState then
  begin
    StartBlink('Open...');
    LANGroupBox.Enabled := False;
    WANGroupBox.Enabled := False;
    BoxCallName.Enabled := False;
    BoxOurName.Enabled := False;
    HowToConnect.Enabled := False;
    ButtonStart.Enabled := False;
  end;
end;

procedure TForm1.ButtonStopClick(Sender: TObject);
begin
  ButtonStop.Enabled := False;
  StartBlink('HangUp...');
  NBLink1.HangUp;
end;

procedure TForm1.ButtonExitClick(Sender: TObject);
begin
  Close;
end;

procedure TForm1.NBLink1Open(Sender: TObject; RetCode: Byte);
begin
  if RetCode = NRC_GOODRET then
  begin
    ButtonStop.Enabled := Enabled;
    TNBLink(Sender).CallName := SavedCallName;
    TNBLink(Sender).Connect(THowConnect(HowToConnect.ItemIndex));
    if HowToConnect.ItemIndex = 0
      then StartBlink('Call...')
      else StartBlink('Listen...')
  end else
  begin
    Beep;
    StopBlink;
    LabelStatus.Caption := 'Not Connection';
    BoxCallName.Enabled := True;
    BoxOurName.Enabled := True;
    HowToConnect.Enabled := True;
    ButtonStart.Enabled := True;
    ButtonStop.Enabled := False;
    LANGroupBox.Enabled := True;
    WANGroupBox.Enabled := True;
    Application.MessageBox('Error Open!', 'Error', MB_ICONSTOP);
  end;
end;

procedure TForm1.NBLink1Connect(Sender: TObject; RetCode: Byte);
begin
  if RetCode = NRC_GOODRET then
  begin
    StopBlink;
    Beep;
    MemoClear;
    MemoEnabled;
    LabelStatus.Caption := 'Connected (' + TNBLink(Sender).NameProtocolConnected + ')';
    BoxCallName.Text := TNBLink(Sender).CallName;
    TNBLink(Sender).Receive(MaxData);
  end else
  begin
    TNBLink(Sender).CallName := SavedCallName;
    TNBLink(Sender).Connect(THowConnect(HowToConnect.ItemIndex));
  end;
end;

procedure TForm1.NBLink1Break(Sender: TObject; RetCode: Byte);
begin
  Beep;
  MemoDisabled;
  BoxCallName.Text := SavedCallName;
  TNBLink(Sender).CallName := SavedCallName;
  TNBLink(Sender).Connect(THowConnect(HowToConnect.ItemIndex));
  if HowToConnect.ItemIndex = 0
    then StartBlink('Call...')
    else StartBlink('Listen...')
end;

procedure TForm1.NBLink1HangUp(Sender: TObject; RetCode: Byte);
begin
  StartBlink('Close...');
  TNBLink(Sender).Close;
end;

procedure TForm1.NBLink1Close(Sender: TObject; RetCode: Byte);
begin
  StopBlink;
  LabelStatus.Caption := 'Not Connection';
  MemoDisabled;
  BoxCallName.Enabled := True;
  BoxOurName.Enabled := True;
  HowToConnect.Enabled := True;
  ButtonStart.Enabled := True;
  LANGroupBox.Enabled := True;
  WANGroupBox.Enabled := True;
  BoxCallName.Text := SavedCallName;
end;

procedure TForm1.NBLink1SendData(Sender: TObject; RetCode: Byte);
begin
  with TNBLink(Sender) do
  case RetCode of
    NRC_GOODRET:
    begin
      Inc(CountOutBytes, SendSize + SecondSendSize);
      Label5.Caption := IntToStr(CountOutBytes);
      Inc(CountOutPackets);
      Label10.Caption := IntToStr(CountOutPackets);
      if CountChar > 0 then
      begin
        Send(CountChar, CharBuffer);
        CountChar := 0;
      end;
    end;
    NRC_CMDTMO:
    begin
      Send(SendSize, nil);
    end;
  end;
end;

procedure TForm1.NBLink1SendPing(Sender: TObject; RetCode: Byte);
begin
  if RetCode = NRC_GOODRET then
  begin
    Inc(CountOutPings);
    Label14.Caption := IntToStr(CountOutPings);
  end;
end;

procedure TForm1.NBLink1ReceiveData(Sender: TObject; Size: Word; Data: Pointer;
  RetCode: Byte);
var
  I: Integer;
begin
  with TNBLink(Sender) do
  case RetCode of
    NRC_GOODRET,
    NRC_INCOMP:
    begin
      Inc(CountInBytes, Size);
      Label4.Caption := IntToStr(CountInBytes);
      Inc(CountInPackets);
      Label7.Caption := IntToStr(CountInPackets);
      RecMemo.Lines.BeginUpdate;
      for I := 0 to Size - 1 do
        RecMemo.Perform(WM_CHAR, Ord(TBuffer(Data^)[I]), 0);
      RecMemo.Lines.EndUpdate;
      Receive(MaxData);
    end;
    NRC_CMDTMO:
    begin
      Receive(ReceiveSize);
    end;
  end;
end;

procedure TForm1.NBLink1ReceivePing(Sender: TObject; Size: Word;
  Data: Pointer; RetCode: Byte);
begin
  if RetCode = NRC_GOODRET then
  begin
    Inc(CountInPings);
    Label12.Caption := IntToStr(CountInPings);
  end;
end;

procedure TForm1.SendMemoKeyPress(Sender: TObject; var Key: Char);
begin
  if csConnected in NBLink1.NBComponentState then
  if CountChar < MaxData then
  begin
    CharBuffer[CountChar] := Key;
    Inc(CountChar);
  end;
  if (csConnected in NBLink1.NBComponentState) and
    not (csSending in NBLink1.NBComponentState) then
  begin
    NBLink1.Send(CountChar, CharBuffer);
    CountChar := 0;
  end;
end;

procedure TForm1.HowToConnectClick(Sender: TObject);
begin
  if HowToConnect.ItemIndex = 0 then
  begin
    BoxCallName.ItemIndex := 2;
    BoxOurName.ItemIndex := 3;
  end else
  begin
    BoxCallName.ItemIndex := 4;
    BoxOurName.ItemIndex := 2;
  end;
end;

procedure TForm1.NBLink1Error(Sender: TObject; Operation: TNBOperation;
  Lana, ErrorCode: Byte);
begin
  // Here can write in ErrorLog file
end;

end.
