unit MChatDtg;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, NBLib32;

type
  TForm1 = class(TForm)
    ButtonExit: TButton;
    ButtonOpen: TButton;
    ButtonClose: TButton;
    ButtonReset: TButton;
    ButtonLocalNames: TButton;
    ButtonMACAddress: TButton;
    RecMemo: TMemo;
    SendMemo: TMemo;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    LabelWait: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label5: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    ComboBoxLana: TComboBox;
    TypeOfExchange: TRadioGroup;
    TimerBlink: TTimer;
    NBDatagram1: TNBDatagram;
    ErrorMemo: TMemo;
    CheckBox1: TCheckBox;
    BoxCallName: TComboBox;
    BoxOurName: TComboBox;
    procedure ButtonExitClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ButtonOpenClick(Sender: TObject);
    procedure ButtonResetClick(Sender: TObject);
    procedure ButtonCloseClick(Sender: TObject);
    procedure NBDatagram1Open(Sender: TObject; RetCode: Byte);
    procedure NBDatagram1Close(Sender: TObject; RetCode: Byte);
    procedure SendMemoKeyPress(Sender: TObject; var Key: Char);
    procedure BoxCallNameChange(Sender: TObject);
    procedure MemoClear;
    procedure MemoEnabled;
    procedure MemoDisabled;
    procedure StartBlink(S: String);
    procedure StopBlink;
    procedure TimerBlinkTimer(Sender: TObject);
    procedure NBDatagram1Error(Sender: TObject; Operation: TNBOperation;
      Lana, ErrorCode: Byte);
    procedure NBDatagram1ReceiveData(Sender: TObject; Size: Word;
      Data: Pointer; RetCode: Byte);
    procedure ComboBoxLanaChange(Sender: TObject);
    procedure ButtonLocalNamesClick(Sender: TObject);
    procedure ButtonMACAddressClick(Sender: TObject);
    function GetValueLana: Byte;
    procedure ErrorMemoDblClick(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure NBDatagram1SendData(Sender: TObject; RetCode: Byte);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

const
  MaxData = MaxDatagramData;

type
  PBuffer = ^TBuffer;
  TBuffer = array[0..MaxData - 1] of Char;

var
  Form1: TForm1;

  LanaList: PLanaList;

  CharBuffer: PBuffer;
  OutBuffer: PBuffer;
  InBuffer: PBuffer;

  CountChar: Integer;
  CountInBytes: Integer;
  CountOutBytes: Integer;
  CountInPackets: Integer;
  CountOutPackets: Integer;

  FormHeight: Integer;

implementation

uses Names;

{$R *.DFM}

procedure TForm1.MemoClear;
begin
  RecMemo.Clear;
  SendMemo.Clear;
  SendMemo.Enabled := False;
  CountChar := 0;
  CountInBytes := 0;
  CountOutBytes := 0;
  CountInPackets := 0;
  CountOutPackets := 0;
  Label4.Caption := IntToStr(CountInBytes);
  Label5.Caption := IntToStr(CountOutBytes);
  Label7.Caption := IntToStr(CountInPackets);
  Label10.Caption := IntToStr(CountOutPackets);
end;

procedure TForm1.MemoEnabled;
begin
  RecMemo.Color := clWindow;
  SendMemo.Color := clWindow;
  SendMemo.Enabled := True;
  SendMemo.SetFocus;
  CheckBox1.Enabled := False;
end;

procedure TForm1.MemoDisabled;
begin
  RecMemo.Color := clBtnFace;
  SendMemo.Color := clBtnFace;
  RecMemo.Enabled := False;
  SendMemo.Enabled := False;
  CheckBox1.Enabled := True;
end;

procedure TForm1.StartBlink(S: String);
begin
  TimerBlink.Enabled := True;
  LabelWait.Caption := S;
  LabelWait.Visible := True;
end;

procedure TForm1.StopBlink;
begin
  TimerBlink.Enabled := False;
  LabelWait.Visible := False;
end;

procedure TForm1.TimerBlinkTimer(Sender: TObject);
begin
  with LabelWait do Visible := not Visible;
end;

procedure TForm1.ComboBoxLanaChange(Sender: TObject);
begin
  ButtonOpen.Enabled := False;
end;

procedure TForm1.ButtonExitClick(Sender: TObject);
begin
  Close;
end;

function TForm1.GetValueLana: Byte;
begin
  if ComboBoxLana.ItemIndex > -1
    then Result := Byte(ComboBoxLana.Items.Objects[ComboBoxLana.ItemIndex])
    else Result := StrToInt(ComboBoxLana.Text);
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  if CheckBox1.Checked then
  begin
    NBDatagram1.ExtSendBuffer := nil;
    NBDatagram1.ExtReceiveBuffer := nil;
  end else
  begin
    NBDatagram1.ExtSendBuffer := OutBuffer;
    NBDatagram1.ExtReceiveBuffer := InBuffer;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  I: Integer;
  S: String;
begin
  FormHeight := Form1.Height;

  New(LanaList);
  New(CharBuffer);
  New(OutBuffer);
  New(InBuffer);

  NBDatagram1.ExtSendBuffer := OutBuffer;
  NBDatagram1.ExtReceiveBuffer := InBuffer;

  GetLanaList(LanaList);
  with ComboBoxLana do
  begin
    Items.BeginUpdate;
    Items.Clear;
    for I := 0 to LanaList.length - 1 do
    begin
      S := IntToStr(LanaList.lana[I].lana_num) + ' - ';
      case LanaList.lana[I].NBProtocol of
        nbNetBEUI: S := S + 'NetBEUI (';
        nbOverIPX: S := S + 'Nb over IPX (';
        else       S := S + 'Nb over TCP (';
      end;
      case LanaList.lana[I].Adapter of
        taLAN:  S := S + 'LAN)';
        taWAN:  S := S + 'WAN)';
      end;
      Items.AddObject(S, Pointer(LanaList.lana[I].lana_num));
    end;
    ItemIndex := 0;
    Items.EndUpdate;
  end;
  Dispose(LanaList);

  BoxCallName.ItemIndex := 1;
  BoxOurName.ItemIndex := 0;

  MemoClear;
  MemoDisabled;
end;

procedure TForm1.ButtonResetClick(Sender: TObject);
var
  RCReset: Byte;
  LanaNum: Byte;
begin
  LanaNum := GetValueLana;
  RCReset := ResetLana(LanaNum, 0, 0, lrAlloc);
  if RCReset = NRC_GOODRET then
  begin
    NBDatagram1.LanaNumber := LanaNum;
    ButtonOpen.Enabled := True;
    BoxCallName.Enabled := True;
    BoxOurName.Enabled := True;
    MemoClear;
    MemoDisabled;
  end else
  begin
    Beep;
    ShowMessage('Error ResetLana! RetCode = $' + IntToHex(RCReset, 2) +
      ' - ' + GetErrorString(RCReset)+'.');
  end;
end;

procedure TForm1.ButtonOpenClick(Sender: TObject);
var
  RCOpen: Byte;
begin
  NBDatagram1.LanaNumber := GetValueLana;
  NBDatagram1.CallName := BoxCallName.Text;
  NBDatagram1.OurName := BoxOurName.Text;
  RCOpen := NBDatagram1.Open(anForce);
  case RCOpen of
    NRC_GOODRET,
    NRC_PENDING:
     begin
       BoxOurName.Enabled := False;
       ButtonOpen.Enabled := False;
       ButtonReset.Enabled := False;
       ComboBoxLana.Enabled := False;
       StartBlink('Open...');
     end;
     NRC_NCBBUSY:
      begin
        Beep;
        ShowMessage('The previous command is not completed.');
      end;
   else
      ShowMessage('Start Open Error = $'  + IntToHex(RCOpen, 2) + ' - '+
        GetErrorString(RCOpen) + '.');
   end;
end;

procedure TForm1.ButtonCloseClick(Sender: TObject);
var
  RCClose: Byte;
begin
  RCClose := NBDatagram1.Close;
  case RCClose of
    NRC_GOODRET,
    NRC_PENDING:
      begin
        MemoDisabled;
        ButtonClose.Enabled := False;
        StartBlink('Close...');
      end;
    NRC_NCBBUSY:
     begin
       Beep;
       ShowMessage('The previous command is not completed.');
     end;
   else ShowMessage('Start Close Error = $'  + IntToHex(RCClose, 2) + ' - '+
     GetErrorString(RCClose) + '.');
  end;
end;

procedure TForm1.SendMemoKeyPress(Sender: TObject; var Key: Char);
begin
  if CountChar < MaxData then
  begin
    CharBuffer[CountChar] := Key;
    Inc(CountChar);
  end;
  with NBDatagram1 do
  if not (csSending in NBComponentState) then
  begin
    case TypeOfExchange.ItemIndex of
      0: Send(CountChar, CharBuffer);
      1: SendBroadcast(CountChar, CharBuffer);
    end;
    CountChar := 0;
  end;
end;

procedure TForm1.BoxCallNameChange(Sender: TObject);
begin
  NBDatagram1.CallName := BoxCallName.Text;
end;

procedure TForm1.NBDatagram1Open(Sender: TObject; RetCode: Byte);
begin
  StopBlink;
  Beep;
  if RetCode = NRC_GOODRET then
  begin
    with TNBDatagram(Sender) do
    begin
      case TypeOfExchange.ItemIndex of
        0: Receive(MaxData);
        1: ReceiveBroadcast(MaxData);
      end;
    end;
    TypeOfExchange.Enabled := False;
    ButtonReset.Enabled := False;
    ComboBoxLana.Enabled := False;
    ButtonClose.Enabled := True;
    MemoClear;
    MemoEnabled;
  end else
  begin
    BoxOurName.Enabled := True;
    ButtonOpen.Enabled := True;
    ButtonReset.Enabled := True;
    ComboBoxLana.Enabled := True;
  end;
end;

procedure TForm1.NBDatagram1SendData(Sender: TObject; RetCode: Byte);
begin
  if RetCode = NRC_GOODRET then
  begin
    with Sender as TNBDatagram do
    begin
      Inc(CountOutBytes, SendSize);
      Label5.Caption := IntToStr(CountOutBytes);
      Inc(CountOutPackets);
      Label10.Caption := IntToStr(CountOutPackets);
      if CountChar > 0 then
      begin
        case TypeOfExchange.ItemIndex of
          0: Send(CountChar, CharBuffer);
          1: SendBroadcast(CountChar, CharBuffer);
        end;
        CountChar := 0;
      end;
    end;
  end;
end;

procedure TForm1.NBDatagram1ReceiveData(Sender: TObject; Size: Word;
  Data: Pointer; RetCode: Byte);
var
  I: Integer;
begin
  if RetCode = NRC_GOODRET then
  begin
    Inc(CountInBytes, Size);
    Label4.Caption := IntToStr(CountInBytes);
    Inc(CountInPackets);
    Label7.Caption := IntToStr(CountInPackets);
    RecMemo.Lines.BeginUpdate;
    for I := 0 to Size - 1 do
      RecMemo.Perform(WM_CHAR, Ord(TBuffer(Data^)[I]), 0);
    RecMemo.Lines.EndUpdate;
    with Sender as TNBDatagram do
    case TypeOfExchange.ItemIndex of
      0: Receive(MaxData);
      1: ReceiveBroadcast(MaxData);
    end;
  end;
end;

procedure TForm1.NBDatagram1Close(Sender: TObject; RetCode: Byte);
begin
  StopBlink;
  Beep;
  MemoDisabled;
  ButtonOpen.Enabled := True;
  ButtonReset.Enabled := True;
  ComboBoxLana.Enabled := True;
  BoxOurName.Enabled := True;
  TypeOfExchange.Enabled := True;
end;

procedure TForm1.NBDatagram1Error(Sender: TObject; Operation: TNBOperation;
  Lana, ErrorCode: Byte);
var
  S: String;
begin
  Beep;
  case Operation of
    opOpen:    S := 'Open';
    opClose:   S := 'Close';
    opSend:    S := 'Send';
    opReceive: S := 'Receive';
  end;

  S := S + ' Error! ErrorCode = $' + IntToHex(ErrorCode, 2) + ' - '+
        GetErrorString(ErrorCode) + '.';

  with ErrorMemo do
  begin
    if not Visible then
    begin
      Form1.Height := FormHeight + 100;
      Top := FormHeight - 20;
      Height := 85;
      Left := 8;
      Width := 400;
      ScrollBars := ssVertical;
      Clear;
      Visible := True;
    end;
    while Lines.Count > 100 do
      Lines.Delete(0);
    Lines.Add(S);
  end;
end;

procedure TForm1.ErrorMemoDblClick(Sender: TObject);
begin
  ErrorMemo.Visible := False;
  Form1.Height := FormHeight;
end;

procedure TForm1.ButtonLocalNamesClick(Sender: TObject);
var
  LanaNum: Byte;
  RCNames: Byte;
begin
  LanaNum := GetValueLana;
  RCNames := GetLocalNames(LanaNum, Form2.Memo1.Lines);
  if RCNames = NRC_GOODRET then
  begin
    Form2.Caption := 'Local Names (Lana ' + IntToStr(LanaNum) + ')';
    Form2.Top := Form1.Top + 130;
    Form2.Left := Form1.Left + 30;
    Form2.Show;
  end else
  begin
    Form2.Close;
    Beep;
    ShowMessage('Error GetLocalNames! RetCode = $' + IntToHex(RCNames, 2) +
      ' - '+ GetErrorString(RCNames)+'.');
  end;
end;

procedure TForm1.ButtonMACAddressClick(Sender: TObject);
var
  LanaNum: Byte;
  RCAddress: Byte;
  MACAddress: TMACAddress;
begin
  LanaNum := GetValueLana;
  RCAddress := GetMACAddress(LanaNum, @MACAddress);
  if RCAddress = NRC_GOODRET then
  begin
    Form2.Memo1.Clear;
    Form2.Memo1.Lines.Add(Format('%2.2x-%2.2x-%2.2x-%2.2x-%2.2x-%2.2x',
       [ord(MACAddress[0]),
        ord(MACAddress[1]),
        ord(MACAddress[2]),
        ord(MACAddress[3]),
        ord(MACAddress[4]),
        ord(MACAddress[5])]));
    Form2.Caption := 'MAC Address (Lana ' + IntToStr(LanaNum) + ')';
    Form2.Top := Form1.Top + 130;
    Form2.Left := Form1.Left + 30;
    Form2.Show;
  end else
  begin
    Form2.Close;
    Beep;
    ShowMessage('Error GetMACAddress! RetCode = $' + IntToHex(RCAddress, 2) +
      ' - '+ GetErrorString(RCAddress)+'.');
  end;
end;


end.
