unit MChat;

interface

uses
  Wintypes, Winprocs, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, NBLib16;

type
  PBuffer = ^TBuffer;
  TBuffer = array[0..MaxSessionData - 1] of Char;

type
  TChatForm = class(TForm)
    RecMemo: TMemo;
    SendMemo: TMemo;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure SendMemoKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    { Public declarations }
    ChatLink: TNBLink;
    CountChar: Integer;
    CharBuffer: PBuffer;
  end;

const
  MaxData = MaxSessionData;
  
implementation

{$R *.DFM}

procedure TChatForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  ChatLink.HangUp;
  Dispose(CharBuffer);
end;

procedure TChatForm.FormCreate(Sender: TObject);
begin
  New(CharBuffer);
  RecMemo.Clear;
  SendMemo.Clear;
end;

procedure TChatForm.SendMemoKeyPress(Sender: TObject; var Key: Char);
begin
  if CountChar < MaxData then
  begin
    CharBuffer^[CountChar] := Key;
    Inc(CountChar);
  end;
  if (csConnected in ChatLink.NBComponentState) and
     not (csSending in ChatLink.NBComponentState) then
  begin
    ChatLink.Send(CountChar, CharBuffer);
    CountChar := 0;
  end;
end;

end.
