//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#include <stdlib.h>
#pragma hdrstop

#include "MTrans.h"
//---------------------------------------------------------------------------
#pragma link "NBLib32"
#pragma resource "*.dfm"
TForm1 *Form1;

#define MaxData MaxSessionData
struct THeaderFile
{
    ShortString FileName;
    int FileSize;
};
THeaderFile HeaderFile;

AnsiString
  Src,
  Dst,
  TempPath,
  TempFileName,
  SavedCallName;

TStream
  *SendStream,
  *ReceiveStream;

int
  FrameSize = MaxData,
  SendCounter,
  ReceiveCounter,
  SendFileSize,
  ReceiveFileSize,
  SendDivider,
  ReceiveDivider;

BOOL FileWait;

Pointer Data;

//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::UpDown1Click(TObject *Sender, TUDBtnType Button)
{
  FrameSize = UpDown1->Position * 512;
  if (FrameSize > MAXWORD) {FrameSize = MAXWORD;}
  Edit1->Text = IntToStr(FrameSize);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::StartBlink(AnsiString S)
{
  TimerBlink->Enabled = True;
  LabelStatus->Caption = S;
  LabelStatus->Visible = True;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::TimerBlinkTimer(TObject *Sender)
{
  LabelStatus->Visible = ! LabelStatus->Visible;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::StopBlink()
{
  TimerBlink->Enabled = False;
  LabelStatus->Visible = True;
}
//---------------------------------------------------------------------------
void __fastcall FreeSendStream()
{
  if (SendStream) {
    SendStream->Free();
    SendStream = NULL;
  }
}
//---------------------------------------------------------------------------
void __fastcall FreeReceiveStream()
{
  if (ReceiveStream) {
    ReceiveStream->Free();
    ReceiveStream = NULL;
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  Label2->Caption = "0";
  Label5->Caption = "0";
  Label9->Caption = "0";
  Label12->Caption = "0";
  Label7->Caption = "";
  Label14->Caption = "";
  BoxCallName->ItemIndex = 2;
  BoxOurName->ItemIndex = 3;
  TempPath = ExtractFilePath(Application->ExeName);
  Edit1->Text = StrToInt(FrameSize);
  UpDown1->Position = 128;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::HowToConnectClick(TObject *Sender)
{
  if ( ! HowToConnect->ItemIndex) {
    BoxCallName->ItemIndex = 2;
    BoxOurName->ItemIndex = 3;
  } else {
    BoxCallName->ItemIndex = 4;
    BoxOurName->ItemIndex = 2;
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::ButtonStartClick(TObject *Sender)
{
  NBLink1->TransportsLAN = NBLink1->SupportedTransportsLAN;
  SavedCallName = BoxCallName->Text;
  NBLink1->OurName = BoxOurName->Text;
  NBLink1->Open(anForce);
  if (NBLink1->NBComponentState.Contains(csOpening)) {
    StartBlink("Open...");
    BoxCallName->Enabled = False;
    BoxOurName->Enabled = False;
    HowToConnect->Enabled = False;
    ButtonStart->Enabled = False;
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::ButtonStopClick(TObject *Sender)
{
  SendButton->Enabled = False;
  CheckBox1->Enabled = False;
  Edit1->Enabled = False;
  UpDown1->Enabled = False;
  ButtonStop->Enabled = False;
  StartBlink("HangUp...");
  NBLink1->HangUp();
}
//---------------------------------------------------------------------------
void __fastcall CalcProgressParams(int FileSize, TProgressBar *ProgressBar,
  int* Divider)
{
  if (FileSize > MAXWORD) {
    *Divider = div(FileSize, MAXWORD).quot;
    if (div(FileSize, MAXWORD).rem > 0) {
      ++*Divider;
    }
    if (*Divider == 0) {
      *Divider = 1;
    }
    ProgressBar->Max = (TProgressRange) div(FileSize, *Divider).quot;
  } else {
    ProgressBar->Max = MAXWORD;
    *Divider = 1;
  }
  ProgressBar->Min = 0;
  ProgressBar->Position = 0;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::SelectButtonClick(TObject *Sender)
{
  TSearchRec SearchRec;
  if (OpenDialog1->Execute()) {
    Src = OpenDialog1->FileName;
    Label7->Caption = Src;
    FindFirst(Src, faAnyFile, SearchRec);
    SendFileSize = SearchRec.Size;
    CalcProgressParams(SendFileSize, ProgressBar1, &SendDivider);
    FindClose(SearchRec);
    Label2->Caption = IntToStr(SendFileSize);
    SendCounter = 0;
    Label5->Caption = IntToStr(SendCounter);
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::SendButtonClick(TObject *Sender)
{
  if (Src != "") {
    SendButton->Enabled = False;
    CheckBox1->Enabled = False;
    Edit1->Enabled = False;
    UpDown1->Enabled = False;
    SendCounter = 0;
    Label5->Caption = IntToStr(SendCounter);
    SendStream = new TFileStream(Src, fmOpenRead);
    ProgressBar1->Position = 0;
    HeaderFile.FileName = Src;
    HeaderFile.FileSize = SendFileSize;
    FrameSize = UpDown1->Position * 512;
    if (FrameSize > MAXWORD) {FrameSize = MAXWORD;}
    if ((CheckBox1->Checked) &&
      (FrameSize > div(MAXWORD, 2).quot)) {
      FrameSize = div(FrameSize, 2).quot;
    }
    NBLink1->Send(sizeof(THeaderFile), &HeaderFile);
  } else
    MessageBeep(0);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::ButtonExitClick(TObject *Sender)
{
  Close();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::NBLink1Open(TObject *Sender, BYTE RetCode)
{
  if (RetCode == NRC_GOODRET) {
    ButtonStop->Enabled = Enabled;
    ((TNBLink*)Sender)->CallName = SavedCallName;
    ((TNBLink*)Sender)->Connect(THowConnect(HowToConnect->ItemIndex));
    if (HowToConnect->ItemIndex)
      StartBlink("Call...");
    else
      StartBlink("Listen...");
  } else {
    MessageBeep(0);
    StopBlink();
    LabelStatus->Caption = "Not Connection";
    BoxCallName->Enabled = True;
    BoxOurName->Enabled = True;
    HowToConnect->Enabled = True;
    ButtonStart->Enabled = True;
    ButtonStop->Enabled = False;
    Application->MessageBox("Error Open!", "Error", MB_ICONSTOP);
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::NBLink1Connect(TObject *Sender, BYTE RetCode)
{
  if (RetCode == NRC_GOODRET) {
    StopBlink();
    MessageBeep(0);
    SendButton->Enabled = True;
    CheckBox1->Enabled = True;
    Edit1->Enabled = True;
    UpDown1->Enabled = True;
    LabelStatus->Caption = "Connected (" +
      ((TNBLink*)Sender)->NameProtocolConnected + ")";
    BoxCallName->Text = ((TNBLink*)Sender)->CallName;
    ((TNBLink*)Sender)->Receive(MaxData);
    FileWait = True;
  } else {
    ((TNBLink*)Sender)->CallName = SavedCallName;
    ((TNBLink*)Sender)->Connect(THowConnect(HowToConnect->ItemIndex));
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::NBLink1Break(TObject *Sender, BYTE RetCode)
{
  MessageBeep(0);
  SendButton->Enabled = False;
  CheckBox1->Enabled = False;
  Edit1->Enabled = False;
  UpDown1->Enabled = False;
  ProgressBar1->Position = 0;
  ProgressBar2->Position = 0;
  FreeSendStream();
  FreeReceiveStream();
  BoxCallName->Text = SavedCallName;
  ((TNBLink*)Sender)->CallName = SavedCallName;
  ((TNBLink*)Sender)->Connect(THowConnect(HowToConnect->ItemIndex));
  if (HowToConnect->ItemIndex)
    StartBlink("Call...");
  else
    StartBlink("Listen...");
}
//---------------------------------------------------------------------------
void __fastcall TForm1::NBLink1HangUp(TObject *Sender, BYTE RetCode)
{
  ProgressBar1->Position = 0;
  ProgressBar2->Position = 0;
  FreeSendStream();
  FreeReceiveStream();
  StartBlink("Close...");
  ((TNBLink*)Sender)->Close();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::NBLink1Close(TObject *Sender, BYTE RetCode)
{
  StopBlink();
  LabelStatus->Caption = "Not Connection";
  BoxCallName->Enabled = True;
  BoxOurName->Enabled = True;
  HowToConnect->Enabled = True;
  ButtonStart->Enabled = True;
  BoxCallName->Text = SavedCallName;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::NBLink1ReceiveData(TObject *Sender, WORD Size,
  Pointer Data,	BYTE RetCode)
{
  switch (RetCode) {
    case NRC_GOODRET:
    case NRC_INCOMP:
      if (FileWait) {
        FileWait = False;
        Dst = TempPath + ExtractFileName(((THeaderFile*)Data)->FileName);
        Label14->Caption = Dst;
        ReceiveFileSize = ((THeaderFile*)Data)->FileSize;
        Label9->Caption = IntToStr(ReceiveFileSize);
        ReceiveCounter = 0;
        Label12->Caption = IntToStr(ReceiveCounter);
        CalcProgressParams(ReceiveFileSize, ProgressBar2, &ReceiveDivider);
        ReceiveStream = new TFileStream(Dst, fmCreate);
      } else {
        if (ReceiveStream)
          ReceiveStream->WriteBuffer(Data, Size);
        ReceiveCounter += Size;
        Label12->Caption = IntToStr(ReceiveCounter);
        ProgressBar2->Position =
          (TProgressRange) div(ReceiveCounter, ReceiveDivider).quot;
        if (ReceiveCounter >= ReceiveFileSize) {
          FreeReceiveStream();
          ProgressBar2->Position = ProgressBar2->Max;
          FileWait = True;
          MessageBeep(0);
        }
      }
      ((TNBLink*)Sender)->Receive(MaxData);
      break;
    case NRC_CMDTMO:
      ((TNBLink*)Sender)->Receive(((TNBLink*)Sender)->ReceiveSize);
      break;
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::NBLink1SendData(TObject *Sender, BYTE RetCode)
{
  switch (RetCode) {
    case NRC_GOODRET:
      ProgressBar1->Position =
        (TProgressRange) div(SendCounter, SendDivider).quot;
      Label5->Caption = IntToStr(SendCounter);
      if (SendCounter >= SendStream->Size) {
        FreeSendStream();
        ((TNBLink*)Sender)->SizeIntSendBuffer = 0;
        ((TNBLink*)Sender)->SizeIntSecondSendBuffer = 0;
        SendButton->Enabled = True;
        CheckBox1->Enabled = True;
        Edit1->Enabled = True;
        UpDown1->Enabled = True;
        ProgressBar1->Position = ProgressBar1->Max;
        MessageBeep(0);
      } else
        if (SendStream) { SendFromStream(); }
      break;
    case NRC_CMDTMO:
      if (CheckBox1->Checked)
        ((TNBLink*)Sender)->ChainSend(((TNBLink*)Sender)->SendSize, NULL,
          ((TNBLink*)Sender)->SecondSendSize, NULL);
      else
        ((TNBLink*)Sender)->Send(((TNBLink*)Sender)->SendSize, NULL);
      break;
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::SendFromStream()
{
  WORD
    FirstSize = 0,
    SecondSize = 0;

  if (SendStream->Size > SendCounter) {
    if (SendStream->Size - SendCounter >= FrameSize)
      FirstSize = (WORD)FrameSize;
    else
      FirstSize = (WORD)(SendStream->Size - SendCounter);
    NBLink1->SizeIntSendBuffer= FirstSize;
    SendStream->ReadBuffer(NBLink1->IntSendBuffer, FirstSize);
    SendCounter += FirstSize;
  }
  if (CheckBox1->Checked) {
    if (SendStream->Size > SendCounter) {
      if (SendStream->Size - SendCounter >= FrameSize)
        SecondSize = (WORD)FrameSize;
      else
        SecondSize = (WORD)(SendStream->Size - SendCounter);
      NBLink1->SizeIntSecondSendBuffer = SecondSize;
      SendStream->ReadBuffer(NBLink1->IntSecondSendBuffer, SecondSize);
      SendCounter += SecondSize;
    }
    NBLink1->ChainSend(FirstSize, NULL, SecondSize, NULL);
  } else
    NBLink1->Send(FirstSize, NULL);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormDestroy(TObject *Sender)
{
  FreeSendStream();
  FreeReceiveStream();
}
//---------------------------------------------------------------------------
