unit MChatSes;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, NBLib32;

type
  TForm1 = class(TForm)
    RecMemo: TMemo;
    SendMemo: TMemo;
    Label1: TLabel;
    Label2: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    HowToConnect: TRadioGroup;
    TimerBlink: TTimer;
    ButtonConnect: TButton;
    ButtonHangUp: TButton;
    NBSession1: TNBSession;
    LabelWait: TLabel;
    ButtonExit: TButton;
    ButtonOpen: TButton;
    ButtonClose: TButton;
    ButtonLocalNames: TButton;
    ButtonMACAddress: TButton;
    ErrorMemo: TMemo;
    Label3: TLabel;
    ComboBoxLana: TComboBox;
    ButtonReset: TButton;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    CheckBox1: TCheckBox;
    BoxCallName: TComboBox;
    BoxOurName: TComboBox;
    procedure ButtonExitClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ButtonOpenClick(Sender: TObject);
    procedure ButtonResetClick(Sender: TObject);
    procedure ButtonCloseClick(Sender: TObject);
    procedure SendMemoKeyPress(Sender: TObject; var Key: Char);
    procedure NBSession1SendData(Sender: TObject; RetCode: Byte);
    procedure NBSession1SendPing(Sender: TObject; RetCode: Byte);
    procedure NBSession1ReceiveData(Sender: TObject; Size: Word;
      Data: Pointer; RetCode: Byte);
    procedure NBSession1ReceivePing(Sender: TObject; Size: Word;
      Data: Pointer; RetCode: Byte);
    procedure NBSession1Open(Sender: TObject; RetCode: Byte);
    procedure NBSession1Close(Sender: TObject; RetCode: Byte);
    procedure NBSession1Connect(Sender: TObject; RetCode: Byte);
    procedure NBSession1HangUp(Sender: TObject; RetCode: Byte);
    procedure NBSession1Error(Sender: TObject; Operation: TNBOperation;
      Lana, ErrorCode: Byte);
    procedure BoxCallNameChange(Sender: TObject);
    procedure TimerBlinkTimer(Sender: TObject);
    procedure ButtonConnectClick(Sender: TObject);
    procedure ButtonHangUpClick(Sender: TObject);
    procedure MemoClear;
    procedure MemoEnabled;
    procedure MemoDisabled;
    procedure StartBlink(S: String);
    procedure StopBlink;
    procedure ComboBoxLanaChange(Sender: TObject);
    procedure ButtonLocalNamesClick(Sender: TObject);
    procedure ButtonMACAddressClick(Sender: TObject);
    function GetValueLana: Byte;
    procedure ErrorMemoDblClick(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

const
  MaxData = MaxSessionData;

type
  PBuffer = ^TBuffer;
  TBuffer = array[0..MaxData - 1] of Char;

var
  Form1: TForm1;

  LanaList: PLanaList;

  CharBuffer: PBuffer;
  OutBuffer: PBuffer;
  InBuffer: PBuffer;

  CountChar: Integer;
  CountInBytes: Integer;
  CountOutBytes: Integer;
  CountInPackets: Integer;
  CountOutPackets: Integer;
  CountInPings: Integer;
  CountOutPings: Integer;
  
  FormHeight: Integer;

implementation

uses Names;

{$R *.DFM}

procedure TForm1.MemoClear;
begin
  RecMemo.Clear;
  SendMemo.Clear;
  SendMemo.Enabled := False;
  CountChar := 0;
  CountInBytes := 0;
  CountOutBytes := 0;
  CountInPackets := 0;
  CountOutPackets := 0;
  CountInPings := 0;
  CountOutPings := 0;
  Label4.Caption := IntToStr(CountInBytes);
  Label5.Caption := IntToStr(CountOutBytes);
  Label7.Caption := IntToStr(CountInPackets);
  Label10.Caption := IntToStr(CountOutPackets);
  Label12.Caption := IntToStr(CountInPings);
  Label14.Caption := IntToStr(CountOutPings);
end;

procedure TForm1.MemoEnabled;
begin
  RecMemo.Color := clWindow;
  SendMemo.Color := clWindow;
  SendMemo.Enabled := True;
  SendMemo.SetFocus;
  CheckBox1.Enabled := False;
end;

procedure TForm1.MemoDisabled;
begin
  RecMemo.Color := clBtnFace;
  SendMemo.Color := clBtnFace;
  RecMemo.Enabled := False;
  SendMemo.Enabled := False;
  CheckBox1.Enabled := True;
end;

procedure TForm1.StartBlink(S: String);
begin
  TimerBlink.Enabled := True;
  LabelWait.Caption := S;
  LabelWait.Visible := True;
end;

procedure TForm1.StopBlink;
begin
  TimerBlink.Enabled := False;
  LabelWait.Visible := False;
end;

procedure TForm1.TimerBlinkTimer(Sender: TObject);
begin
  with LabelWait do Visible := not Visible;
end;

procedure TForm1.ButtonExitClick(Sender: TObject);
begin
  Close;
end;

procedure TForm1.ComboBoxLanaChange(Sender: TObject);
begin
  ButtonOpen.Enabled := False;
end;

function TForm1.GetValueLana: Byte;
begin
  if ComboBoxLana.ItemIndex > -1
    then Result := Byte(ComboBoxLana.Items.Objects[ComboBoxLana.ItemIndex])
    else Result := StrToInt(ComboBoxLana.Text);
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  if CheckBox1.Checked then
  begin
    NBSession1.ExtSendBuffer := nil;
    NBSession1.ExtReceiveBuffer := nil;
  end else
  begin
    NBSession1.ExtSendBuffer := OutBuffer;
    NBSession1.ExtReceiveBuffer := InBuffer;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  I: Integer;
  S: String;
begin
  FormHeight := Form1.Height;

  New(LanaList);
  New(CharBuffer);
  New(OutBuffer);
  New(InBuffer);
  
  NBSession1.ExtSendBuffer := OutBuffer;
  NBSession1.ExtReceiveBuffer := InBuffer;

  GetLanaList(LanaList);
  with ComboBoxLana do
  begin
    Items.BeginUpdate;
    Items.Clear;
    for I := 0 to LanaList.length - 1 do
    begin
      S := IntToStr(LanaList.lana[I].lana_num) + ' - ';
      case LanaList.lana[I].NBProtocol of
        nbNetBEUI: S := S + 'NetBEUI (';
        nbOverIPX: S := S + 'Nb over IPX (';
        else       S := S + 'Nb over TCP (';
      end;
      case LanaList.lana[I].Adapter of
        taLAN:  S := S + 'LAN)';
        taWAN:  S := S + 'WAN)';
      end;
      Items.AddObject(S, Pointer(LanaList.lana[I].lana_num));
    end;
    ItemIndex := 0;
    Items.EndUpdate;
  end;
  Dispose(LanaList);

  BoxCallName.ItemIndex := 1;
  BoxOurName.ItemIndex := 0;

  MemoClear;
  MemoDisabled;
end;

procedure TForm1.ButtonResetClick(Sender: TObject);
var
  RCReset: Byte;
  LanaNum: Byte;
begin
  LanaNum := GetValueLana;
  RCReset := ResetLana(LanaNum, 0, 0, lrAlloc);
  if RCReset = NRC_GOODRET then
  begin
    NBSession1.LanaNumber := LanaNum;
    ButtonOpen.Enabled := True;
    BoxCallName.Enabled := True;
    BoxOurName.Enabled := True;
    MemoClear;
    MemoDisabled;
  end else
  begin
    Beep;
    ShowMessage('Error ResetLana! RetCode = $' + IntToHex(RCReset, 2) +
      ' - ' + GetErrorString(RCReset)+'.');
  end;
end;

procedure TForm1.BoxCallNameChange(Sender: TObject);
begin
  NBSession1.CallName := BoxCallName.Text;
end;

procedure TForm1.ButtonOpenClick(Sender: TObject);
var
  RCOpen: Byte;
begin
  NBSession1.LanaNumber := GetValueLana;
  NBSession1.OurName := BoxOurName.Text;
  RCOpen := NBSession1.Open(anForce);
  case RCOpen of
    NRC_GOODRET,
    NRC_PENDING:
      begin
        BoxOurName.Enabled := False;
        ButtonOpen.Enabled := False;
        ButtonReset.Enabled := False;
        ComboBoxLana.Enabled := False;
        StartBlink('Open...');
      end;
    NRC_NCBBUSY:
      begin
        Beep;
        ShowMessage('The previous command is not completed.');
      end;
  else
    ShowMessage('Start Open Error = $'  + IntToHex(RCOpen, 2) + ' - '+
      GetErrorString(RCOpen) + '.');
  end;
end;

procedure TForm1.ButtonCloseClick(Sender: TObject);
var
  RCClose: Byte;
begin
  RCClose := NBSession1.Close;
  case RCClose of
    NRC_GOODRET,
    NRC_PENDING:
      begin
        MemoDisabled;
        ButtonClose.Enabled := False;
        StartBlink('Close...');
      end;
    NRC_NCBBUSY:
      begin
        Beep;
        ShowMessage('The previous command is not completed.');
      end;
  else
    ShowMessage('Start Close Error = $'  + IntToHex(RCClose, 2) + ' - '+
      GetErrorString(RCClose) + '.');
  end;
end;

procedure TForm1.SendMemoKeyPress(Sender: TObject; var Key: Char);
begin
  if CountChar < MaxData then
  begin
    CharBuffer[CountChar] := Key;
    Inc(CountChar);
  end;
  with NBSession1 do
  begin
    if (csConnected in NBComponentState) and
       not (csSending in NBComponentState) then
    begin
      Send(CountChar, CharBuffer);
      CountChar := 0;
    end;
  end;
end;

procedure TForm1.NBSession1SendData(Sender: TObject; RetCode: Byte);
begin
  with TNBSession(Sender) do
  case RetCode of
    NRC_GOODRET:
    begin
      Inc(CountOutBytes, SendSize + SecondSendSize);
      Label5.Caption := IntToStr(CountOutBytes);
      Inc(CountOutPackets);
      Label10.Caption := IntToStr(CountOutPackets);
      if CountChar > 0 then
      begin
        Send(CountChar, CharBuffer);
        CountChar := 0;
      end;
    end;
    NRC_CMDTMO:
    begin
      Send(SendSize, nil);
    end;
  end;
end;

procedure TForm1.NBSession1SendPing(Sender: TObject; RetCode: Byte);
begin
  if RetCode = NRC_GOODRET then
  begin
    Inc(CountOutPings);
    Label14.Caption := IntToStr(CountOutPings);
  end;
end;

procedure TForm1.NBSession1ReceiveData(Sender: TObject; Size: Word;
  Data: Pointer; RetCode: Byte);
var
  I: Integer;
begin
  with TNBSession(Sender) do
  case RetCode of
    NRC_GOODRET,
    NRC_INCOMP:
    begin
      Inc(CountInBytes, Size);
      Label4.Caption := IntToStr(CountInBytes);
      Inc(CountInPackets);
      Label7.Caption := IntToStr(CountInPackets);
      RecMemo.Lines.BeginUpdate;
      for I := 0 to Size - 1 do
        RecMemo.Perform(WM_CHAR, Ord(TBuffer(Data^)[I]), 0);
      RecMemo.Lines.EndUpdate;
      Receive(MaxData);
    end;
    NRC_CMDTMO:
    begin
      Receive(ReceiveSize);
    end;
  end;
end;

procedure TForm1.NBSession1ReceivePing(Sender: TObject; Size: Word;
  Data: Pointer; RetCode: Byte);
begin
  if RetCode = NRC_GOODRET then
  begin
    Inc(CountInPings);
    Label12.Caption := IntToStr(CountInPings);
  end;
end;

procedure TForm1.NBSession1Open(Sender: TObject; RetCode: Byte);
begin
  StopBlink;
  Beep;
  if RetCode = NRC_GOODRET then
  begin
    ButtonReset.Enabled := False;
    ComboBoxLana.Enabled := False;
    ButtonConnect.Enabled := True;
    HowToConnect.Enabled := True;
    ButtonClose.Enabled := True;
    MemoClear;
  end else
  begin
    BoxOurName.Enabled := True;
    ButtonOpen.Enabled := True;
    ButtonReset.Enabled := True;
    ComboBoxLana.Enabled := True;
  end;
end;

procedure TForm1.NBSession1Close(Sender: TObject; RetCode: Byte);
begin
  StopBlink;
  if RetCode = NRC_GOODRET then
  begin
    ButtonOpen.Enabled := True;
    ButtonReset.Enabled := True;
    ComboBoxLana.Enabled := True;
    BoxOurName.Enabled := True;
    BoxCallName.Enabled := True;
    HowToConnect.Enabled := False;
    ButtonConnect.Enabled := False;
    ButtonHangUp.Enabled := False;
  end;
end;

procedure TForm1.ButtonConnectClick(Sender: TObject);
var
  RCConnect: Byte;
begin
  NBSession1.CallName := BoxCallName.Text;
  RCConnect := NBSession1.Connect(THowConnect(HowToConnect.ItemIndex));
  case RCConnect of
    NRC_GOODRET,
    NRC_PENDING:
      begin
        BoxCallName.Enabled := False;
        HowToConnect.Enabled := False;
        ButtonClose.Enabled := False;
        ButtonConnect.Enabled := False;
        ButtonHangUp.Enabled := True;
        if HowToConnect.ItemIndex = 0
          then StartBlink('Call...')
          else StartBlink('Listen...')
      end;
    NRC_NCBBUSY:
      begin
        Beep;
        ShowMessage('The previous command is not completed.');
      end;
  else
    ShowMessage('Start Connect Error = $' + IntToHex(RCConnect, 2) + ' - '+
      GetErrorString(RCConnect) + '.');
  end;
end;

procedure TForm1.NBSession1Connect(Sender: TObject; RetCode: Byte);
begin
  StopBlink;
  Beep;
  if RetCode = NRC_GOODRET then
  begin
    MemoClear;
    MemoEnabled;
    BoxCallName.Text := NBSession1.CallName;
    NBSession1.Receive(MaxData);
  end else
  begin
    BoxCallName.Enabled := True;
    HowToConnect.Enabled := True;
    ButtonClose.Enabled := True;
    ButtonConnect.Enabled := True;
    ButtonHangUp.Enabled := False;
  end;
end;

procedure TForm1.ButtonHangUpClick(Sender: TObject);
var
  RCHangUp: Byte;
begin
  RCHangUp := NBSession1.HangUp;
  case RCHangUp of
    NRC_GOODRET,
    NRC_PENDING:
      begin
        MemoDisabled;
        ButtonClose.Enabled := False;
        ButtonHangUp.Enabled := False;
        StartBlink('HangUp...');
      end;
    NRC_NCBBUSY:
      begin
        Beep;
        ShowMessage('The previous command is not completed.');
      end;
  else
    ShowMessage('Start HangUp Error = $'  + IntToHex(RCHangUp, 2) + ' - '+
      GetErrorString(RCHangUp) + '.');
  end;
end;

procedure TForm1.NBSession1HangUp(Sender: TObject; RetCode: Byte);
begin
  StopBlink;
  BoxCallName.Enabled := True;
  HowToConnect.Enabled := True;
  ButtonClose.Enabled := True;
  ButtonConnect.Enabled := True;
  ButtonHangUp.Enabled := False;
  MemoDisabled;
end;

procedure TForm1.NBSession1Error(Sender: TObject; Operation: TNBOperation;
  Lana, ErrorCode: Byte);
var
  S: String;
begin
  Beep;
  case Operation of
    opOpen:    S := 'Open';
    opClose:   S := 'Close';
    opConnect: S := 'Connect';
    opSend:    S := 'Send';
    opReceive: S := 'Receive';
  end;

  S := S + ' Error! ErrorCode = $' + IntToHex(ErrorCode, 2) + ' - '+
        GetErrorString(ErrorCode) + '.';

  case ErrorCode of
    NRC_SNUMOUT,
    NRC_SABORT:
      S := S + ' The remote application does not answer or '+
        'there was a fault of the network.';
    NRC_SCLOSED:
      S := S + ' The remote application has completed working in the network.';
  end;

  with ErrorMemo do
  begin
    if not Visible then
    begin
      Form1.Height := FormHeight + 100;
      Top := FormHeight - 20;
      Height := 85;
      Left := 8;
      Width := 400;
      ScrollBars := ssVertical;
      Clear;
      Visible := True;
    end;
    while Lines.Count > 100 do
      Lines.Delete(0);
    Lines.Add(S);
  end;
end;

procedure TForm1.ErrorMemoDblClick(Sender: TObject);
begin
  ErrorMemo.Visible := False;
  Form1.Height := FormHeight;
end;

procedure TForm1.ButtonLocalNamesClick(Sender: TObject);
var
  LanaNum: Byte;
  RCNames: Byte;
begin
  LanaNum := GetValueLana;
  RCNames := GetLocalNames(LanaNum, Form2.Memo1.Lines);
  if RCNames = NRC_GOODRET then
  begin
    Form2.Caption := 'Local Names (Lana ' + IntToStr(LanaNum) + ')';
    Form2.Top := Form1.Top + 130;
    Form2.Left := Form1.Left + 30;
    Form2.Show;
  end else
  begin
    Form2.Memo1.Lines.Clear;
    Form2.Close;
    Beep;
    ShowMessage('Error GetLocalNames! RetCode = $' + IntToHex(RCNames, 2) +
      ' - '+ GetErrorString(RCNames)+'.');
  end;
end;

procedure TForm1.ButtonMACAddressClick(Sender: TObject);
var
  I: Integer;
  LanaNum: Byte;
  RCAddress: Byte;
  MACAddress: TMACAddress;
begin
  LanaNum := GetValueLana;
  RCAddress := GetMACAddress(LanaNum, @MACAddress);
  if RCAddress = NRC_GOODRET then
  begin
    Form2.Memo1.Clear;
    Form2.Memo1.Lines.Add(Format('%2.2x-%2.2x-%2.2x-%2.2x-%2.2x-%2.2x',
      [ord(MACAddress[0]),
       ord(MACAddress[1]),
       ord(MACAddress[2]),
       ord(MACAddress[3]),
       ord(MACAddress[4]),
       ord(MACAddress[5])]));
    Form2.Caption := 'MAC Address (Lana ' + IntToStr(LanaNum) + ')';
    Form2.Top := Form1.Top + 130;
    Form2.Left := Form1.Left + 30;
    Form2.Show;
  end else
  begin
    Form2.Close;
    Beep;
    ShowMessage('Error GetMACAddress! RetCode = $' + IntToHex(RCAddress, 2) +
      ' - '+ GetErrorString(RCAddress)+'.');
  end;
end;


end.
