unit MChatSrv;

interface

uses
  Wintypes, Winprocs, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, NBLib16;

type
  TForm1 = class(TForm)
    BoxOurName: TEdit;
    Label1: TLabel;
    ButtonStart: TButton;
    ButtonStop: TButton;
    ButtonExit: TButton;
    Label2: TLabel;
    Memo1: TMemo;
    Label3: TLabel;
    Label4: TLabel;
    TimerBlink: TTimer;
    LabelStatus: TLabel;
    NBLink: TNBLink;
    procedure StartBlink(S: String);
    procedure StopBlink;
    function CreateNewLink: TNBLink;
    procedure ButtonExitClick(Sender: TObject);
    procedure ButtonStartClick(Sender: TObject);
    procedure NBLinkOpen(Sender: TObject; RetCode: Byte);
    procedure NBLinkClose(Sender: TObject; RetCode: Byte);
    procedure NBLinkConnect(Sender: TObject; RetCode: Byte);
    procedure NBLinkHangUp(Sender: TObject; RetCode: Byte);
    procedure FormCreate(Sender: TObject);
    procedure TimerBlinkTimer(Sender: TObject);
    procedure NBLinkBreak(Sender: TObject; RetCode: Byte);
    procedure NBLinkReceiveData(Sender: TObject; Size: Word;
      Data: Pointer; RetCode: Byte);
    procedure NBLinkSendData(Sender: TObject; RetCode: Byte);
    procedure ButtonStopClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses MChat;

var
  CurrentLink: TNBLink;
  LinkList: TList;
  ConnectCount: Integer;

procedure Beep;
begin
  MessageBeep(0);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Memo1.Lines.Clear;
  LinkList := TList.Create;
end;

procedure TForm1.TimerBlinkTimer(Sender: TObject);
begin
  with LabelStatus do Visible := not Visible;
end;

procedure TForm1.StartBlink(S: String);
begin
  TimerBlink.Enabled := True;
  LabelStatus.Caption := S;
  LabelStatus.Visible := True;
end;

procedure TForm1.StopBlink;
begin
  TimerBlink.Enabled := False;
  LabelStatus.Visible := False;
end;

procedure TForm1.ButtonExitClick(Sender: TObject);
begin
  Close;
end;

function TForm1.CreateNewLink: TNBLink;
begin
  Result := TNBLink.Create(Self);
  Result.TransportsLAN := NBLink.SupportedTransportsLAN;
  Result.PingInterval := NBLink.PingInterval;
  Result.ReceiveTimeout := NBLink.ReceiveTimeout;
  Result.SendTimeout := NBLink.SendTimeout;
  Result.CallName := NBLink.CallName;
  Result.OurName := NBLink.OurName;
  Result.OnOpen := NBLink.OnOpen;
  Result.OnClose := NBLink.OnClose;
  Result.OnConnect := NBLink.OnConnect;
  Result.OnBreak := NBLink.OnBreak;
  Result.OnHangUp := NBLink.OnHangUp;
  Result.OnReceiveData := NBLink.OnReceiveData;
  Result.OnSendData := NBLink.OnSendData;
  Result.ReceiveTimeout := NBLink.ReceiveTimeout;
  Result.SendTimeout := NBLink.SendTimeout;
  Result.PingInterval := NBLink.PingInterval;
end;

procedure TForm1.ButtonStartClick(Sender: TObject);
var
  D: String;
begin
  NBLink.CallName := '*';
  D := NBLink.CallName;
  NBLink.OurName := BoxOurName.Text;
  NBLink.Open(anForce);
  if csOpening in NBLink.NBComponentState then
  begin
    StartBlink('Open...');
    BoxOurName.Enabled := False;
    ButtonStart.Enabled := False;
  end;
end;

procedure TForm1.ButtonStopClick(Sender: TObject);
begin
  CurrentLink.HangUp;
end;

procedure TForm1.NBLinkOpen(Sender: TObject; RetCode: Byte);
begin
  if RetCode = NRC_GOODRET then
  begin
    if Sender = NBLink then
    begin
      CurrentLink := CreateNewLink;
      CurrentLink.Open(anAuto);
    end else
    begin
      StartBlink('Working...');
      ButtonStop.Enabled := True;
      TNBLink(Sender).Connect(hcListen);
    end;
  end else
  begin
    Beep;
    StopBlink;
    LabelStatus.Caption := 'Stop';
    BoxOurName.Enabled := True;
    ButtonStart.Enabled := True;
    ButtonStop.Enabled := False;
    Application.MessageBox('Error Open!', 'Error', MB_ICONSTOP);
  end;
end;

procedure TForm1.NBLinkClose(Sender: TObject; RetCode: Byte);
var
  Link: TNBLink;
  IndexLink: Integer;
  I: Integer;
begin
  Link := TNBLink(Sender);
  if Link = CurrentLink then
  begin
    for I := 0 to LinkList.Count - 1 do
    begin
      TChatForm(TNBLink(LinkList[I]).UsedObject).Free;
      TNBLink(LinkList[I]).Free;
    end;
    Memo1.Lines.Clear;
    LinkList.Clear;
    NBLink.Close;
  end else
  begin
    if Link = NBLink then
    begin
      Beep;
      StopBlink;
      BoxOurName.Enabled := True;
      ButtonStart.Enabled := True;
      ButtonStop.Enabled := False;
    end else
    begin
      IndexLink := LinkList.IndexOf(Link);
      if IndexLink > -1 then
      begin
        TChatForm(TNBLink(LinkList[IndexLink]).UsedObject).Free;
        TNBLink(LinkList[IndexLink]).Free;
        LinkList.Delete(IndexLink);
        Memo1.Lines.Delete(IndexLink);
      end;
      if ConnectCount > 0 then Dec(ConnectCount);
      Label4.Caption := IntToStr(ConnectCount);
    end;
  end;
end;

procedure TForm1.NBLinkConnect(Sender: TObject; RetCode: Byte);
var
  Link: TNBLink;
  ChatForm: TChatForm;
  S: String;
begin
  if RetCode = NRC_GOODRET then
  begin
    Link := TNBLink(Sender);
    Memo1.Lines.Add(Link.CallName);
    LinkList.Add(Link);
    ChatForm := TChatForm.Create(Self);
    ChatForm.ChatLink := Link;
    Link.UsedObject := ChatForm;
    ChatForm.Caption := 'Connection to ' + Link.CallName +
     ' (via ' + TNBLink(Sender).NameProtocolConnected + ')';
    ChatForm.Show;
    Link.Receive(MaxData);
    S := 'Hello from ' + NBLink.OurName + '!' + #13#10;
    Link.Send(length(S), @S[1]);
    CurrentLink := CreateNewLink; { Start next Link }
    CurrentLink.Open(anAuto);
    Inc(ConnectCount);
    Label4.Caption := IntToStr(ConnectCount);
  end;
end;

procedure TForm1.NBLinkHangUp(Sender: TObject; RetCode: Byte);
begin
  TNBLink(Sender).Close;
end;

procedure TForm1.NBLinkBreak(Sender: TObject; RetCode: Byte);
begin
  TNBLink(Sender).Close;
end;

procedure TForm1.NBLinkReceiveData(Sender: TObject; Size: Word;
  Data: Pointer; RetCode: Byte);
var
  I: Integer;
  ChatForm: TChatForm;
begin
  with TNBLink(Sender) do
  case RetCode of
    NRC_GOODRET,
    NRC_INCOMP:
    begin
      ChatForm := TChatForm(UsedObject);
      ChatForm.RecMemo.Lines.BeginUpdate;
      for I := 0 to Size - 1 do
        ChatForm.RecMemo.Perform(WM_CHAR, Ord(TBuffer(Data^)[I]), 0);
      ChatForm.RecMemo.Lines.EndUpdate;
      Receive(MaxData);
    end;
    NRC_CMDTMO:
    begin
      Receive(ReceiveSize);
    end;
  end;
end;

procedure TForm1.NBLinkSendData(Sender: TObject; RetCode: Byte);
var
  ChatForm: TChatForm;
begin
  with TNBLink(Sender) do
  case RetCode of
    NRC_GOODRET:
    begin
      ChatForm := TChatForm(UsedObject);
      if ChatForm.CountChar > 0 then
      begin
        Send(ChatForm.CountChar, ChatForm.CharBuffer);
        ChatForm.CountChar := 0;
      end;
    end;
    NRC_CMDTMO:
    begin
      Send(SendSize, nil);
    end;
  end;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  LinkList.Free;
end;

end.
