//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "MChatDtg.h"
#include "Names.h"
//---------------------------------------------------------------------------
#pragma link "NBLib32"
#pragma resource "*.dfm"
TForm1 *Form1;

#define MaxData MaxDatagramData

typedef char* PBuffer;
PLanaList LanaList;
PBuffer CharBuffer;
PBuffer InBuffer;
PBuffer OutBuffer;
WORD CountChar;
int CountInBytes;
int CountOutBytes;
int CountInPackets;
int CountOutPackets;
int FormHeight;
int DebCount = 0;

//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::MemoClear()
{
  RecMemo->Clear();
  SendMemo->Clear();
  SendMemo->Enabled = False;
  CountChar = 0;
  CountInBytes = 0;
  CountOutBytes = 0;
  CountInPackets = 0;
  CountOutPackets = 0;
  Label4->Caption = IntToStr(CountInBytes);
  Label5->Caption = IntToStr(CountOutBytes);
  Label7->Caption = IntToStr(CountInPackets);
  Label10->Caption = IntToStr(CountOutPackets);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::MemoEnabled()
{
  RecMemo->Color = clWindow;
  SendMemo->Color = clWindow;
  SendMemo->Enabled = True;
  SendMemo->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::MemoDisabled()
{
  RecMemo->Color = clBtnFace;
  SendMemo->Color = clBtnFace;
  RecMemo->Enabled = False;
  SendMemo->Enabled = False;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::StartBlink(AnsiString S)
{
  TimerBlink->Enabled = True;
  LabelWait->Caption = S;
  LabelWait->Visible = True;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::StopBlink()
{
  TimerBlink->Enabled = False;
  LabelWait->Visible = False;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::ButtonExitClick(TObject *Sender)
{
  Close();
}
//---------------------------------------------------------------------------
BYTE __fastcall TForm1::GetValueLana()
{
  if (ComboBoxLana->ItemIndex > -1) {
    return Byte(ComboBoxLana->Items->Objects[ComboBoxLana->ItemIndex]);
  }
    else return Byte(StrToInt(ComboBoxLana->Text));
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  AnsiString S;

  FormHeight = Form1->Height;

  LanaList = new TLanaList;
  CharBuffer = new char[MaxData];
  OutBuffer  = new char[MaxData];
  InBuffer   = new char[MaxData];

  NBDatagram1->ExtSendBuffer = OutBuffer;
  NBDatagram1->ExtReceiveBuffer = InBuffer;

  GetLanaList(LanaList);
  ComboBoxLana->Items->BeginUpdate();
  ComboBoxLana->Items->Clear();
  for (int i = 0; i < (*LanaList).length; i++)
  {
    S = IntToStr((*LanaList).lana[i].lana_num) + " - ";
    switch ((*LanaList).lana[i].NBProtocol)
    {
      case nbNetBEUI:
        S = S + "NetBEUI (";
        break;
      case nbOverIPX:
        S = S + "Nb over IPX (";
        break;
      default:
        S = S + "Nb over TCP (";
    }
    switch ((*LanaList).lana[i].Adapter)
    {
      case taLAN:
        S = S + "LAN)";
        break;
      case taWAN:
        S = S + "WAN)";
        break;
    }
    ComboBoxLana->Items->AddObject(S, (TObject*)(*LanaList).lana[i].lana_num);
  }
  ComboBoxLana->ItemIndex = 0;
  ComboBoxLana->Items->EndUpdate();
  delete LanaList;

  BoxCallName->ItemIndex = 1;
  BoxOurName->ItemIndex = 0;

  MemoClear();
  MemoDisabled();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::ComboBoxLanaChange(TObject *Sender)
{
  ButtonOpen->Enabled = False;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::TimerBlinkTimer(TObject *Sender)
{
  LabelWait->Visible = ! LabelWait->Visible;	
}
//---------------------------------------------------------------------------
void __fastcall TForm1::BoxCallNameChange(TObject *Sender)
{
  NBDatagram1->CallName = BoxCallName->Text;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::ButtonResetClick(TObject *Sender)
{
  BYTE RCReset;
  BYTE LanaNum;

  LanaNum = GetValueLana();
  RCReset = ResetLana(LanaNum, 0, 0, lrAlloc);
  if (RCReset == NRC_GOODRET) {
    NBDatagram1->LanaNumber = LanaNum;
    ButtonOpen->Enabled = True;
    BoxCallName->Enabled = True;
    BoxOurName->Enabled = True;
    MemoClear();
    MemoDisabled();
  } else {
      ShowMessage("Error ResetLana! RetCode = $" + IntToHex(RCReset, 2) +
        " - "+ GetErrorString(RCReset)+".");
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::SendMemoKeyPress(TObject *Sender, char &Key)
{
  if (CountChar < MaxData) {
    CharBuffer[CountChar++] = Key;
  }
  if ( ! NBDatagram1->NBComponentState.Contains(csSending)) {
    switch (TypeOfExchange->ItemIndex) {
      case 0:
        NBDatagram1->Send(CountChar, CharBuffer);
        break;
      case 1:
        NBDatagram1->SendBroadcast(CountChar, CharBuffer);
        break;
    }
    CountChar = 0;
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::ButtonOpenClick(TObject *Sender)
{
  BYTE RCOpen;

  NBDatagram1->LanaNumber = GetValueLana();
  NBDatagram1->CallName = BoxCallName->Text;
  NBDatagram1->OurName = BoxOurName->Text;
  RCOpen = NBDatagram1->Open(anForce);
  switch (RCOpen) {
    case NRC_GOODRET:
    case NRC_PENDING:
      BoxOurName->Enabled = False;
      ButtonOpen->Enabled = False;
      ButtonReset->Enabled = False;
      ComboBoxLana->Enabled = False;
      StartBlink("Open...");
      break;
    case NRC_NCBBUSY:
      MessageBeep(0);
      ShowMessage("The previous command is not completed.");
      break;
    default:
      ShowMessage("Start Open Error = $" + IntToHex(RCOpen, 2) +
        " - "+ GetErrorString(RCOpen)+".");
      break;
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::ButtonCloseClick(TObject *Sender)
{
  BYTE RCClose;

  RCClose = NBDatagram1->Close();
  switch (RCClose) {
    case NRC_GOODRET:
    case NRC_PENDING:
      MemoDisabled();
      ButtonClose->Enabled = False;
      StartBlink("Close...");
      break;
    case NRC_NCBBUSY:
      MessageBeep(0);
      ShowMessage("The previous command is not completed.");
      break;
    default:
      ShowMessage("Start Close Error = $" + IntToHex(RCClose, 2) +
        " - "+ GetErrorString(RCClose)+".");
      break;
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::NBDatagram1Open(TObject *Sender, BYTE RetCode)
{
  StopBlink();
  MessageBeep(0);
  if (RetCode == NRC_GOODRET) {
    switch (TypeOfExchange->ItemIndex) {
      case 0:
        ((TNBDatagram*)Sender)->Receive(MaxData);
        break;
      case 1:
        ((TNBDatagram*)Sender)->ReceiveBroadcast(MaxData);
        break;
    }
    TypeOfExchange->Enabled = False;
    ButtonReset->Enabled = False;
    ComboBoxLana->Enabled = False;
    ButtonClose->Enabled = True;
    MemoClear();
    MemoEnabled();
  } else {
    BoxOurName->Enabled = True;
    ButtonOpen->Enabled = True;
    ButtonReset->Enabled = True;
    ComboBoxLana->Enabled = True;
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::NBDatagram1SendData(TObject *Sender, BYTE RetCode)
{
  if (RetCode == NRC_GOODRET) {
    CountOutBytes += ((TNBDatagram*)Sender)->SendSize;
    Label5->Caption = IntToStr(CountOutBytes);
    ++CountOutPackets;
    Label10->Caption = IntToStr(CountOutPackets);
    if (CountChar > 0) {
      switch (TypeOfExchange->ItemIndex) {
        case 0:
          NBDatagram1->Send(CountChar, CharBuffer);
          break;
        case 1:
          NBDatagram1->SendBroadcast(CountChar, CharBuffer);
          break;
      }
      CountChar = 0;
    }
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::NBDatagram1ReceiveData(TObject *Sender, WORD Size,
	Pointer Data, BYTE RetCode)
{
  if (RetCode == NRC_GOODRET) {
    CountInBytes += Size;
    Label4->Caption = IntToStr(CountInBytes);
    ++CountInPackets;
    Label7->Caption = IntToStr(CountInPackets);
    RecMemo->Lines->BeginUpdate();
    for (int i = 0; i < Size; i++)
      RecMemo->Perform(WM_CHAR, ((char*) Data)[i], 0);
    RecMemo->Lines->EndUpdate();

    switch (TypeOfExchange->ItemIndex) {
      case 0:
        ((TNBDatagram*)Sender)->Receive(MaxData);
        break;
      case 1:
        ((TNBDatagram*)Sender)->ReceiveBroadcast(MaxData);
        break;
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::NBDatagram1Close(TObject *Sender, BYTE RetCode)
{
  StopBlink();
  if (RetCode == NRC_GOODRET) {
    MessageBeep(0);
    MemoDisabled();
    ButtonOpen->Enabled = True;
    ButtonReset->Enabled = True;
    ComboBoxLana->Enabled = True;
    BoxOurName->Enabled = True;
    TypeOfExchange->Enabled = True;
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::NBDatagram1Error(TObject *Sender,
	TNBOperation Operation, BYTE Lana, BYTE ErrorCode)
{
  AnsiString S;
  StopBlink();
  MessageBeep(0);
  switch (Operation) {
    case opOpen:
      S = "Open";
      break;
    case opSend:
      S = "Send";
      break;
    case opReceive:
      S = "Receive";
      break;
    case opClose:
      S = "Close";
      break;
  }
  S = S + " Error ! ErrorCode = $" + IntToHex(ErrorCode, 2) + " - " +
    GetErrorString(ErrorCode) + ".";

  if (!(ErrorMemo->Visible)) {
    Form1->Height = FormHeight + 100;
    ErrorMemo->Top = FormHeight - 20;
    ErrorMemo->Height = 85;
    ErrorMemo->Left = 8;
    ErrorMemo->Width = 400;
    ErrorMemo->ScrollBars = ssVertical;
    ErrorMemo->Clear();
    ErrorMemo->Visible = True;
  }
  while (ErrorMemo->Lines->Count > 100) {
    ErrorMemo->Lines->Delete(0);
  }
  ErrorMemo->Lines->Add(S);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::ButtonLocalNamesClick(TObject *Sender)
{
  BYTE LanaNum;
  BYTE RCNames;

  LanaNum = GetValueLana();
  RCNames = GetLocalNames(LanaNum, Form2->Memo1->Lines);
  if (RCNames == NRC_GOODRET) {
    Form2->Caption = "Local Names (Lana " + IntToStr(LanaNum) + ")";
    Form2->Top = Form1->Top + 130;
    Form2->Left = Form1->Left + 30;
    Form2->Show();
  } else {
    Form2->Close();
    MessageBeep(0);
      ShowMessage("Error GetLocalNames! RetCode = $" + IntToHex(RCNames, 2) +
        " - "+ GetErrorString(RCNames)+".");
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::ButtonMACAddressClick(TObject *Sender)
{
  AnsiString S;
  BYTE LanaNum;
  BYTE RCAddress;
  TMACAddress MACAddress;

  LanaNum = GetValueLana();
  RCAddress = GetMACAddress(LanaNum, (TMACAddress*)MACAddress);
  if (RCAddress == NRC_GOODRET) {
    S = "";
    for (int i = 0; i <= 5; i++) {
      S = S + IntToHex(BYTE(MACAddress[i]), 2);
      if (i < 5) S = S + "-";
    }
    Form2->Memo1->Clear();
    Form2->Memo1->Lines->Add(S);
    Form2->Caption = "MAC Address (Lana " + IntToStr(LanaNum) + ")";
    Form2->Top = Form1->Top + 130;
    Form2->Left = Form1->Left + 30;
    Form2->Show();
  } else {
    Form2->Close();
    MessageBeep(0);
      ShowMessage("Error GetMACAddress! RetCode = $" + IntToHex(RCAddress, 2) +
        " - "+ GetErrorString(RCAddress)+".");
  }
}
//---------------------------------------------------------------------------


void __fastcall TForm1::ErrorMemoDblClick(TObject *Sender)
{
  ErrorMemo->Visible = False;
  Form1->Height = FormHeight;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::CheckBox1Click(TObject *Sender)
{
  if (CheckBox1->Checked) {
    NBDatagram1->ExtSendBuffer = NULL;
    NBDatagram1->ExtReceiveBuffer = NULL;
  } else {
    NBDatagram1->ExtSendBuffer = OutBuffer;
    NBDatagram1->ExtReceiveBuffer = InBuffer;
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Timer1Timer(TObject *Sender)
{
   Label5->Caption = IntToStr(CountOutBytes);
}
//---------------------------------------------------------------------------
